/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.converter;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.authorization.util.UserGroupUtil;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;

public class StandardJwtAuthenticationConverter
implements Converter<Jwt, NiFiAuthenticationToken> {
    private final Authorizer authorizer;
    private final List<IdentityMapping> identityMappings;

    public StandardJwtAuthenticationConverter(Authorizer authorizer, NiFiProperties properties) {
        this.authorizer = authorizer;
        this.identityMappings = IdentityMappingUtil.getIdentityMappings((NiFiProperties)properties);
    }

    public NiFiAuthenticationToken convert(Jwt jwt) {
        NiFiUser user = this.getUser(jwt);
        return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails(user));
    }

    private NiFiUser getUser(Jwt jwt) {
        String identity = IdentityMappingUtil.mapIdentity((String)jwt.getSubject(), this.identityMappings);
        Set<String> providedGroups = this.getProvidedGroups(jwt);
        return new StandardNiFiUser.Builder().identity(identity).groups(UserGroupUtil.getUserGroups((Authorizer)this.authorizer, (String)identity)).identityProviderGroups(providedGroups).build();
    }

    private Set<String> getProvidedGroups(Jwt jwt) {
        List claimGroups = jwt.getClaimAsStringList(SupportedClaim.GROUPS.getClaim());
        Set<String> providedGroups = claimGroups == null ? Collections.emptySet() : new LinkedHashSet<String>(claimGroups);
        return providedGroups;
    }
}

