/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime.manifest.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.extension.manifest.ExtensionManifest;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.runtime.manifest.ExtensionManifestContainer;
import org.apache.nifi.runtime.manifest.ExtensionManifestProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryExtensionManifestProvider
implements ExtensionManifestProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryExtensionManifestProvider.class);
    private final File baseDir;
    private final ExtensionManifestParser extensionManifestParser;

    public DirectoryExtensionManifestProvider(File baseDir, ExtensionManifestParser extensionManifestParser) {
        this.baseDir = baseDir;
        this.extensionManifestParser = extensionManifestParser;
    }

    @Override
    public List<ExtensionManifestContainer> getExtensionManifests() {
        if (!this.baseDir.exists()) {
            throw new IllegalArgumentException("The specified manifest directory does not exist");
        }
        if (!this.baseDir.isDirectory()) {
            throw new IllegalArgumentException("The specified manifest location is not a directory");
        }
        LOGGER.info("Loading extension manifests from: {}", (Object)this.baseDir.getAbsolutePath());
        ArrayList<ExtensionManifestContainer> extensionManifests = new ArrayList<ExtensionManifestContainer>();
        for (File manifestDir : this.baseDir.listFiles()) {
            if (!manifestDir.isDirectory()) {
                LOGGER.debug("Skipping [{}], not a directory...", (Object)manifestDir.getAbsolutePath());
                continue;
            }
            File manifestFile = new File(manifestDir, "META-INF/docs/extension-manifest.xml");
            LOGGER.debug("Loading extension manifest file [{}]", (Object)manifestFile.getAbsolutePath());
            ExtensionManifest extensionManifest = this.loadExtensionManifest(manifestFile);
            Map<String, String> additionalDetails = this.loadAdditionalDetails(manifestDir);
            ExtensionManifestContainer container = new ExtensionManifestContainer(extensionManifest, additionalDetails);
            extensionManifests.add(container);
            LOGGER.debug("Successfully loaded extension manifest for [{}-{}-{}]", new Object[]{extensionManifest.getGroupId(), extensionManifest.getArtifactId(), extensionManifest.getVersion()});
        }
        LOGGER.info("Loaded {} extension manifests", (Object)extensionManifests.size());
        return extensionManifests;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExtensionManifest loadExtensionManifest(File manifestFile) {
        try (FileInputStream inputStream = new FileInputStream(manifestFile);){
            ExtensionManifest extensionManifest = this.extensionManifestParser.parse((InputStream)inputStream);
            return extensionManifest;
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to load extension manifest: " + manifestFile.getAbsolutePath(), ioException);
        }
    }

    private Map<String, String> loadAdditionalDetails(File manifestDir) {
        LinkedHashMap<String, String> additionalDetailsMap = new LinkedHashMap<String, String>();
        File additionalDetailsDir = new File(manifestDir, "META-INF/docs/additional-details");
        if (!additionalDetailsDir.exists()) {
            LOGGER.debug("No additional-details directory found under [{}]", (Object)manifestDir.getAbsolutePath());
            return additionalDetailsMap;
        }
        for (File additionalDetailsTypeDir : additionalDetailsDir.listFiles()) {
            if (!additionalDetailsTypeDir.isDirectory()) {
                LOGGER.debug("Skipping [{}], not a directory...", (Object)additionalDetailsTypeDir.getAbsolutePath());
                continue;
            }
            File additionalDetailsFile = new File(additionalDetailsTypeDir, "additionalDetails.html");
            if (!additionalDetailsFile.exists()) {
                LOGGER.debug("No additionalDetails.html found under [{}]", (Object)additionalDetailsTypeDir.getAbsolutePath());
                continue;
            }
            try {
                String typeName = additionalDetailsTypeDir.getName();
                byte[] additionalDetailsBytes = Files.readAllBytes(additionalDetailsFile.toPath());
                LOGGER.debug("Added additionalDetails for {} from {}", (Object)typeName, (Object)additionalDetailsFile.getAbsolutePath());
                additionalDetailsMap.put(typeName, new String(additionalDetailsBytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load additional details content for " + additionalDetailsFile.getAbsolutePath() + " due to: " + e.getMessage(), e);
            }
        }
        return additionalDetailsMap;
    }
}

