/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.log.Log;
import io.questdb.metrics.HealthMetrics;
import io.questdb.mp.Job;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.Worker;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class WorkerPool
implements Closeable {
    private static final HealthMetrics DISABLED = new HealthMetrics(){

        @Override
        public void incrementUnhandledErrors() {
        }

        @Override
        public long unhandledErrorsCount() {
            return 0L;
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean();
    private final boolean daemons;
    private final ObjList<Closeable> freeOnExit = new ObjList();
    private final boolean haltOnError;
    private final SOCountDownLatch halted;
    private final HealthMetrics metrics;
    private final String poolName;
    private final AtomicBoolean running = new AtomicBoolean();
    private final long sleepMs;
    private final long sleepThreshold;
    private final SOCountDownLatch started = new SOCountDownLatch(1);
    private final ObjList<ObjList<Closeable>> threadLocalCleaners;
    private final int[] workerAffinity;
    private final int workerCount;
    private final ObjList<ObjHashSet<Job>> workerJobs;
    private final ObjList<Worker> workers = new ObjList();
    private final long yieldThreshold;

    public WorkerPool(WorkerPoolConfiguration configuration) {
        this(configuration, DISABLED);
    }

    public WorkerPool(WorkerPoolConfiguration configuration, HealthMetrics metrics) {
        this.workerCount = configuration.getWorkerCount();
        int[] workerAffinity = configuration.getWorkerAffinity();
        this.workerAffinity = workerAffinity != null && workerAffinity.length > 0 ? workerAffinity : Misc.getWorkerAffinity(this.workerCount);
        this.halted = new SOCountDownLatch(this.workerCount);
        this.haltOnError = configuration.haltOnError();
        this.daemons = configuration.isDaemonPool();
        this.poolName = configuration.getPoolName();
        this.yieldThreshold = configuration.getYieldThreshold();
        this.sleepThreshold = configuration.getSleepThreshold();
        this.sleepMs = configuration.getSleepTimeout();
        this.metrics = metrics;
        assert (this.workerAffinity.length == this.workerCount);
        this.workerJobs = new ObjList(this.workerCount);
        this.threadLocalCleaners = new ObjList(this.workerCount);
        for (int i = 0; i < this.workerCount; ++i) {
            this.workerJobs.add(new ObjHashSet());
            this.threadLocalCleaners.add(new ObjList());
        }
    }

    public void assign(Job job) {
        assert (!this.running.get() && !this.closed.get());
        for (int i = 0; i < this.workerCount; ++i) {
            this.workerJobs.getQuick(i).add(job);
        }
    }

    public void assign(int worker, Job job) {
        assert (worker > -1 && worker < this.workerCount && !this.running.get() && !this.closed.get());
        this.workerJobs.getQuick(worker).add(job);
    }

    public void assignThreadLocalCleaner(int worker, Closeable cleaner) {
        assert (worker > -1 && worker < this.workerCount && !this.running.get() && !this.closed.get());
        this.threadLocalCleaners.getQuick(worker).add(cleaner);
    }

    @Override
    public void close() {
        this.halt();
    }

    public void freeOnExit(Closeable closeable) {
        assert (!this.running.get() && !this.closed.get());
        this.freeOnExit.add(closeable);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void halt() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.running.compareAndSet(true, false)) {
                this.started.await();
                for (int i = 0; i < this.workerCount; ++i) {
                    this.workers.getQuick(i).halt();
                }
                this.halted.await();
            }
            this.workers.clear();
            Misc.freeObjListAndClear(this.freeOnExit);
        }
    }

    public void pause() {
        if (this.running.compareAndSet(true, false)) {
            this.started.await();
            for (int i = 0; i < this.workerCount; ++i) {
                this.workers.getQuick(i).halt();
            }
            this.halted.await();
        }
        this.workers.clear();
    }

    public void start() {
        this.start(null);
    }

    public void start(@Nullable Log log) {
        if (!this.closed.get() && this.running.compareAndSet(false, true)) {
            this.setupPathCleaner();
            for (int i = 0; i < this.workerCount; ++i) {
                int index = i;
                Worker worker = new Worker(this.workerJobs.getQuick(i), this.halted, this.workerAffinity[i], log, ex -> {
                    Misc.freeObjListAndClear(this.threadLocalCleaners.getQuick(index));
                    if (log != null) {
                        log.info().$("cleaned worker [name=").$(this.poolName).$(", worker=").$(index).$(", total=").$(this.workerCount).I$();
                    }
                }, this.haltOnError, i, this.poolName, this.yieldThreshold, this.sleepThreshold, this.sleepMs, this.metrics);
                worker.setDaemon(this.daemons);
                this.workers.add(worker);
                worker.start();
            }
            if (log != null) {
                log.info().$("worker pool started [pool=").$(this.poolName).I$();
            }
            this.started.countDown();
        }
    }

    private void setupPathCleaner() {
        for (int i = 0; i < this.workerCount; ++i) {
            this.threadLocalCleaners.getQuick(i).add(Path.THREAD_LOCAL_CLEANER);
        }
    }
}

