/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.wal.OperationCompiler;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.ops.AbstractOperation;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.griffin.engine.ops.UpdateOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntLongHashMap;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import io.questdb.tasks.WalTxnNotificationTask;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class ApplyWal2TableJob
extends AbstractQueueConsumerJob<WalTxnNotificationTask>
implements Closeable {
    public static final String WAL_2_TABLE_RESUME_REASON = "Resume WAL Data Application";
    private static final Log LOG = LogFactory.getLog(ApplyWal2TableJob.class);
    private static final String WAL_2_TABLE_WRITE_REASON = "WAL Data Application";
    private static final int WAL_APPLY_FAILED = -2;
    private final CairoEngine engine;
    private final IntLongHashMap lastAppliedSeqTxns = new IntLongHashMap();
    private final OperationCompiler operationCompiler;
    private final WalEventReader walEventReader;

    public ApplyWal2TableJob(CairoEngine engine, int workerCount, int sharedWorkerCount, @Nullable FunctionFactoryCache ffCache) {
        super(engine.getMessageBus().getWalTxnNotificationQueue(), engine.getMessageBus().getWalTxnNotificationSubSequence());
        this.engine = engine;
        this.operationCompiler = new OperationCompiler(engine, workerCount, sharedWorkerCount, ffCache);
        this.walEventReader = new WalEventReader(engine.getConfiguration().getFilesFacade());
    }

    public long applyWAL(TableToken tableToken, CairoEngine engine, OperationCompiler operationCompiler) {
        long lastSequencerTxn = -1L;
        long lastWriterTxn = -1L;
        Path tempPath = Path.PATH.get();
        try {
            do {
                TableToken updatedToken;
                if ((updatedToken = engine.getUpdatedTableToken(tableToken)) == null) {
                    if (engine.isTableDropped(tableToken)) {
                        return ApplyWal2TableJob.tryDestroyDroppedTable(tableToken, null, engine, tempPath) ? Long.MAX_VALUE : -1L;
                    }
                    return Long.MAX_VALUE;
                }
                if (!engine.isWalTable(tableToken)) {
                    LOG.info().$("table '").utf8(tableToken.getDirName()).$("' does not exist, skipping WAL application").$();
                    return 0L;
                }
                try (TableWriter writer = engine.getWriterUnsafe(updatedToken, WAL_2_TABLE_WRITE_REASON);){
                    assert (writer.getMetadata().getTableId() == tableToken.getTableId());
                    this.applyOutstandingWalTransactions(tableToken, writer, engine, operationCompiler, tempPath);
                    lastWriterTxn = writer.getSeqTxn();
                }
                catch (EntryUnavailableException tableBusy) {
                    if (!WAL_2_TABLE_WRITE_REASON.equals(tableBusy.getReason()) && !WAL_2_TABLE_RESUME_REASON.equals(tableBusy.getReason())) {
                        LOG.critical().$("unsolicited table lock [table=").utf8(tableToken.getDirName()).$(", lock_reason=").$(tableBusy.getReason()).I$();
                    }
                    break;
                }
            } while (lastWriterTxn < (lastSequencerTxn = engine.getTableSequencerAPI().lastTxn(tableToken)));
        }
        catch (CairoException ex) {
            if (engine.isTableDropped(tableToken)) {
                return ApplyWal2TableJob.tryDestroyDroppedTable(tableToken, null, engine, tempPath) ? Long.MAX_VALUE : -1L;
            }
            LOG.critical().$("WAL apply job failed, table suspended [table=").utf8(tableToken.getDirName()).$(", error=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            return -2L;
        }
        assert (lastWriterTxn == lastSequencerTxn);
        return lastWriterTxn;
    }

    @Override
    public void close() {
        Misc.free(this.operationCompiler);
        Misc.free(this.walEventReader);
    }

    @Override
    public boolean run(int workerId) {
        long cursor;
        boolean useful = false;
        while ((cursor = this.subSeq.next()) > -1L && this.doRun(workerId, cursor)) {
            useful = true;
        }
        return useful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cleanDroppedTableDirectory(CairoEngine engine, Path tempPath, TableToken tableToken) {
        boolean allClean = true;
        FilesFacade ff = engine.getConfiguration().getFilesFacade();
        tempPath.of(engine.getConfiguration().getRoot()).concat(tableToken);
        int rootLen = tempPath.length();
        long p = ff.findFirst(tempPath.$());
        if (p > 0L) {
            try {
                do {
                    int type;
                    long pUtf8NameZ;
                    if (ff.isDirOrSoftLinkDirNoDots(tempPath, rootLen, pUtf8NameZ = ff.findName(p), type = ff.findType(p))) {
                        if (Chars.endsWith((CharSequence)tempPath, "txn_seq") || Chars.equals(tempPath, rootLen + 1, rootLen + 1 + "wal".length(), "wal", 0, "wal".length()) || ff.unlinkOrRemove(tempPath, LOG) == 0) continue;
                        allClean = false;
                        continue;
                    }
                    if (type != 8) continue;
                    tempPath.trimTo(rootLen);
                    tempPath.concat(pUtf8NameZ);
                    if (Chars.endsWith((CharSequence)tempPath, "_txn") || Chars.endsWith((CharSequence)tempPath, "_meta") || ApplyWal2TableJob.matchesWalLock(tempPath) || ff.remove(tempPath.$())) continue;
                    allClean = false;
                    LOG.info().$("could not remove [tempPath=").utf8(tempPath).$(", errno=").$(ff.errno()).I$();
                } while (ff.findNext(p) > 0);
                if (allClean) {
                    ff.remove(tempPath.trimTo(rootLen).concat("_txn").$());
                    ff.remove(tempPath.trimTo(rootLen).concat("_meta").$());
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                ff.findClose(p);
            }
        }
        return false;
    }

    private static AlterOperation compileAlter(TableWriter tableWriter, OperationCompiler compiler, CharSequence sql, long seqTxn) throws SqlException {
        try {
            return compiler.compileAlterSql(sql, tableWriter.getTableToken());
        }
        catch (SqlException ex) {
            tableWriter.markSeqTxnCommitted(seqTxn);
            throw ex;
        }
    }

    private static UpdateOperation compileUpdate(TableWriter tableWriter, OperationCompiler compiler, CharSequence sql, long seqTxn) throws SqlException {
        try {
            return compiler.compileUpdateSql(sql, tableWriter.getTableToken());
        }
        catch (SqlException ex) {
            tableWriter.markSeqTxnCommitted(seqTxn);
            throw ex;
        }
    }

    private static boolean matchesWalLock(CharSequence name) {
        int i;
        if (Chars.endsWith(name, ".lock")) {
            for (i = name.length() - ".lock".length() - 1; i > 0; --i) {
                char c = name.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return Chars.equals(name, i - "wal".length() + 1, i + 1, "wal", 0, "wal".length());
            }
        }
        int n = name.length();
        for (i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryDestroyDroppedTable(TableToken tableToken, TableWriter writer, CairoEngine engine, Path tempPath) {
        if (engine.lockReadersByTableToken(tableToken)) {
            TableWriter writerToClose = null;
            try {
                CairoConfiguration configuration = engine.getConfiguration();
                if (writer == null && TableUtils.exists(configuration.getFilesFacade(), tempPath, configuration.getRoot(), tableToken.getDirName()) == 0) {
                    try {
                        writer = writerToClose = engine.getWriterUnsafe(tableToken, WAL_2_TABLE_WRITE_REASON);
                    }
                    catch (CairoException cairoException) {
                        // empty catch block
                    }
                }
                if (writer != null) {
                    writer.destroy();
                }
                boolean bl = ApplyWal2TableJob.cleanDroppedTableDirectory(engine, tempPath, tableToken);
                return bl;
            }
            finally {
                if (writerToClose != null) {
                    writerToClose.close();
                }
                engine.releaseReadersByTableToken(tableToken);
            }
        }
        LOG.info().$("table '").utf8(tableToken.getDirName()).$("' is dropped, waiting to acquire Table Readers lock to delete the table files").$();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyOutstandingWalTransactions(TableToken tableToken, TableWriter writer, CairoEngine engine, OperationCompiler operationCompiler, Path tempPath) {
        TableSequencerAPI tableSequencerAPI = engine.getTableSequencerAPI();
        try (TransactionLogCursor transactionLogCursor = tableSequencerAPI.getCursor(tableToken, writer.getSeqTxn());){
            TableMetadataChangeLog structuralChangeCursor = null;
            try {
                block21: while (transactionLogCursor.hasNext()) {
                    int walId = transactionLogCursor.getWalId();
                    int segmentId = transactionLogCursor.getSegmentId();
                    long segmentTxn = transactionLogCursor.getSegmentTxn();
                    long commitTimestamp = transactionLogCursor.getCommitTimestamp();
                    long seqTxn = transactionLogCursor.getTxn();
                    if (seqTxn != writer.getSeqTxn() + 1L) {
                        throw CairoException.critical(0).put("unexpected sequencer transaction, expected ").put(writer.getSeqTxn() + 1L).put(" but was ").put(seqTxn);
                    }
                    switch (walId) {
                        case -1: {
                            boolean hasNext;
                            long newStructureVersion = transactionLogCursor.getStructureVersion();
                            if (writer.getStructureVersion() != newStructureVersion - 1L) {
                                throw CairoException.critical(0).put("unexpected new WAL structure version [walStructure=").put(newStructureVersion).put(", tableStructureVersion=").put(writer.getStructureVersion()).put(']');
                            }
                            if (structuralChangeCursor == null || !(hasNext = structuralChangeCursor.hasNext())) {
                                Misc.free(structuralChangeCursor);
                                structuralChangeCursor = tableSequencerAPI.getMetadataChangeLog(tableToken, newStructureVersion - 1L);
                                hasNext = structuralChangeCursor.hasNext();
                            }
                            if (!hasNext) throw CairoException.critical(0).put("could not apply structure change from WAL to table. WAL metadata change does not exist [structureVersion=").put(newStructureVersion).put(']');
                            structuralChangeCursor.next().apply(writer, true);
                            writer.setSeqTxn(seqTxn);
                            continue block21;
                        }
                        case -2: {
                            ApplyWal2TableJob.tryDestroyDroppedTable(tableToken, writer, engine, tempPath);
                            return;
                        }
                        case 0: {
                            throw CairoException.critical(0).put("broken table transaction record in sequencer log, walId cannot be 0 [table=").put(tableToken.getTableName()).put(", seqTxn=").put(seqTxn).put(']');
                        }
                    }
                    operationCompiler.setNowAndFixClock(commitTimestamp);
                    tempPath.of(engine.getConfiguration().getRoot()).concat(tableToken).slash().put("wal").put(walId).slash().put(segmentId);
                    this.processWalCommit(writer, tempPath, segmentTxn, operationCompiler, seqTxn);
                }
                return;
            }
            finally {
                Misc.free(structuralChangeCursor);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processWalCommit(TableWriter writer, Path walPath, long segmentTxn, OperationCompiler operationCompiler, long seqTxn) {
        try (WalEventReader eventReader = this.walEventReader;){
            WalEventCursor walEventCursor = eventReader.of(walPath, 0, segmentTxn);
            byte walTxnType = walEventCursor.getType();
            switch (walTxnType) {
                case 0: {
                    WalEventCursor.DataInfo dataInfo = walEventCursor.getDataInfo();
                    writer.processWalData(walPath, !dataInfo.isOutOfOrder(), dataInfo.getStartRowID(), dataInfo.getEndRowID(), dataInfo.getMinTimestamp(), dataInfo.getMaxTimestamp(), dataInfo, seqTxn);
                    return;
                }
                case 1: {
                    WalEventCursor.SqlInfo sqlInfo = walEventCursor.getSqlInfo();
                    this.processWalSql(writer, sqlInfo, operationCompiler, seqTxn);
                    return;
                }
                case 2: {
                    long txn = writer.getTxn();
                    writer.setSeqTxn(seqTxn);
                    writer.removeAllPartitions();
                    if (writer.getTxn() != txn) return;
                    writer.markSeqTxnCommitted(seqTxn);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported WAL txn type: " + walTxnType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWalSql(TableWriter tableWriter, WalEventCursor.SqlInfo sqlInfo, OperationCompiler operationCompiler, long seqTxn) {
        int cmdType = sqlInfo.getCmdType();
        CharSequence sql = sqlInfo.getSql();
        operationCompiler.resetRnd(sqlInfo.getRndSeed0(), sqlInfo.getRndSeed1());
        sqlInfo.populateBindVariableService(operationCompiler.getBindVariableService());
        try {
            switch (cmdType) {
                case 2: {
                    AlterOperation alterOperation = ApplyWal2TableJob.compileAlter(tableWriter, operationCompiler, sql, seqTxn);
                    try {
                        tableWriter.apply((AbstractOperation)alterOperation, seqTxn);
                        break;
                    }
                    finally {
                        Misc.free(alterOperation);
                    }
                }
                case 3: {
                    UpdateOperation updateOperation = ApplyWal2TableJob.compileUpdate(tableWriter, operationCompiler, sql, seqTxn);
                    try {
                        tableWriter.apply(updateOperation, seqTxn);
                        break;
                    }
                    finally {
                        Misc.free(updateOperation);
                    }
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported command type: " + cmdType);
                }
            }
        }
        catch (SqlException ex) {
            LOG.error().$("error applying SQL to wal table [table=").utf8(tableWriter.getTableToken().getTableName()).$(", sql=").$(sql).$(", error=").$(ex.getFlyweightMessage()).I$();
        }
        catch (CairoException e) {
            if (e.isWALTolerable()) {
                LOG.error().$("error applying SQL to wal table [table=").utf8(tableWriter.getTableToken().getTableName()).$(", sql=").$(sql).$(", error=").$(e.getFlyweightMessage()).I$();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRun(int workerId, long cursor) {
        long seqTxn;
        TableToken tableToken;
        try {
            WalTxnNotificationTask task = (WalTxnNotificationTask)this.queue.get(cursor);
            tableToken = task.getTableToken();
            seqTxn = task.getTxn();
        }
        finally {
            this.subSeq.done(cursor);
        }
        int tableId = tableToken.getTableId();
        if (this.lastAppliedSeqTxns.get(tableId) < seqTxn) {
            long lastAppliedSeqTxn = this.applyWAL(tableToken, this.engine, this.operationCompiler);
            if (lastAppliedSeqTxn > -1L) {
                this.lastAppliedSeqTxns.put(tableId, lastAppliedSeqTxn);
            } else if (lastAppliedSeqTxn == -2L) {
                this.lastAppliedSeqTxns.put(tableId, 0x7FFFFFFFFFFFFFFEL);
                this.engine.getTableSequencerAPI().suspendTable(tableToken);
            }
        } else {
            LOG.debug().$("Skipping WAL processing for table, already processed [table=").$(tableToken).$(", txn=").$(seqTxn).I$();
        }
        return true;
    }
}

