/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class TxnScoreboard
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(TxnScoreboard.class);
    private final FilesFacade ff;
    private final int pow2EntryCount;
    private final long size;
    private int fd = -1;
    private long mem;

    public TxnScoreboard(FilesFacade ff, int entryCount) {
        this.ff = ff;
        this.pow2EntryCount = Numbers.ceilPow2(entryCount);
        this.size = TxnScoreboard.getScoreboardSize(this.pow2EntryCount);
    }

    public static native long getScoreboardSize(int var0);

    public boolean acquireTxn(long txn) {
        assert (txn > -1L);
        long internalTxn = TxnScoreboard.toInternalTxn(txn);
        long response = TxnScoreboard.acquireTxn(this.mem, internalTxn);
        if (response == 0L) {
            return true;
        }
        if (response == -1L) {
            return false;
        }
        long min = TxnScoreboard.fromInternalTxn(-response - 2L);
        throw CairoException.critical(0).put("max txn-inflight limit reached [txn=").put(txn).put(", min=").put(min).put(", size=").put(this.pow2EntryCount).put(']');
    }

    @Override
    public void clear() {
        this.close();
    }

    @Override
    public void close() {
        if (this.mem != 0L) {
            this.ff.munmap(this.mem, this.size, 0);
            this.mem = 0L;
        }
        if (this.ff.close(this.fd)) {
            LOG.debug().$("closed [fd=").$(this.fd).I$();
            this.fd = -1;
        }
    }

    public long getActiveReaderCount(long txn) {
        return TxnScoreboard.getCount(this.mem, TxnScoreboard.toInternalTxn(txn));
    }

    public int getEntryCount() {
        return this.pow2EntryCount;
    }

    public long getMin() {
        long min = TxnScoreboard.getMin(this.mem);
        if (min == 0L) {
            return 0L;
        }
        return TxnScoreboard.fromInternalTxn(min);
    }

    public boolean isRangeAvailable(long fromTxn, long toTxn) {
        return TxnScoreboard.isRangeAvailable0(this.mem, TxnScoreboard.toInternalTxn(fromTxn), TxnScoreboard.toInternalTxn(toTxn));
    }

    public boolean isTxnAvailable(long txn) {
        return this.getActiveReaderCount(txn) == 0L;
    }

    public TxnScoreboard ofRO(Path root) {
        this.clear();
        int rootLen = root.length();
        root.concat("_txn_scoreboard").$();
        this.fd = TxnScoreboard.openCleanRW(this.ff, root, this.size);
        try {
            this.mem = TableUtils.mapRO(this.ff, this.fd, this.size, 0);
        }
        catch (Throwable e) {
            this.ff.close(this.fd);
            root.trimTo(rootLen);
            this.fd = -1;
            throw e;
        }
        return this;
    }

    public TxnScoreboard ofRW(Path root) {
        this.clear();
        root.concat("_txn_scoreboard").$();
        this.fd = TxnScoreboard.openCleanRW(this.ff, root, this.size);
        this.ff.truncate(this.fd, this.size);
        try {
            this.mem = TableUtils.mapRW(this.ff, this.fd, this.size, 0);
            TxnScoreboard.init(this.mem, this.pow2EntryCount);
        }
        catch (Throwable e) {
            this.ff.close(this.fd);
            this.fd = -1;
            throw e;
        }
        return this;
    }

    public long releaseTxn(long txn) {
        long released = TxnScoreboard.releaseTxn(this.mem, txn);
        assert (released > -1L) : "released count " + txn + " must be positive: " + (released + 1L);
        return released;
    }

    private static long acquireTxn(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("acquire [p=").$(pTxnScoreboard).$(", txn=").$(TxnScoreboard.fromInternalTxn(txn)).$(']').$();
        return TxnScoreboard.acquireTxn0(pTxnScoreboard, txn);
    }

    private static native long acquireTxn0(long var0, long var2);

    private static long fromInternalTxn(long txn) {
        return txn - 1L;
    }

    private static native long getCount(long var0, long var2);

    private static native long getMin(long var0);

    private static native void init(long var0, int var2);

    private static native boolean isRangeAvailable0(long var0, long var2, long var4);

    private static long releaseTxn(long pTxnScoreboard, long txn) {
        assert (pTxnScoreboard > 0L);
        LOG.debug().$("release  [p=").$(pTxnScoreboard).$(", txn=").$(txn).$(']').$();
        long internalTxn = TxnScoreboard.toInternalTxn(txn);
        return TxnScoreboard.releaseTxn0(pTxnScoreboard, internalTxn);
    }

    private static native long releaseTxn0(long var0, long var2);

    private static long toInternalTxn(long txn) {
        return txn + 1L;
    }

    static int openCleanRW(FilesFacade ff, LPSZ path, long size) {
        int fd = ff.openCleanRW(path, size);
        if (fd > -1) {
            LOG.debug().$("open clean [file=").$(path).$(", fd=").$(fd).$(']').$();
            return fd;
        }
        throw CairoException.critical(ff.errno()).put("could not open read-write with clean allocation [file=").put(path).put(']');
    }
}

