/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.api.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class C2Properties
extends Properties {
    public static final String MINIFI_C2_SERVER_SECURE = "minifi.c2.server.secure";
    public static final String MINIFI_C2_SERVER_KEYSTORE_TYPE = "minifi.c2.server.keystoreType";
    public static final String MINIFI_C2_SERVER_KEYSTORE = "minifi.c2.server.keystore";
    public static final String MINIFI_C2_SERVER_KEYSTORE_PASSWD = "minifi.c2.server.keystorePasswd";
    public static final String MINIFI_C2_SERVER_KEY_PASSWD = "minifi.c2.server.keyPasswd";
    public static final String MINIFI_C2_SERVER_TRUSTSTORE = "minifi.c2.server.truststore";
    public static final String MINIFI_C2_SERVER_TRUSTSTORE_TYPE = "minifi.c2.server.truststoreType";
    public static final String MINIFI_C2_SERVER_TRUSTSTORE_PASSWD = "minifi.c2.server.truststorePasswd";
    private static final C2Properties properties = C2Properties.initProperties();

    private static C2Properties initProperties() {
        C2Properties properties = new C2Properties();
        try (InputStream inputStream = C2Properties.class.getClassLoader().getResourceAsStream("c2.properties");){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load c2.properties", e);
        }
        return properties;
    }

    public static C2Properties getInstance() {
        return properties;
    }

    public boolean isSecure() {
        return Boolean.parseBoolean(this.getProperty(MINIFI_C2_SERVER_SECURE, "false"));
    }
}

