/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class DiagnosticAnalysisTask
implements DiagnosticTask {
    private static final int THREAD_TO_AVAILABLE_PROCS_RATIO = 6;
    private static final int MAX_CONCURRENT_TASKS = 15;
    private final FlowController flowController;

    public DiagnosticAnalysisTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        List allProcessors = this.flowController.getFlowManager().getRootGroup().findAllProcessors();
        this.analyzeCpuUsage(details);
        this.analyzeHighTimerDrivenThreadCount(details);
        this.analyzeProcessors(allProcessors, details);
        this.analyzeOpenFileHandles(details);
        this.analyzeTimerDrivenThreadExhaustion(details);
        this.analyzeColocatedRepos(details);
        this.analyzeLeadershipChanges(details);
        if (details.isEmpty()) {
            details.add("Analysis found no concerns");
        }
        return new StandardDiagnosticsDumpElement("Analysis", details);
    }

    private void analyzeCpuUsage(List<String> details) {
        int availableProcs;
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        double loadAverage = os.getSystemLoadAverage();
        if (loadAverage > (double)(availableProcs = os.getAvailableProcessors())) {
            details.add(String.format("1-minute CPU Load Average is %1$.2f, which exceeds the %2$d available cores. CPU is over-utilized.", loadAverage, availableProcs));
        } else if (loadAverage > 0.9 * (double)availableProcs) {
            details.add(String.format("1-minute CPU Load Average is %1$.2f, which exceeds 90%% of the %2$d available cores. CPU may struggle to keep up.", loadAverage, availableProcs));
        }
    }

    private void analyzeHighTimerDrivenThreadCount(List<String> details) {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        int availableProcs = os.getAvailableProcessors();
        if (this.flowController.getMaxTimerDrivenThreadCount() > 6 * availableProcs) {
            details.add("Number of Timer-Driven Threads is " + this.flowController.getMaxTimerDrivenThreadCount() + " with " + availableProcs + " available cores. Number of threads exceeds " + 6 + "x the number of cores available.");
        }
    }

    private void analyzeProcessors(Collection<ProcessorNode> processors, List<String> details) {
        String processorType;
        HashMap<String, Integer> highMemTypesToCounts = new HashMap<String, Integer>();
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getMaxConcurrentTasks() > 15) {
                details.add(processorNode + " is configured with a Max Concurrent Tasks of " + processorNode.getMaxConcurrentTasks() + ", which is very high. Under most circumstances, this value should not be set above 12-15. This processor is currently " + processorNode.getScheduledState().name());
            }
            if (processorNode.getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
                details.add(processorNode + " is configured with a Scheduling Strategy of Event-Driven. The Event-Driven Scheduling Strategy is experimental and may trigger unexpected behavior, such as a Processor \"hanging\" or becoming unresponsive.");
            }
            if (!this.isHighMemoryUtilizer(processorNode)) continue;
            processorType = processorNode.getComponentType();
            int currentCount = highMemTypesToCounts.computeIfAbsent(processorType, k -> 0);
            highMemTypesToCounts.put(processorType, currentCount + 1);
        }
        for (Map.Entry entry : highMemTypesToCounts.entrySet()) {
            processorType = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            details.add(count + " instances of " + processorType + " are on the canvas, and this Processor is denoted as using large amounts of heap");
        }
    }

    private boolean isHighMemoryUtilizer(ProcessorNode procNode) {
        Processor processor = procNode.getProcessor();
        SystemResourceConsideration consideration = processor.getClass().getAnnotation(SystemResourceConsideration.class);
        if (consideration != null && SystemResource.MEMORY == consideration.resource()) {
            return true;
        }
        SystemResourceConsiderations considerations = processor.getClass().getAnnotation(SystemResourceConsiderations.class);
        if (considerations != null) {
            for (SystemResourceConsideration systemResourceConsideration : considerations.value()) {
                if (SystemResource.MEMORY != systemResourceConsideration.resource()) continue;
                return true;
            }
        }
        return false;
    }

    private void analyzeOpenFileHandles(List<String> details) {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        ObjectName osObjectName = os.getObjectName();
        try {
            int maxCount;
            int openCount;
            Object openFileCount = ManagementFactory.getPlatformMBeanServer().getAttribute(osObjectName, "OpenFileDescriptorCount");
            Object maxOpenFileCount = ManagementFactory.getPlatformMBeanServer().getAttribute(osObjectName, "MaxFileDescriptorCount");
            if (openFileCount != null && maxOpenFileCount != null && (double)(openCount = ((Number)openFileCount).intValue()) >= 0.8 * (double)(maxCount = ((Number)maxOpenFileCount).intValue())) {
                details.add("Open File Count for NiFi is " + openCount + ", which exceeds 80% of the Max Open File Count of " + maxCount + ". It may be necessary to increase the maximum number of file handles that are available to a process in the Operating System.");
            }
        }
        catch (Exception e) {
            details.add("Failed to determine whether or not Open File Handle Count is of concern due to " + e);
        }
    }

    private void analyzeTimerDrivenThreadExhaustion(List<String> details) {
        int maxThreadCount;
        int activethreadCount = this.flowController.getActiveThreadCount();
        if ((double)activethreadCount >= 0.95 * (double)(maxThreadCount = this.flowController.getMaxTimerDrivenThreadCount())) {
            details.add("Active Thread Count is " + activethreadCount + ", with Max Active Thread Count of " + maxThreadCount + ". The Timer-Driven Thread Pool may be exhausted.");
        }
    }

    private void analyzeColocatedRepos(List<String> details) {
        HashMap<String, List> fileStoreToRepos = new HashMap<String, List>();
        RepositoryContextFactory contextFactory = this.flowController.getRepositoryContextFactory();
        String flowFileRepoStoreName = contextFactory.getFlowFileRepository().getFileStoreName();
        List repos = fileStoreToRepos.computeIfAbsent(flowFileRepoStoreName, k -> new ArrayList());
        repos.add("FlowFile Repository");
        for (String containerName : contextFactory.getContentRepository().getContainerNames()) {
            repos = fileStoreToRepos.computeIfAbsent(flowFileRepoStoreName, k -> new ArrayList());
            repos.add("Content Repository <" + containerName + ">");
        }
        for (String containerName : contextFactory.getProvenanceRepository().getContainerNames()) {
            repos = fileStoreToRepos.computeIfAbsent(flowFileRepoStoreName, k -> new ArrayList());
            repos.add("Provenance Repository <" + containerName + ">");
        }
        for (List repoNamesOnSameFileStore : fileStoreToRepos.values()) {
            if (repoNamesOnSameFileStore.size() <= 1) continue;
            details.add("The following Repositories share the same File Store: " + repoNamesOnSameFileStore);
        }
    }

    private void analyzeLeadershipChanges(List<String> details) {
        LeaderElectionManager leaderElectionManager = this.flowController.getLeaderElectionManager();
        if (leaderElectionManager == null) {
            return;
        }
        Map<String, Integer> changeCounts = leaderElectionManager.getLeadershipChangeCount(24L, TimeUnit.HOURS);
        changeCounts.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 4).forEach(entry -> details.add("Leadership for role <" + (String)entry.getKey() + "> has changed " + entry.getValue() + " times in the last 24 hours"));
    }
}

