/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.StringLongTuplesRecordCursor;
import io.questdb.std.MemoryTag;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;

public final class MemoryMetricsRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final RecordMetadata METADATA;
    private static final int METRIC_COUNT = 56;
    private static final String[] KEYS;
    private final StringLongTuplesRecordCursor cursor = new StringLongTuplesRecordCursor();
    private final long[] values = new long[56];

    public MemoryMetricsRecordCursorFactory() {
        super(METADATA);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        MemoryMetricsRecordCursorFactory.collectMetrics(this.values);
        this.cursor.of(KEYS, this.values);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("memory_metrics");
    }

    private static void collectMetrics(long[] collector) {
        assert (collector.length == 56);
        collector[0] = Unsafe.getMemUsed();
        collector[1] = Os.getRss();
        for (int i = 0; i < 54; ++i) {
            collector[i + 2] = Unsafe.getMemUsedByTag(i);
        }
    }

    static {
        KEYS = new String[56];
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("memory_tag", 11));
        metadata.add(1, new TableColumnMetadata("bytes", 6));
        METADATA = metadata;
        MemoryMetricsRecordCursorFactory.KEYS[0] = "TOTAL_USED";
        MemoryMetricsRecordCursorFactory.KEYS[1] = "RSS";
        for (int i = 0; i < 54; ++i) {
            MemoryMetricsRecordCursorFactory.KEYS[i + 2] = MemoryTag.nameOf(i);
        }
    }
}

