/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class RemLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "%(LL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends LongFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public long getLong(Record rec) {
            long r = this.right.getLong(rec);
            if (r == 0L || r == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            long l = this.left.getLong(rec);
            if (l == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return l % r;
        }

        @Override
        public String getName() {
            return "%";
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public boolean isOperator() {
            return true;
        }
    }
}

