/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolCountProvider;
import io.questdb.cairo.SymbolValueCountCollector;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.std.FilesFacade;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;

public final class TxWriter
extends TxReader
implements Closeable,
Mutable,
SymbolValueCountCollector {
    private final FilesFacade ff;
    private long baseVersion;
    private TableWriter.ExtensionListener extensionListener;
    private int lastRecordBaseOffset = -1;
    private long lastRecordStructureVersion = -1L;
    private long prevMaxTimestamp;
    private long prevMinTimestamp;
    private int prevRecordBaseOffset = -2;
    private long prevRecordStructureVersion = -2L;
    private long prevTransientRowCount;
    private int readBaseOffset;
    private long readRecordSize;
    private long recordStructureVersion = 0L;
    private MemoryCMARW txMemBase;
    private int txPartitionCount;
    private int writeAreaSize;
    private int writeBaseOffset;

    public TxWriter(FilesFacade ff) {
        super(ff);
        this.ff = ff;
    }

    public void append() {
        ++this.transientRowCount;
    }

    public void beginPartitionSizeUpdate() {
        if (this.maxTimestamp != Long.MIN_VALUE) {
            this.updatePartitionSizeByTimestamp(this.maxTimestamp, this.transientRowCount);
        }
    }

    public void bumpStructureVersion(ObjList<? extends SymbolCountProvider> denseSymbolMapWriters) {
        ++this.recordStructureVersion;
        this.structureVersion.incrementAndGet();
        this.commit(2, denseSymbolMapWriters);
    }

    public void bumpTruncateVersion() {
        ++this.truncateVersion;
    }

    public void cancelRow() {
        if (this.transientRowCount == 1L && this.txPartitionCount > 1) {
            --this.txPartitionCount;
            this.fixedRowCount -= this.prevTransientRowCount;
            this.transientRowCount = this.prevTransientRowCount + 1L;
            this.attachedPartitions.setPos(this.attachedPartitions.size() - 4);
            this.prevTransientRowCount = this.getLong(8L);
        }
        this.maxTimestamp = this.prevMaxTimestamp;
        this.minTimestamp = this.prevMinTimestamp;
        ++this.recordStructureVersion;
    }

    public long cancelToMaxTimestamp() {
        return this.prevMaxTimestamp;
    }

    public long cancelToTransientRowCount() {
        return this.prevTransientRowCount;
    }

    @Override
    public void clear() {
        if (this.txMemBase != null) {
            this.txMemBase.close(false);
        }
        this.recordStructureVersion = 0L;
        this.lastRecordStructureVersion = -1L;
        this.prevRecordStructureVersion = -2L;
        this.lastRecordBaseOffset = -1;
        this.prevRecordBaseOffset = -2;
    }

    @Override
    public void close() {
        try {
            this.clear();
            this.txMemBase = null;
        }
        finally {
            super.close();
        }
    }

    @Override
    public void collectValueCount(int symbolIndexInTxWriter, int count) {
        this.writeTransientSymbolCount(symbolIndexInTxWriter, count);
    }

    public void commit(int commitMode, ObjList<? extends SymbolCountProvider> symbolCountProviders) {
        if (this.prevRecordStructureVersion == this.recordStructureVersion && this.prevRecordBaseOffset > 0) {
            this.writeBaseOffset = this.prevRecordBaseOffset;
            this.putLong(0L, ++this.txn);
            this.putLong(80L, this.seqTxn);
            this.putLong(32L, this.maxTimestamp);
            this.putLong(8L, this.transientRowCount);
            this.storeSymbolCounts(symbolCountProviders);
            Unsafe.getUnsafe().storeFence();
            this.txMemBase.putLong(0L, ++this.baseVersion);
            super.switchRecord(this.writeBaseOffset, this.writeAreaSize);
            this.readBaseOffset = this.writeBaseOffset;
            this.prevTransientRowCount = this.transientRowCount;
            this.prevMinTimestamp = this.minTimestamp;
            this.prevMaxTimestamp = this.maxTimestamp;
            this.prevRecordBaseOffset = this.lastRecordBaseOffset;
            this.lastRecordBaseOffset = this.writeBaseOffset;
        } else {
            this.commitFullRecord(commitMode, symbolCountProviders);
        }
    }

    public void finishPartitionSizeUpdate(long minTimestamp, long maxTimestamp) {
        this.minTimestamp = minTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.finishPartitionSizeUpdate();
    }

    public void finishPartitionSizeUpdate() {
        ++this.recordStructureVersion;
        int numPartitions = this.getPartitionCount();
        this.transientRowCount = numPartitions > 0 ? this.getPartitionSize(numPartitions - 1) : 0L;
        this.fixedRowCount = 0L;
        this.txPartitionCount = this.getPartitionCount();
        int hi = this.txPartitionCount - 1;
        for (int i = 0; i < hi; ++i) {
            this.fixedRowCount += this.getPartitionSize(i);
        }
    }

    public int getAppendedPartitionCount() {
        return this.txPartitionCount;
    }

    public long getLastTxSize() {
        return this.txPartitionCount == 1 ? this.transientRowCount - this.prevTransientRowCount : this.transientRowCount;
    }

    public boolean inTransaction() {
        return this.txPartitionCount > 1 || this.transientRowCount != this.prevTransientRowCount;
    }

    public boolean isActivePartition(long timestamp) {
        return this.getPartitionTimestampLo(this.maxTimestamp) == timestamp;
    }

    @Override
    public TxWriter ofRO(LPSZ path, int partitionBy) {
        throw new IllegalStateException();
    }

    public TxWriter ofRW(LPSZ path, int partitionBy) {
        this.clear();
        this.openTxnFile(this.ff, path);
        try {
            super.initRO(this.txMemBase, partitionBy);
            this.unsafeLoadAll();
        }
        catch (Throwable e) {
            if (this.txMemBase != null) {
                this.txMemBase.close(false);
                this.txMemBase = null;
            }
            super.close();
            throw e;
        }
        return this;
    }

    public void openFirstPartition(long timestamp) {
        this.txPartitionCount = 1;
        this.updateAttachedPartitionSizeByTimestamp(timestamp, 0L, this.txn - 1L);
    }

    public void removeAllPartitions() {
        this.maxTimestamp = Long.MIN_VALUE;
        this.minTimestamp = Long.MAX_VALUE;
        this.prevTransientRowCount = 0L;
        this.transientRowCount = 0L;
        this.fixedRowCount = 0L;
        this.attachedPartitions.clear();
        ++this.recordStructureVersion;
        ++this.truncateVersion;
        ++this.partitionTableVersion;
        ++this.dataVersion;
    }

    public void removeAttachedPartitions(long timestamp) {
        ++this.recordStructureVersion;
        long partitionTimestampLo = this.getPartitionTimestampLo(timestamp);
        int index = this.findAttachedPartitionIndexByLoTimestamp(partitionTimestampLo);
        if (index > -1) {
            int size = this.attachedPartitions.size();
            int lim = size - 4;
            if (index < lim) {
                this.attachedPartitions.arrayCopy(index + 4, index, lim - index);
            }
            this.attachedPartitions.setPos(lim);
            ++this.partitionTableVersion;
        } else assert (false);
    }

    public void reset(long fixedRowCount, long transientRowCount, long maxTimestamp, int commitMode, ObjList<? extends SymbolCountProvider> symbolCountProviders) {
        ++this.recordStructureVersion;
        this.fixedRowCount = fixedRowCount;
        this.maxTimestamp = maxTimestamp;
        this.transientRowCount = transientRowCount;
        this.commit(commitMode, symbolCountProviders);
    }

    public void resetTimestamp() {
        ++this.recordStructureVersion;
        this.prevMaxTimestamp = Long.MIN_VALUE;
        this.prevMinTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = this.prevMaxTimestamp;
        this.minTimestamp = this.prevMinTimestamp;
    }

    public void setColumnVersion(long newVersion) {
        if (this.columnVersion != newVersion) {
            ++this.recordStructureVersion;
            this.columnVersion = newVersion;
        }
    }

    public void setExtensionListener(TableWriter.ExtensionListener extensionListener) {
        this.extensionListener = extensionListener;
    }

    public void setMinTimestamp(long timestamp) {
        ++this.recordStructureVersion;
        this.minTimestamp = timestamp;
        if (this.prevMinTimestamp == Long.MAX_VALUE) {
            this.prevMinTimestamp = this.minTimestamp;
        }
    }

    public void setPartitionReadOnly(int partitionIndex, boolean isReadOnly) {
        this.setPartitionReadOnlyByIndex(partitionIndex * 4, isReadOnly);
    }

    public void setPartitionReadOnlyByIndex(int index, boolean isReadOnly) {
        if (index < 0) {
            throw CairoException.nonCritical().put("bad partition index -1");
        }
        int offset = index + 1;
        long maskedSize = this.attachedPartitions.getQuick(offset);
        this.attachedPartitions.setQuick(offset, TxWriter.updatePartitionIsReadOnly(maskedSize, isReadOnly));
    }

    public void setPartitionReadOnlyByTimestamp(long timestamp, boolean isReadOnly) {
        this.setPartitionReadOnlyByIndex(this.findAttachedPartitionIndex(timestamp), isReadOnly);
    }

    public void setSeqTxn(long seqTxn) {
        this.seqTxn = seqTxn;
    }

    public void switchPartitions(long timestamp) {
        ++this.recordStructureVersion;
        this.fixedRowCount += this.transientRowCount;
        this.prevTransientRowCount = this.transientRowCount;
        long partitionTimestampLo = this.getPartitionTimestampLo(this.maxTimestamp);
        int index = this.findAttachedPartitionIndexByLoTimestamp(partitionTimestampLo);
        this.updatePartitionSizeByIndex(index, this.transientRowCount);
        this.attachedPartitions.setPos((index += 4) + 4);
        long newTimestampLo = this.getPartitionTimestampLo(timestamp);
        this.initPartitionAt(index, newTimestampLo, 0L, this.txn - 1L, -1L);
        this.transientRowCount = 0L;
        ++this.txPartitionCount;
        if (this.extensionListener != null) {
            this.extensionListener.onTableExtended(newTimestampLo);
        }
    }

    public void truncate(long columnVersion) {
        this.removeAllPartitions();
        if (!PartitionBy.isPartitioned(this.partitionBy)) {
            this.attachedPartitions.setPos(4);
            this.initPartitionAt(0, 0L, 0L, -1L, columnVersion);
        }
        this.writeAreaSize = this.calculateWriteSize();
        this.writeBaseOffset = this.calculateWriteOffset(this.writeAreaSize);
        TableUtils.resetTxn(this.txMemBase, this.writeBaseOffset, this.getSymbolColumnCount(), ++this.txn, this.seqTxn, this.dataVersion, this.partitionTableVersion, this.structureVersion.get(), columnVersion, this.truncateVersion);
        this.finishABHeader(this.writeBaseOffset, this.symbolColumnCount * 8, 0, 2);
    }

    @Override
    public boolean unsafeLoadAll() {
        super.unsafeLoadAll();
        this.baseVersion = this.getVersion();
        if (this.baseVersion >= 0L) {
            this.readBaseOffset = this.getBaseOffset();
            this.readRecordSize = this.getRecordSize();
            this.prevTransientRowCount = this.transientRowCount;
            this.prevMaxTimestamp = this.maxTimestamp;
            this.prevMinTimestamp = this.minTimestamp;
            return true;
        }
        return false;
    }

    public void updateMaxTimestamp(long timestamp) {
        this.prevMaxTimestamp = this.maxTimestamp;
        assert (timestamp >= this.maxTimestamp);
        this.maxTimestamp = timestamp;
    }

    public void updatePartitionSizeByIndex(int partitionIndex, long partitionTimestampLo, long rowCount) {
        this.updateAttachedPartitionSizeByIndex(partitionIndex, partitionTimestampLo, rowCount, this.txn - 1L);
    }

    public void updatePartitionSizeByTimestamp(long timestamp, long rowCount) {
        ++this.recordStructureVersion;
        this.updateAttachedPartitionSizeByTimestamp(timestamp, rowCount, this.txn - 1L);
    }

    public void updatePartitionSizeByTimestamp(long timestamp, long rowCount, long partitionNameTxn) {
        ++this.recordStructureVersion;
        this.updateAttachedPartitionSizeByTimestamp(timestamp, rowCount, partitionNameTxn);
    }

    private static long updatePartitionIsReadOnly(long maskedSize, boolean isReadOnly) {
        maskedSize = isReadOnly ? (maskedSize |= 0x4000000000000000L) : (maskedSize &= 0xBFFFFFFFFFFFFFFFL);
        return maskedSize;
    }

    private int calculateWriteOffset(int areaSize) {
        int currentOffset;
        boolean currentIsA = (this.baseVersion & 1L) == 0L;
        int n = currentOffset = currentIsA ? this.txMemBase.getInt(8L) : this.txMemBase.getInt(32L);
        if (TableUtils.TX_BASE_HEADER_SIZE + areaSize <= currentOffset) {
            return TableUtils.TX_BASE_HEADER_SIZE;
        }
        int currentSizeSymbols = currentIsA ? this.txMemBase.getInt(12L) : this.txMemBase.getInt(36L);
        int currentSizePartitions = currentIsA ? this.txMemBase.getInt(16L) : this.txMemBase.getInt(40L);
        int currentSize = TableUtils.calculateTxRecordSize(currentSizeSymbols, currentSizePartitions);
        return currentOffset + currentSize;
    }

    private int calculateWriteSize() {
        if (this.maxTimestamp == Long.MIN_VALUE && PartitionBy.isPartitioned(this.partitionBy)) {
            this.attachedPartitions.clear();
        }
        return TableUtils.calculateTxRecordSize(this.symbolColumnCount * 8, this.attachedPartitions.size() * 8);
    }

    private void commitFullRecord(int commitMode, ObjList<? extends SymbolCountProvider> symbolCountProviders) {
        this.symbolColumnCount = symbolCountProviders.size();
        this.writeAreaSize = this.calculateWriteSize();
        this.writeBaseOffset = this.calculateWriteOffset(this.writeAreaSize);
        this.putLong(0L, ++this.txn);
        this.putLong(8L, this.transientRowCount);
        this.putLong(16L, this.fixedRowCount);
        this.putLong(24L, this.minTimestamp);
        this.putLong(32L, this.maxTimestamp);
        this.putLong(40L, this.structureVersion.get());
        this.putLong(48L, this.dataVersion);
        this.putLong(56L, this.partitionTableVersion);
        this.putLong(64L, this.columnVersion);
        this.putLong(72L, this.truncateVersion);
        this.putLong(80L, this.seqTxn);
        this.putInt(128L, this.symbolColumnCount);
        this.storeSymbolCounts(symbolCountProviders);
        this.txPartitionCount = 1;
        this.saveAttachedPartitionsToTx(this.symbolColumnCount);
        this.finishABHeader(this.writeBaseOffset, this.symbolColumnCount * 8, this.attachedPartitions.size() * 8, commitMode);
        this.prevTransientRowCount = this.transientRowCount;
        this.prevMinTimestamp = this.minTimestamp;
        this.prevMaxTimestamp = this.maxTimestamp;
        this.prevRecordStructureVersion = this.lastRecordStructureVersion;
        this.lastRecordStructureVersion = this.recordStructureVersion;
        this.prevRecordBaseOffset = this.lastRecordBaseOffset;
        this.lastRecordBaseOffset = this.writeBaseOffset;
    }

    private void finishABHeader(int areaOffset, int bytesSymbols, int bytesPartitions, int commitMode) {
        boolean currentIsA = (this.baseVersion & 1L) == 0L;
        long offsetOffset = currentIsA ? 32L : 8L;
        long symbolSizeOffset = currentIsA ? 36L : 12L;
        long partitionsSizeOffset = currentIsA ? 40L : 16L;
        this.txMemBase.putInt(offsetOffset, areaOffset);
        this.txMemBase.putInt(symbolSizeOffset, bytesSymbols);
        this.txMemBase.putInt(partitionsSizeOffset, bytesPartitions);
        Unsafe.getUnsafe().storeFence();
        this.txMemBase.putLong(0L, ++this.baseVersion);
        this.readRecordSize = TableUtils.calculateTxRecordSize(bytesSymbols, bytesPartitions);
        this.readBaseOffset = areaOffset;
        super.switchRecord(this.readBaseOffset, this.readRecordSize);
        if (commitMode != 2) {
            this.txMemBase.sync(commitMode == 0);
        }
    }

    private long getLong(long offset) {
        assert (offset + 8L <= this.readRecordSize);
        return this.txMemBase.getLong((long)this.readBaseOffset + offset);
    }

    private void insertPartitionSizeByTimestamp(int index, long partitionTimestamp, long partitionSize, long partitionNameTxn) {
        int size = this.attachedPartitions.size();
        this.attachedPartitions.setPos(size + 4);
        if (index < size) {
            this.attachedPartitions.arrayCopy(index, index + 4, size - index);
            ++this.partitionTableVersion;
        } else if (this.extensionListener != null) {
            this.extensionListener.onTableExtended(partitionTimestamp);
        }
        ++this.recordStructureVersion;
        this.initPartitionAt(index, partitionTimestamp, partitionSize, partitionNameTxn, -1L);
    }

    private void openTxnFile(FilesFacade ff, LPSZ path) {
        if (ff.exists(path)) {
            if (this.txMemBase == null) {
                this.txMemBase = Vm.getSmallCMARWInstance(ff, path, 0, 0L);
            } else {
                this.txMemBase.of(ff, path, ff.getPageSize(), 0, 0L);
            }
            return;
        }
        throw CairoException.critical(ff.errno()).put("Cannot append. File does not exist: ").put(path);
    }

    private void putInt(long offset, int value) {
        assert (offset + 4L <= (long)this.writeAreaSize);
        this.txMemBase.putInt((long)this.writeBaseOffset + offset, value);
    }

    private void putLong(long offset, long value) {
        this.txMemBase.putLong((long)this.writeBaseOffset + offset, value);
    }

    private void saveAttachedPartitionsToTx(int symbolColumnCount) {
        int size = this.attachedPartitions.size();
        long partitionTableOffset = TableUtils.getPartitionTableSizeOffset(symbolColumnCount);
        this.putInt(partitionTableOffset, size * 8);
        if (this.maxTimestamp != Long.MIN_VALUE) {
            for (int i = 0; i < size; ++i) {
                this.putLong(TableUtils.getPartitionTableIndexOffset(partitionTableOffset, i), this.attachedPartitions.getQuick(i));
            }
        }
    }

    private void storeSymbolCounts(ObjList<? extends SymbolCountProvider> symbolCountProviders) {
        int n = symbolCountProviders.size();
        for (int i = 0; i < n; ++i) {
            long offset = TableUtils.getSymbolWriterIndexOffset(i);
            int symCount = symbolCountProviders.getQuick(i).getSymbolCount();
            this.putInt(offset, symCount);
            this.putInt(offset += 4L, symCount);
        }
    }

    private void updateAttachedPartitionSizeByIndex(int partitionIndex, long partitionTimestampLo, long partitionSize, long partitionNameTxn) {
        if (partitionIndex > -1) {
            this.updatePartitionSizeByIndex(partitionIndex, partitionSize);
        } else {
            this.insertPartitionSizeByTimestamp(-(partitionIndex + 1), partitionTimestampLo, partitionSize, partitionNameTxn);
        }
    }

    private void updateAttachedPartitionSizeByTimestamp(long timestamp, long partitionSize, long partitionNameTxn) {
        long partitionTimestampLo = this.getPartitionTimestampLo(timestamp);
        this.updateAttachedPartitionSizeByIndex(this.findAttachedPartitionIndexByLoTimestamp(partitionTimestampLo), partitionTimestampLo, partitionSize, partitionNameTxn);
    }

    private void updatePartitionSizeByIndex(int index, long partitionSize) {
        int offset = index + 1;
        long maskedSize = this.attachedPartitions.getQuick(offset);
        if ((maskedSize & 0x80000FFFFFFFFFFFL) != partitionSize) {
            this.attachedPartitions.setQuick(offset, maskedSize & 0x7FFFF00000000000L | partitionSize);
            ++this.recordStructureVersion;
        }
    }

    private void writeTransientSymbolCount(int symbolIndex, int symCount) {
        long recordOffset = TableUtils.getSymbolWriterTransientIndexOffset(symbolIndex);
        assert (recordOffset + 4L <= this.readRecordSize);
        this.txMemBase.putInt((long)this.readBaseOffset + recordOffset, symCount);
    }

    void bumpPartitionTableVersion() {
        ++this.recordStructureVersion;
        ++this.partitionTableVersion;
    }

    boolean reconcileOptimisticPartitions() {
        int maxTimestampPartitionIndex;
        int lastPartitionTsIndex = this.attachedPartitions.size() - 4 + 0;
        if (lastPartitionTsIndex > 0 && this.maxTimestamp < this.attachedPartitions.getQuick(lastPartitionTsIndex) && (maxTimestampPartitionIndex = this.getPartitionIndex(this.getLastPartitionTimestamp())) < this.getPartitionCount() - 1) {
            long rowCount = 0L;
            int n = this.getPartitionCount() - 1;
            for (int i = maxTimestampPartitionIndex; i < n; ++i) {
                rowCount += this.getPartitionSize(i);
            }
            this.attachedPartitions.setPos((maxTimestampPartitionIndex + 1) * 4);
            ++this.recordStructureVersion;
            this.fixedRowCount -= rowCount;
            this.maxTimestamp = this.getMaxTimestamp();
            this.transientRowCount = this.getPartitionSize(maxTimestampPartitionIndex);
            return true;
        }
        return false;
    }

    void resetToLastPartition(long committedTransientRowCount, long newMaxTimestamp) {
        ++this.recordStructureVersion;
        this.updatePartitionSizeByTimestamp(this.maxTimestamp, committedTransientRowCount);
        this.maxTimestamp = this.prevMaxTimestamp = newMaxTimestamp;
        this.transientRowCount = committedTransientRowCount;
    }

    void resetToLastPartition(long committedTransientRowCount) {
        this.resetToLastPartition(committedTransientRowCount, this.getLong(32L));
    }

    long unsafeCommittedFixedRowCount() {
        return this.getLong(16L);
    }

    long unsafeCommittedTransientRowCount() {
        return this.getLong(8L);
    }

    void updatePartitionColumnVersion(long partitionTimestamp) {
        int index = this.findAttachedPartitionIndexByLoTimestamp(partitionTimestamp);
        this.attachedPartitions.set(index + 3, this.columnVersion);
    }

    void updatePartitionSizeAndTxnByIndex(int index, long partitionSize) {
        ++this.recordStructureVersion;
        this.updatePartitionSizeByIndex(index, partitionSize);
        this.attachedPartitions.set(index + 2, this.txn);
    }
}

