/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public final class ByteBinding
extends ComparableBinding {
    public static final ByteBinding BINDING = new ByteBinding();

    private ByteBinding() {
    }

    @Override
    public Byte readObject(@NotNull ByteArrayInputStream stream) {
        return (byte)(stream.read() ^ 0x80);
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        output.writeByte(((Byte)object).byteValue());
    }

    public static byte entryToByte(@NotNull ByteIterable entry) {
        return (Byte)BINDING.entryToObject(entry);
    }

    public static ArrayByteIterable byteToEntry(byte object) {
        return BINDING.objectToEntry(Byte.valueOf(object));
    }
}

