/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.schema;

import java.util.Map;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.schema.ContentClaimFieldMap;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordSchema;

public class FlowFileRecordFieldMap
implements Record {
    private final FlowFileRecord flowFile;
    private final RecordSchema schema;
    private final RecordSchema contentClaimSchema;
    private final ContentClaimFieldMap contentClaim;

    public FlowFileRecordFieldMap(FlowFileRecord flowFile, RecordSchema schema) {
        this.flowFile = flowFile;
        this.schema = schema;
        RecordField contentClaimField = schema.getField("Content Claim");
        this.contentClaimSchema = new RecordSchema(contentClaimField.getSubFields());
        this.contentClaim = flowFile.getContentClaim() == null ? null : new ContentClaimFieldMap(flowFile.getContentClaim(), flowFile.getContentClaimOffset(), this.contentClaimSchema);
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "Attributes": {
                return this.flowFile.getAttributes();
            }
            case "Content Claim": {
                return this.contentClaim;
            }
            case "Entry Date": {
                return this.flowFile.getEntryDate();
            }
            case "FlowFile Size": {
                return this.flowFile.getSize();
            }
            case "Lineage Start Date": {
                return this.flowFile.getLineageStartDate();
            }
            case "Lineage Start Index": {
                return this.flowFile.getLineageStartIndex();
            }
            case "Queued Date": {
                return this.flowFile.getLastQueueDate();
            }
            case "Queued Date Index": {
                return this.flowFile.getQueueDateIndex();
            }
            case "Record ID": {
                return this.flowFile.getId();
            }
        }
        return null;
    }

    public static FlowFileRecord getFlowFile(Record record, ResourceClaimManager claimManager) {
        StandardFlowFileRecord.Builder builder = new StandardFlowFileRecord.Builder();
        builder.id(((Long)record.getFieldValue("Record ID")).longValue());
        builder.entryDate(((Long)record.getFieldValue("Entry Date")).longValue());
        builder.size(((Long)record.getFieldValue("FlowFile Size")).longValue());
        builder.addAttributes((Map)record.getFieldValue("Attributes"));
        builder.lineageStart(((Long)record.getFieldValue("Lineage Start Date")).longValue(), ((Long)record.getFieldValue("Lineage Start Index")).longValue());
        builder.lastQueued(((Long)record.getFieldValue("Queued Date")).longValue(), ((Long)record.getFieldValue("Queued Date Index")).longValue());
        Record contentClaimRecord = (Record)record.getFieldValue("Content Claim");
        if (contentClaimRecord != null) {
            ContentClaim claim = ContentClaimFieldMap.getContentClaim(contentClaimRecord, claimManager);
            builder.contentClaim(claim);
            Long offset = ContentClaimFieldMap.getContentClaimOffset(contentClaimRecord);
            if (offset != null) {
                builder.contentClaimOffset(offset.longValue());
            }
        }
        return builder.build();
    }
}

