// ---------- Attention: Generated code, please do not modify! -----------

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.myfaces.tobago.component;

import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIHidden;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.Deprecation;
import org.apache.myfaces.tobago.component.Tags;
import jakarta.annotation.Generated;
import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;

/**
 Renders a hidden input element.
  * UIComponent class, generated from template {@code component.stg} with class
  * {@link org.apache.myfaces.tobago.internal.taglib.component.HiddenTagDeclaration}.
 */
@Generated("component.stg")
public class UIHidden
    extends AbstractUIHidden  {

  private static final Tags TAG = Tags.hidden;

  public static final String COMPONENT_TYPE = TAG.componentType();

  public static final String COMPONENT_FAMILY = "jakarta.faces.Input";

  private static final Collection<String> EVENT_NAMES = Arrays.asList("change");

  @Override
  public Collection<String> getEventNames() {
    return EVENT_NAMES;
  }

  @Override
  public String getDefaultEventName() {
    return "change";
  }


  enum PropertyKeys {
    readonly,
    disabled,
  }

  public String getFamily() {
    return COMPONENT_FAMILY;
  }


  /**
  Flag indicating that this component will prohibit changes by the user.
  <br>Default: <code>false</code>
  */
  public boolean isReadonly() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.readonly);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setReadonly(boolean readonly) {
    getStateHelper().put(PropertyKeys.readonly, readonly);
  }

  /**
  Flag indicating that this element is disabled.
  <br>Default: <code>false</code>
  */
  public boolean isDisabled() {
    Boolean bool = (Boolean) getStateHelper().eval(PropertyKeys.disabled);
    if (bool != null) {
      return bool;
    }
    return false;
  }

  public void setDisabled(boolean disabled) {
    getStateHelper().put(PropertyKeys.disabled, disabled);
  }


  @Override
  public void restoreState(FacesContext context, Object state) {
    // FIXME HACK for mojarra SystemEventListener state restoring bug
    pushComponentToEL(context, this);
    super.restoreState(context, state);
    popComponentFromEL(context);
  }

}