/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.script.appender;

import java.util.Objects;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderSet;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.script.Script;
import org.apache.logging.log4j.core.script.ScriptBindings;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;
import org.apache.logging.log4j.script.AbstractScript;

@Configurable(elementType="appender", printObject=true)
@Plugin
public final class ScriptAppenderSelector
extends AbstractAppender {
    @PluginFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private ScriptAppenderSelector(String name, Filter filter, Layout layout, Property[] properties) {
        super(name, filter, layout, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
    }

    public static final class Builder
    implements org.apache.logging.log4j.plugins.util.Builder<Appender> {
        @PluginElement(value="AppenderSet")
        @Required
        private @PluginElement(value="AppenderSet") AppenderSet appenderSet;
        @PluginConfiguration
        @Required
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required
        private String name;
        @PluginElement(value="Script")
        @Required
        private @PluginElement(value="Script") AbstractScript script;

        public Appender build() {
            if (this.name == null) {
                LOGGER.error("Name missing.");
                return null;
            }
            if (this.script == null) {
                LOGGER.error("Script missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            if (this.appenderSet == null) {
                LOGGER.error("AppenderSet missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            if (this.configuration == null) {
                LOGGER.error("Configuration missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            ScriptManager scriptManager = this.configuration.getScriptManager();
            if (scriptManager == null) {
                LOGGER.error("Script support is not enabled");
                return null;
            }
            if (!scriptManager.addScript((Script)this.script)) {
                return null;
            }
            ScriptBindings bindings = scriptManager.createBindings((Script)this.script);
            LOGGER.debug("ScriptAppenderSelector '{}' executing {} '{}': {}", (Object)this.name, (Object)this.script.getLanguage(), (Object)this.script.getName(), (Object)this.script.getScriptText());
            Object object = scriptManager.execute(this.script.getName(), bindings);
            String actualAppenderName = Objects.toString(object, null);
            LOGGER.debug("ScriptAppenderSelector '{}' selected '{}'", (Object)this.name, (Object)actualAppenderName);
            return this.appenderSet.createAppender(actualAppenderName, this.name);
        }

        public AppenderSet getAppenderSet() {
            return this.appenderSet;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public AbstractScript getScript() {
            return this.script;
        }

        public Builder setAppenderNodeSet(AppenderSet appenderSet) {
            this.appenderSet = appenderSet;
            return this;
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setScript(AbstractScript script) {
            this.script = script;
            return this;
        }
    }
}

