/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.conversant;

import aQute.bnd.annotation.spi.ServiceProvider;
import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import com.conversantmedia.util.concurrent.SpinPolicy;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.conversant.DisruptorRecyclerProperties;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.kit.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.kit.recycler.RecyclerProperties;
import org.apache.logging.log4j.kit.recycler.support.AbstractRecycler;
import org.apache.logging.log4j.status.StatusLogger;

@ServiceProvider(value=RecyclerFactoryProvider.class)
public final class DisruptorRecyclerFactoryProvider
implements RecyclerFactoryProvider {
    private static final Logger LOGGER = StatusLogger.getLogger();

    public int getOrder() {
        return 600;
    }

    public String getName() {
        return "conversant-disruptor";
    }

    public RecyclerFactory createForEnvironment(PropertyEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        return new DisruptorRecyclerFactory((RecyclerProperties)environment.getProperty(RecyclerProperties.class), (DisruptorRecyclerProperties)environment.getProperty(DisruptorRecyclerProperties.class));
    }

    private static final class DisruptorRecyclerFactory
    implements RecyclerFactory {
        private static final int MIN_CAPACITY = 8;
        private final int capacity;
        private final SpinPolicy spinPolicy;

        private DisruptorRecyclerFactory(RecyclerProperties recyclerProperties, DisruptorRecyclerProperties disruptorProperties) {
            this.capacity = DisruptorRecyclerFactory.validateCapacity(recyclerProperties.capacity());
            this.spinPolicy = disruptorProperties.spinPolicy();
        }

        public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
            Objects.requireNonNull(supplier, "supplier");
            Objects.requireNonNull(cleaner, "cleaner");
            DisruptorBlockingQueue queue = new DisruptorBlockingQueue(this.capacity, this.spinPolicy);
            return new DisruptorRecycler<V>(supplier, cleaner, queue);
        }

        private static Integer validateCapacity(int capacity) {
            if (capacity < 8) {
                LOGGER.warn("Invalid DisruptorBlockingQueue capacity {}, using minimum size {}.", (Object)capacity, (Object)8);
                return 8;
            }
            int roundedCapacity = Integers.ceilingNextPowerOfTwo((int)capacity);
            if (capacity != roundedCapacity) {
                LOGGER.warn("Invalid DisruptorBlockingQueue size {}, using rounded size {}.", (Object)capacity, (Object)roundedCapacity);
            }
            return roundedCapacity;
        }

        private static final class DisruptorRecycler<V>
        extends AbstractRecycler<V> {
            private final Consumer<V> cleaner;
            private final Queue<V> queue;

            private DisruptorRecycler(Supplier<V> supplier, Consumer<V> cleaner, Queue<V> queue) {
                super(supplier);
                this.cleaner = cleaner;
                this.queue = queue;
            }

            public V acquire() {
                V value = this.queue.poll();
                return (V)(value != null ? value : this.createInstance());
            }

            public void release(V value) {
                Objects.requireNonNull(value, "value");
                this.cleaner.accept(value);
                this.queue.offer(value);
            }
        }
    }
}

