/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.releaser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressFBWarnings(value={"REDOS"})
public final class ChangelogReleaserArgs {
    static final Pattern DEFAULT_VERSION_PATTERN = ChangelogReleaserArgs.createDefaultVersionPattern();
    final Path changelogDirectory;
    final String releaseVersion;
    final int releaseVersionMajor;
    final LocalDate releaseDate;

    private static Pattern createDefaultVersionPattern() {
        String majorPattern = "(?<minor>0|[1-9]\\d*)";
        String minorPattern = "(?<major>0|[1-9]\\d*)";
        String patchPattern = "(?<patch>(0|[1-9]\\d*)(-[a-zA-Z][0-9a-zA-Z-]*)?)";
        String pattern = String.format("^%s\\.%s\\.%s$", "(?<major>0|[1-9]\\d*)", "(?<minor>0|[1-9]\\d*)", "(?<patch>(0|[1-9]\\d*)(-[a-zA-Z][0-9a-zA-Z-]*)?)");
        return Pattern.compile(pattern);
    }

    public ChangelogReleaserArgs(Path changelogDirectory, String releaseVersion, Pattern versionPattern, LocalDate releaseDate) {
        this.changelogDirectory = Objects.requireNonNull(changelogDirectory, "changelogDirectory");
        this.releaseVersion = Objects.requireNonNull(releaseVersion, "releaseVersion");
        Pattern effectiveVersionPattern = versionPattern != null ? versionPattern : DEFAULT_VERSION_PATTERN;
        this.releaseVersionMajor = ChangelogReleaserArgs.readReleaseVersionMajor(releaseVersion, effectiveVersionPattern);
        this.releaseDate = Objects.requireNonNull(releaseDate, "releaseDate");
    }

    private static int readReleaseVersionMajor(String releaseVersion, Pattern versionPattern) {
        Matcher releaseVersionMatcher = versionPattern.matcher(releaseVersion);
        if (!releaseVersionMatcher.matches()) {
            String message = String.format("provided version `%s` does not match the expected pattern `%s`", releaseVersion, versionPattern);
            throw new IllegalArgumentException(message);
        }
        String releaseVersionMajorString = releaseVersionMatcher.group("major");
        if (releaseVersionMajorString == null) {
            String message = String.format("was expecting version pattern `%s` to provide a `major`-named group matching against the given version `%s`", versionPattern, releaseVersion);
            throw new IllegalArgumentException(message);
        }
        return Integer.parseInt(releaseVersionMajorString);
    }
}

