/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.wrapper.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.wrapper.WrapperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperServiceImpl
implements WrapperService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WrapperServiceImpl.class);

    @Override
    public void install() throws Exception {
        this.install("karaf", "karaf", "", "AUTO_START");
    }

    @Override
    public File[] install(String name, String displayName, String description, String startType, String[] envs, String[] includes) throws Exception {
        File file;
        File wrapperConf;
        File serviceFile;
        String arch;
        File base = new File(System.getProperty("karaf.base"));
        File etc = new File(System.getProperty("karaf.etc"));
        File bin = new File(base, "bin");
        File lib = new File(base, "lib/wrapper");
        if (name == null) {
            name = base.getName();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("${java.home}", System.getenv("JAVA_HOME"));
        props.put("${karaf.home}", System.getProperty("karaf.home"));
        props.put("${karaf.base}", base.getPath());
        props.put("${karaf.data}", System.getProperty("karaf.data"));
        props.put("${karaf.etc}", System.getProperty("karaf.etc"));
        props.put("${karaf.log}", System.getProperty("karaf.log"));
        props.put("${karaf.version}", System.getProperty("karaf.version"));
        props.put("${name}", name);
        props.put("${displayName}", displayName);
        props.put("${description}", description);
        props.put("${startType}", startType);
        String os = System.getProperty("os.name", "Unknown");
        File systemdFile = null;
        if (os.startsWith("Win")) {
            arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("amd64") || arch.equalsIgnoreCase("x86_64")) {
                this.mkdir(bin);
                this.copyResourceTo(new File(bin, name + "-wrapper.exe"), "windows64/karaf-wrapper.exe", false);
                serviceFile = new File(bin, name + "-service.bat");
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "windows64/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "windows64/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.copyFilteredResourceTo(serviceFile, "windows64/karaf-service.bat", props, envs, includes);
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "wrapper.dll"), "windows64/wrapper.dll", false);
            } else {
                this.mkdir(bin);
                this.copyResourceTo(new File(bin, name + "-wrapper.exe"), "windows/karaf-wrapper.exe", false);
                serviceFile = new File(bin, name + "-service.bat");
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "windows/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "windows/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.copyFilteredResourceTo(serviceFile, "windows/karaf-service.bat", props, envs, includes);
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "wrapper.dll"), "windows/wrapper.dll", false);
            }
        } else if (os.startsWith("Mac OS X")) {
            this.mkdir(bin);
            file = new File(bin, name + "-wrapper");
            this.copyResourceTo(file, "macosx/karaf-wrapper", false);
            this.makeFileExecutable(file);
            serviceFile = new File(bin, name + "-service");
            this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
            this.makeFileExecutable(serviceFile);
            wrapperConf = new File(etc, name + "-wrapper.conf");
            if (!System.getProperty("java.version").startsWith("1.")) {
                this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
            } else {
                this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
            }
            File plistConf = new File(bin, "org.apache.karaf." + name + ".plist");
            this.copyFilteredResourceTo(plistConf, "macosx/org.apache.karaf.KARAF.plist", props, envs, includes);
            this.mkdir(lib);
            this.copyResourceTo(new File(lib, "libwrapper.jnilib"), "macosx/libwrapper.jnilib", false);
        } else if (os.startsWith("Linux")) {
            arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("amd64") || arch.equalsIgnoreCase("x86_64")) {
                this.mkdir(bin);
                File file2 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file2, "linux64/karaf-wrapper", false);
                this.makeFileExecutable(file2);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                systemdFile = new File(bin, name + ".service");
                this.copyFilteredResourceTo(systemdFile, "unix/karaf.service", props, envs, includes);
                this.makeFileExecutable(systemdFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "linux64/libwrapper.so", false);
            } else {
                this.mkdir(bin);
                File file3 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file3, "linux/karaf-wrapper", false);
                this.makeFileExecutable(file3);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                systemdFile = new File(bin, name + ".service");
                this.copyFilteredResourceTo(systemdFile, "unix/karaf.service", props, envs, includes);
                this.makeFileExecutable(systemdFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "linux/libwrapper.so", false);
            }
        } else if (os.startsWith("AIX")) {
            arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("ppc64")) {
                this.mkdir(bin);
                File file4 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file4, "aix/ppc64/karaf-wrapper", false);
                this.makeFileExecutable(file4);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.a"), "aix/ppc64/libwrapper.a", false);
            } else {
                this.mkdir(bin);
                File file5 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file5, "aix/ppc32/karaf-wrapper", false);
                this.makeFileExecutable(file5);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.a"), "aix/ppc32/libwrapper.a", false);
            }
        } else if (os.startsWith("Solaris") || os.startsWith("SunOS")) {
            arch = System.getProperty("os.arch");
            if (arch.equalsIgnoreCase("sparc")) {
                this.mkdir(bin);
                File file6 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file6, "solaris/sparc64/karaf-wrapper", false);
                this.makeFileExecutable(file6);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "solaris/sparc64/libwrapper.so", false);
            } else if (arch.equalsIgnoreCase("x86")) {
                this.mkdir(bin);
                File file7 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file7, "solaris/x86/karaf-wrapper", false);
                this.makeFileExecutable(file7);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "solaris/x86/libwrapper.so", false);
            } else if (arch.equalsIgnoreCase("amd64") || arch.equalsIgnoreCase("x86_64")) {
                this.mkdir(bin);
                File file8 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file8, "solaris/x86_64/karaf-wrapper", false);
                this.makeFileExecutable(file8);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "solaris/x86_64/libwrapper.so", false);
            } else {
                this.mkdir(bin);
                File file9 = new File(bin, name + "-wrapper");
                this.copyResourceTo(file9, "solaris/sparc32/karaf-wrapper", false);
                this.makeFileExecutable(file9);
                serviceFile = new File(bin, name + "-service");
                this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
                this.makeFileExecutable(serviceFile);
                wrapperConf = new File(etc, name + "-wrapper.conf");
                if (!System.getProperty("java.version").startsWith("1.")) {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
                } else {
                    this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
                }
                this.mkdir(lib);
                this.copyResourceTo(new File(lib, "libwrapper.so"), "solaris/sparc32/libwrapper.so", false);
            }
        } else if (os.startsWith("HP-UX") || os.startsWith("HPUX")) {
            this.mkdir(bin);
            file = new File(bin, name + "-wrapper");
            this.copyResourceTo(file, "hpux/parisc64/karaf-wrapper", false);
            this.makeFileExecutable(file);
            serviceFile = new File(bin, name + "-service");
            this.copyFilteredResourceTo(serviceFile, "unix/karaf-service", props, envs, includes);
            this.makeFileExecutable(serviceFile);
            wrapperConf = new File(etc, name + "-wrapper.conf");
            if (!System.getProperty("java.version").startsWith("1.")) {
                this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java11.conf", props, envs, includes);
            } else {
                this.copyFilteredResourceTo(wrapperConf, "unix/karaf-wrapper-java8.conf", props, envs, includes);
            }
            this.mkdir(lib);
            this.copyResourceTo(new File(lib, "libwrapper.sl"), "hpux/parisc64/libwrapper.sl", false);
        } else {
            throw new IllegalStateException("Your operating system '" + os + "' is not currently supported.");
        }
        this.mkdir(lib);
        this.copyResourceTo(new File(lib, "karaf-wrapper.jar"), "all/karaf-wrapper.jar", false);
        this.mkdir(etc);
        this.createJar(new File(lib, "karaf-wrapper-main.jar"), "org/apache/karaf/wrapper/internal/service/Main.class");
        File[] wrapperPaths = new File[]{wrapperConf, serviceFile, systemdFile};
        return wrapperPaths;
    }

    private void mkdir(File file) {
        if (!file.exists()) {
            LOGGER.info("Creating missing directory: {}", (Object)file.getPath());
            System.out.println("Creating missing directory: " + SimpleAnsi.INTENSITY_BOLD + file.getPath() + SimpleAnsi.INTENSITY_NORMAL);
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceTo(File outFile, String resource, boolean text) throws Exception {
        if (!outFile.exists()) {
            LOGGER.info("Creating file: {}", (Object)outFile.getPath());
            System.out.println("Creating file: " + SimpleAnsi.INTENSITY_BOLD + outFile.getPath() + SimpleAnsi.INTENSITY_NORMAL);
            InputStream is = WrapperServiceImpl.class.getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalArgumentException("Resource " + resource + " doesn't exist");
            }
            try {
                if (text) {
                    PrintStream out = new PrintStream(new FileOutputStream(outFile));
                    try {
                        Scanner scanner = new Scanner(is);
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            LOGGER.info("writing: {}", (Object)line);
                            out.println(line);
                        }
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                FileOutputStream out = new FileOutputStream(outFile);
                try {
                    int c;
                    while ((c = is.read()) >= 0) {
                        out.write(c);
                    }
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        } else {
            LOGGER.warn("File already exists. Move it out of the way if you wish to recreate it: {}", (Object)outFile.getPath());
            System.out.println(SimpleAnsi.COLOR_RED + "File already exists" + SimpleAnsi.COLOR_DEFAULT + ". Move it out of the way if you wish to recreate it: " + outFile.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFilteredResourceTo(File outFile, String resource, HashMap<String, String> props, String[] envs, String[] includes) throws Exception {
        if (!outFile.exists()) {
            LOGGER.info("Creating file: {}", (Object)outFile.getPath());
            System.out.println("Creating file: " + SimpleAnsi.INTENSITY_BOLD + outFile.getPath() + SimpleAnsi.INTENSITY_NORMAL);
            InputStream is = WrapperServiceImpl.class.getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalArgumentException("Resource " + resource + " doesn't exist");
            }
            try {
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                try {
                    Scanner scanner = new Scanner(is);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        line = this.filter(line, props);
                        out.println(line);
                    }
                    if (!outFile.getName().endsWith(".conf")) return;
                    if (envs != null && envs.length > 0) {
                        for (String env : envs) {
                            out.println(env);
                        }
                    }
                    if (includes == null || includes.length <= 0) return;
                    for (String include : includes) {
                        out.println("#include " + include);
                    }
                    return;
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        } else {
            LOGGER.warn("File already exists. Move it out of the way if you wish to recreate it: {}", (Object)outFile.getPath());
            System.out.println(SimpleAnsi.COLOR_RED + "File already exists" + SimpleAnsi.COLOR_DEFAULT + ". Move it out of the way if you wish to recreate it: " + outFile.getPath());
        }
    }

    private void safeClose(Closeable c) throws IOException {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = ((String)line).indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = ((String)line).substring(0, p1);
            String l2 = ((String)line).substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void makeFileExecutable(File serviceFile) throws IOException {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Set<PosixFilePermission> filePermissions = Files.getPosixFilePermissions(serviceFile.toPath(), new LinkOption[0]);
        filePermissions.addAll(permissions);
        Files.setPosixFilePermissions(serviceFile.toPath(), filePermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJar(File outFile, String resource) throws Exception {
        if (!outFile.exists()) {
            LOGGER.info("Creating file: {}", (Object)outFile.getPath());
            System.out.println("Creating file: " + SimpleAnsi.INTENSITY_BOLD + outFile.getPath() + SimpleAnsi.INTENSITY_NORMAL);
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalStateException("Resource " + resource + " not found!");
            }
            JarOutputStream jar = null;
            try {
                int c;
                jar = new JarOutputStream(new FileOutputStream(outFile));
                int idx = resource.indexOf(47);
                while (idx > 0) {
                    jar.putNextEntry(new ZipEntry(resource.substring(0, idx + 1)));
                    jar.closeEntry();
                    idx = resource.indexOf(47, idx + 1);
                }
                jar.putNextEntry(new ZipEntry(resource));
                while ((c = is.read()) >= 0) {
                    jar.write(c);
                }
                jar.closeEntry();
                jar.close();
            }
            finally {
                this.safeClose(is);
                this.safeClose(jar);
            }
        }
    }

    @Override
    public File[] install(String name, String displayName, String description, String startType) throws Exception {
        return this.install(name, displayName, description, startType, null, null);
    }
}

