/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.Context;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ResettableSupplier;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Entry;
import org.apache.juneau.config.Section;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.internal.ConfigMapEntry;
import org.apache.juneau.config.mod.Mod;
import org.apache.juneau.config.mod.XorEncodeMod;
import org.apache.juneau.config.store.ClasspathStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.FileStore;
import org.apache.juneau.config.store.MemoryStore;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.json.Json5Serializer;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class Config
extends Context
implements ConfigEventListener {
    static final ResettableSupplier<Boolean> DISABLE_AUTO_SYSTEM_PROPS = Utils.memr(() -> Boolean.getBoolean("juneau.disableAutoSystemProps"));
    static final ResettableSupplier<Config> SYSTEM_DEFAULT = Utils.memr(() -> Config.findSystemDefault());
    protected final boolean multiLineValuesOnSeparateLines;
    protected final boolean readOnly;
    protected final int binaryLineLength;
    protected final BinaryFormat binaryFormat;
    protected final BeanSession beanSession;
    protected final ConfigStore store;
    protected final Map<Character, Mod> mods;
    protected final ReaderParser parser;
    protected final String name;
    protected final VarResolver varResolver;
    protected final VarResolverSession varSession;
    protected final WriterSerializer serializer;
    private final ConfigMap configMap;
    private final List<ConfigEventListener> listeners = CollectionUtils.synced(new LinkedList());

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(String name) {
        return new Builder().name(name);
    }

    public static synchronized List<String> getCandidateSystemDefaultConfigNames() {
        File[] fileArray;
        List l = CollectionUtils.listOf(String.class, (Object[])new String[0]);
        String s = System.getProperty("juneau.configFile");
        if (Utils.nn((Object)s)) {
            l.add(s);
            return l;
        }
        String cmd = System.getProperty("sun.java.command", "not_found").split("\\s+")[0];
        if (cmd.endsWith(".jar") && !Utils.co((String)cmd, (String)"surefirebooter")) {
            cmd = cmd.replaceAll(".*?([^\\\\\\/]+)\\.jar$", "$1");
            l.add(cmd + ".cfg");
            cmd = cmd.replaceAll("[\\.\\_].*$", "");
            l.add(cmd + ".cfg");
        }
        if ((fileArray = new File(".").listFiles()) != null) {
            for (File f : fileArray) {
                if (!f.getName().endsWith(".cfg")) continue;
                l.add(f.getName());
            }
        }
        l.add("juneau.cfg");
        l.add("default.cfg");
        l.add("application.cfg");
        l.add("app.cfg");
        l.add("settings.cfg");
        l.add("application.properties");
        return l;
    }

    public static synchronized Config getSystemDefault() {
        return (Config)SYSTEM_DEFAULT.get();
    }

    public static synchronized void setSystemDefault(Config systemDefault) {
        SYSTEM_DEFAULT.set((Object)systemDefault);
    }

    private static synchronized Config find(String name) {
        if (name == null) {
            return null;
        }
        if (FileStore.DEFAULT.exists(name)) {
            return Config.create(name).store(FileStore.DEFAULT).build();
        }
        if (ClasspathStore.DEFAULT.exists(name)) {
            return Config.create(name).store(ClasspathStore.DEFAULT).build();
        }
        return null;
    }

    private static synchronized Config findSystemDefault() {
        for (String n : Config.getCandidateSystemDefaultConfigNames()) {
            Config config = Config.find(n);
            if (!Utils.nn((Object)config)) continue;
            if (!((Boolean)DISABLE_AUTO_SYSTEM_PROPS.get()).booleanValue()) {
                config.setSystemProperties();
            }
            return config;
        }
        return null;
    }

    private static boolean isSimpleType(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class || c.isEnum();
    }

    private static String section(String section) {
        AssertionUtils.assertArgNotNull((String)"section", (Object)section);
        if (StringUtils.isEmpty((String)section)) {
            return "";
        }
        return section;
    }

    private static String skey(String key) {
        int i = key.indexOf(47);
        if (i == -1) {
            return key;
        }
        return key.substring(i + 1);
    }

    private static String sname(String key) {
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        int i = key.indexOf(47);
        if (i == -1) {
            return "";
        }
        return key.substring(0, i);
    }

    public Config(Builder builder) throws IOException {
        super((Context.Builder)builder);
        this.binaryFormat = builder.binaryFormat;
        this.binaryLineLength = builder.binaryLineLength;
        this.mods = CollectionUtils.u((Map)CollectionUtils.copyOf(builder.mods));
        this.multiLineValuesOnSeparateLines = builder.multiLineValuesOnSeparateLines;
        this.name = builder.name;
        this.parser = builder.parser;
        this.readOnly = builder.readOnly;
        this.serializer = builder.serializer;
        this.store = builder.store;
        this.varResolver = builder.varResolver;
        this.configMap = this.store.getMap(this.name);
        this.configMap.register(this);
        this.beanSession = this.parser.getBeanContext().getSession();
        this.varSession = ((VarResolver)this.varResolver.copy().vars(new Class[]{ConfigVar.class}).bean(Config.class, (Object)this).build()).createSession();
    }

    Config(Config copyFrom, VarResolverSession varSession) {
        super((Context)copyFrom);
        this.beanSession = copyFrom.beanSession;
        this.binaryFormat = copyFrom.binaryFormat;
        this.binaryLineLength = copyFrom.binaryLineLength;
        this.configMap = copyFrom.configMap;
        this.configMap.register(this);
        this.mods = copyFrom.mods;
        this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
        this.name = copyFrom.name;
        this.parser = copyFrom.parser;
        this.readOnly = copyFrom.readOnly;
        this.serializer = copyFrom.serializer;
        this.store = copyFrom.store;
        this.varSession = varSession;
        this.varResolver = copyFrom.varResolver;
    }

    public synchronized Config addListener(ConfigEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Config applyMods() {
        this.checkWrite();
        for (String section : this.configMap.getSections()) {
            for (String key : this.configMap.getKeys(section)) {
                ConfigMapEntry ce = this.configMap.getEntry(section, key);
                if (!Utils.nn((Object)ce.getModifiers())) continue;
                String mods2 = ce.getModifiers();
                String value = ce.getValue();
                for (int i = 0; i < mods2.length(); ++i) {
                    Mod mod = this.getMod(mods2.charAt(i));
                    if (mod.isApplied(value)) continue;
                    this.configMap.setEntry(section, key, mod.apply(value), null, null, null);
                }
            }
        }
        return this;
    }

    public void close() {
        this.configMap.unregister(this);
    }

    public Config commit() throws IOException {
        this.checkWrite();
        this.configMap.commit();
        return this;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public boolean exists(String key) {
        return Utils.ne((CharSequence)this.get(key).as(String.class).orElse(null));
    }

    public Entry get(String key) {
        return new Entry(this, this.configMap, Config.sname(key), Config.skey(key));
    }

    public Set<String> getKeys(String section) {
        return this.configMap.getKeys(Config.section(section));
    }

    public String getName() {
        return this.name;
    }

    public Section getSection(String name) {
        return new Section(this, this.configMap, StringUtils.emptyIfNull((String)name));
    }

    public Set<String> getSectionNames() {
        return CollectionUtils.u(this.configMap.getSections());
    }

    public String getString(String key) {
        return new Entry(this, this.configMap, Config.sname(key), Config.skey(key)).orElse(null);
    }

    public Config load(Map<String, Map<String, Object>> m) throws SerializeException {
        if (Utils.nn(m)) {
            for (Map.Entry<String, Map<String, Object>> e : m.entrySet()) {
                this.setSection(e.getKey(), null, e.getValue());
            }
        }
        return this;
    }

    public Config load(Reader contents, boolean synchronous) throws IOException, InterruptedException {
        this.checkWrite();
        this.configMap.load(IoUtils.read((Reader)contents), synchronous);
        return this;
    }

    public Config load(String contents, boolean synchronous) throws IOException, InterruptedException {
        this.checkWrite();
        this.configMap.load(contents, synchronous);
        return this;
    }

    @Override
    public synchronized void onConfigChange(ConfigEvents events) {
        this.listeners.forEach(x -> x.onConfigChange(events));
    }

    public Config remove(String key) {
        this.checkWrite();
        String sname = Config.sname(key);
        String skey = Config.skey(key);
        this.configMap.removeEntry(sname, skey);
        return this;
    }

    public Config removeImport(String sectionName, String importName) {
        this.checkWrite();
        this.configMap.removeImport(sectionName, importName);
        return this;
    }

    public synchronized Config removeListener(ConfigEventListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public Config removeSection(String name) {
        this.checkWrite();
        this.configMap.removeSection(name);
        return this;
    }

    public Config resolving(VarResolverSession varSession) {
        return new Config(this, varSession);
    }

    public Config rollback() {
        this.checkWrite();
        this.configMap.rollback();
        return this;
    }

    public Config set(String key, Object value) throws SerializeException {
        return this.set(key, value, null);
    }

    public Config set(String key, Object value, Serializer serializer) throws SerializeException {
        return this.set(key, this.serialize(value, serializer));
    }

    public Config set(String key, Object value, Serializer serializer, String modifiers, String comment, List<String> preLines) throws SerializeException {
        this.checkWrite();
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        String sname = Config.sname(key);
        String skey = Config.skey(key);
        modifiers = Utils.nullIfEmpty((String)modifiers);
        String s = this.applyMods(modifiers, this.serialize(value, serializer));
        this.configMap.setEntry(sname, skey, s, modifiers, comment, preLines);
        return this;
    }

    public Config set(String key, String value) {
        this.checkWrite();
        AssertionUtils.assertArgNotNull((String)"key", (Object)key);
        String sname = Config.sname(key);
        String skey = Config.skey(key);
        ConfigMapEntry ce = this.configMap.getEntry(sname, skey);
        if (ce == null && value == null) {
            return this;
        }
        String s = this.applyMods(ce == null ? null : ce.getModifiers(), Utils.s((Object)value));
        this.configMap.setEntry(sname, skey, s, null, null, null);
        return this;
    }

    public Config setImport(String sectionName, String importName, List<String> preLines) {
        this.checkWrite();
        this.configMap.setImport(Config.section(this.name), importName, preLines);
        return this;
    }

    public Config setSection(String name, List<String> preLines) {
        try {
            return this.setSection(Config.section(name), preLines, null);
        }
        catch (SerializeException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    public Config setSection(String name, List<String> preLines, Map<String, Object> contents) throws SerializeException {
        this.checkWrite();
        this.configMap.setSection(Config.section(name), preLines);
        if (Utils.nn(contents)) {
            for (Map.Entry<String, Object> e : contents.entrySet()) {
                this.set(Config.section(name) + "/" + e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public Config setSystemProperties() {
        for (String section : this.getSectionNames()) {
            for (String key : this.getKeys(section)) {
                String k = section.isEmpty() ? key : section + "/" + key;
                System.setProperty(k, this.getRaw(k));
            }
        }
        return this;
    }

    public JsonMap toMap() {
        return this.configMap.asMap();
    }

    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"binaryFormat", (Object)this.binaryFormat).a((Object)"binaryLineLength", (Object)this.binaryLineLength).a((Object)"mods", this.mods).a((Object)"multiLineValuesOnSeparateLines", (Object)this.multiLineValuesOnSeparateLines).a((Object)"name", (Object)this.name).a((Object)"parser", (Object)this.parser).a((Object)"readOnly", (Object)this.readOnly).a((Object)"serializer", (Object)this.serializer).a((Object)"store", (Object)this.store).a((Object)"varResolver", (Object)this.varResolver);
    }

    public String toString() {
        return this.configMap.toString();
    }

    public Writer writeTo(Writer w) throws IOException {
        return this.configMap.writeTo(w);
    }

    private String getRaw(String key) {
        String skey;
        String sname = Config.sname(key);
        ConfigMapEntry ce = this.configMap.getEntry(sname, skey = Config.skey(key));
        if (ce == null) {
            return null;
        }
        return this.removeMods(ce.getModifiers(), ce.getValue());
    }

    private String nlIfMl(CharSequence cs) {
        String s = cs.toString();
        if (s.indexOf(10) != -1 && this.multiLineValuesOnSeparateLines) {
            return "\n" + s;
        }
        return s;
    }

    private String serialize(Object value, Serializer serializer) throws SerializeException {
        if (value == null) {
            return "";
        }
        if (serializer == null) {
            serializer = this.serializer;
        }
        Class<?> c = value.getClass();
        if (value instanceof CharSequence) {
            CharSequence cs = (CharSequence)value;
            return this.nlIfMl(cs);
        }
        if (Config.isSimpleType(c)) {
            return value.toString();
        }
        if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            String s = null;
            s = this.binaryFormat == BinaryFormat.HEX ? StringUtils.toHex((byte[])b) : (this.binaryFormat == BinaryFormat.SPACED_HEX ? StringUtils.toSpacedHex((byte[])b) : StringUtils.base64Encode((byte[])b));
            int l = this.binaryLineLength;
            if (l <= 0 || s.length() <= l) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); i += l) {
                sb.append(this.binaryLineLength > 0 ? "\n" : "").append(s.substring(i, Math.min(s.length(), i + l)));
            }
            return sb.toString();
        }
        Object r = null;
        r = this.multiLineValuesOnSeparateLines ? "\n" + (String)serializer.serialize(value) : (String)serializer.serialize(value);
        if (((String)r).startsWith("'")) {
            return ((String)r).substring(1, ((String)r).length() - 1);
        }
        return r;
    }

    String applyMods(String mods, String x) {
        if (Utils.nn((Object)mods) && Utils.nn((Object)x)) {
            for (int i = 0; i < mods.length(); ++i) {
                x = this.getMod(mods.charAt(i)).doApply(x);
            }
        }
        return x;
    }

    void checkWrite() {
        if (this.readOnly) {
            throw ThrowableUtils.unsupportedOp((String)"Cannot call this method on a read-only configuration.", (Object[])new Object[0]);
        }
    }

    ConfigMap getConfigMap() {
        return this.configMap;
    }

    List<ConfigEventListener> getListeners() {
        return CollectionUtils.u(this.listeners);
    }

    Mod getMod(char id) {
        Mod x = this.mods.get(Character.valueOf(id));
        return (Mod)Utils.def((Object)x, (Object)Mod.NO_OP);
    }

    String removeMods(String mods, String x) {
        if (Utils.nn((Object)mods) && Utils.nn((Object)x)) {
            for (int i = mods.length() - 1; i > -1; --i) {
                x = this.getMod(mods.charAt(i)).doRemove(x);
            }
        }
        return x;
    }

    public static class Builder
    extends Context.Builder {
        private BinaryFormat binaryFormat;
        private boolean multiLineValuesOnSeparateLines;
        private boolean readOnly;
        private ConfigStore store;
        private int binaryLineLength;
        private Map<Character, Mod> mods;
        private ReaderParser parser;
        private String name;
        private VarResolver varResolver;
        private WriterSerializer serializer;

        protected Builder() {
            this.binaryFormat = (BinaryFormat)Utils.env((String)"Config.binaryFormat", (Object)BinaryFormat.BASE64);
            this.binaryLineLength = (Integer)Utils.env((String)"Config.binaryLineLength", (Object)-1);
            this.mods = CollectionUtils.map();
            this.mods(XorEncodeMod.INSTANCE);
            this.multiLineValuesOnSeparateLines = (Boolean)Utils.env((String)"Config.multiLineValuesOnSeparateLines", (Object)false);
            this.name = (String)Utils.env((String)"Config.name", (Object)"Configuration.cfg");
            this.parser = JsonParser.DEFAULT;
            this.readOnly = (Boolean)Utils.env((String)"Config.readOnly", (Object)false);
            this.serializer = Json5Serializer.DEFAULT;
            this.store = FileStore.DEFAULT;
            this.varResolver = VarResolver.DEFAULT;
        }

        protected Builder(Builder copyFrom) {
            super((Context.Builder)copyFrom);
            this.binaryFormat = copyFrom.binaryFormat;
            this.binaryLineLength = copyFrom.binaryLineLength;
            this.mods = CollectionUtils.copyOf(copyFrom.mods);
            this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
            this.name = copyFrom.name;
            this.parser = copyFrom.parser;
            this.readOnly = copyFrom.readOnly;
            this.serializer = copyFrom.serializer;
            this.store = copyFrom.store;
            this.varResolver = copyFrom.varResolver;
        }

        protected Builder(Config copyFrom) {
            super((Context)copyFrom);
            this.binaryFormat = copyFrom.binaryFormat;
            this.binaryLineLength = copyFrom.binaryLineLength;
            this.mods = CollectionUtils.copyOf(copyFrom.mods);
            this.multiLineValuesOnSeparateLines = copyFrom.multiLineValuesOnSeparateLines;
            this.name = copyFrom.name;
            this.parser = copyFrom.parser;
            this.readOnly = copyFrom.readOnly;
            this.serializer = copyFrom.serializer;
            this.store = copyFrom.store;
            this.varResolver = copyFrom.varResolver;
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder annotations(List<Annotation> values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public Builder binaryFormat(BinaryFormat value) {
            this.binaryFormat = (BinaryFormat)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder binaryLineLength(int value) {
            this.binaryLineLength = value;
            return this;
        }

        public Config build() {
            return (Config)this.build(Config.class);
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder memStore() {
            this.store = MemoryStore.DEFAULT;
            return this;
        }

        public Builder mods(Mod ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            for (Mod value : values) {
                this.mods.put(Character.valueOf(value.getId()), value);
            }
            return this;
        }

        public Builder multiLineValuesOnSeparateLines() {
            this.multiLineValuesOnSeparateLines = true;
            return this;
        }

        public Builder name(String value) {
            this.name = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder parser(ReaderParser value) {
            this.parser = (ReaderParser)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        public Builder serializer(WriterSerializer value) {
            this.serializer = (WriterSerializer)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder store(ConfigStore value) {
            this.store = (ConfigStore)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        public Builder varResolver(VarResolver value) {
            this.varResolver = (VarResolver)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }
    }
}

