/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;

public class SavedRequest
implements Serializable {
    private String method;
    private String queryString;
    private String requestURI;

    public SavedRequest(HttpServletRequest request) {
        this.method = request.getMethod();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestUrl() {
        StringBuilder requestUrl = new StringBuilder(this.getRequestURI());
        while (requestUrl.length() > 1 && requestUrl.charAt(1) == '/') {
            requestUrl.deleteCharAt(0);
        }
        if (this.getQueryString() != null) {
            requestUrl.append("?").append(this.getQueryString());
        }
        return requestUrl.toString();
    }
}

