/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.math.MonoAverageBigDecimal;
import reactor.math.MonoAverageBigInteger;
import reactor.math.MonoAverageDouble;
import reactor.math.MonoAverageFloat;
import reactor.math.MonoMinMax;
import reactor.math.MonoSumBigDecimal;
import reactor.math.MonoSumBigInteger;
import reactor.math.MonoSumDouble;
import reactor.math.MonoSumFloat;
import reactor.math.MonoSumInt;
import reactor.math.MonoSumLong;

public final class MathFlux {
    private MathFlux() {
    }

    public static Mono<Integer> sumInt(Publisher<? extends Number> source) {
        return MathFlux.sumInt(source, i -> i);
    }

    public static final <T> Mono<Integer> sumInt(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoSumInt<T>(source, mapping));
    }

    public static Mono<Long> sumLong(Publisher<? extends Number> source) {
        return MathFlux.sumLong(source, i -> i);
    }

    public static final <T> Mono<Long> sumLong(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoSumLong<T>(source, mapping));
    }

    public static Mono<Float> sumFloat(Publisher<? extends Number> source) {
        return MathFlux.sumFloat(source, i -> i);
    }

    public static final <T> Mono<Float> sumFloat(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoSumFloat<T>(source, mapping));
    }

    public static Mono<Double> sumDouble(Publisher<? extends Number> source) {
        return MathFlux.sumDouble(source, i -> i);
    }

    public static final <T> Mono<Double> sumDouble(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoSumDouble<T>(source, mapping));
    }

    public static Mono<BigInteger> sumBigInteger(Publisher<? extends Number> source) {
        return MathFlux.sumBigInteger(source, i -> i);
    }

    public static final <T> Mono<BigInteger> sumBigInteger(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoSumBigInteger<T>(source, mapping));
    }

    public static Mono<BigDecimal> sumBigDecimal(Publisher<? extends Number> source) {
        return MathFlux.sumBigDecimal(source, i -> i);
    }

    public static final <T> Mono<BigDecimal> sumBigDecimal(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoSumBigDecimal<T>(source, mapping));
    }

    public static Mono<Float> averageFloat(Publisher<? extends Number> source) {
        return MathFlux.averageFloat(source, i -> i);
    }

    public static final <T> Mono<Float> averageFloat(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoAverageFloat<T>(source, mapping));
    }

    public static Mono<Double> averageDouble(Publisher<? extends Number> source) {
        return MathFlux.averageDouble(source, i -> i);
    }

    public static final <T> Mono<Double> averageDouble(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoAverageDouble<T>(source, mapping));
    }

    public static Mono<BigInteger> averageBigInteger(Publisher<? extends Number> source) {
        return MathFlux.averageBigInteger(source, i -> i);
    }

    public static final <T> Mono<BigInteger> averageBigInteger(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoAverageBigInteger<T>(source, mapping));
    }

    public static Mono<BigDecimal> averageBigDecimal(Publisher<? extends Number> source) {
        return MathFlux.averageBigDecimal(source, i -> i);
    }

    public static final <T> Mono<BigDecimal> averageBigDecimal(Publisher<T> source, Function<? super T, ? extends Number> mapping) {
        return MathMono.onAssembly(new MonoAverageBigDecimal<T>(source, mapping));
    }

    public static final <T extends Comparable<? super T>> Mono<T> max(Publisher<T> source) {
        Comparator<T> comparator = MathFlux.comparableComparator();
        return MathFlux.max(source, comparator);
    }

    public static <T> Mono<T> max(Publisher<T> source, Comparator<? super T> comparator) {
        return MathMono.onAssembly(new MonoMinMax<T>(source, comparator, 1));
    }

    public static final <T extends Comparable<? super T>> Mono<T> min(Publisher<T> source) {
        Comparator<T> comparator = MathFlux.comparableComparator();
        return MathFlux.min(source, comparator);
    }

    public static <T> Mono<T> min(Publisher<T> source, Comparator<? super T> comparator) {
        return MathMono.onAssembly(new MonoMinMax<T>(source, comparator, -1));
    }

    static <T extends Comparable<? super T>> Comparator<? super T> comparableComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
    }

    static abstract class MathMono<T>
    extends Mono<T> {
        MathMono() {
        }

        protected static <T> Mono<T> onAssembly(Mono<T> source) {
            return Mono.onAssembly(source);
        }
    }
}

