/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexSetChanger;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;

class RowChangerImpl
implements RowChanger {
    boolean isOpen = false;
    boolean[] fixOnUpdate = null;
    long heapConglom;
    DynamicCompiledOpenConglomInfo heapDCOCI;
    StaticCompiledOpenConglomInfo heapSCOCI;
    long[] indexCIDS = null;
    DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    StaticCompiledOpenConglomInfo[] indexSCOCIs;
    IndexRowGenerator[] irgs = null;
    private final Activation activation;
    TransactionController tc;
    FormatableBitSet changedColumnBitSet;
    FormatableBitSet baseRowReadList;
    private int[] baseRowReadMap;
    int[] changedColumnIds;
    TemporaryRowHolderImpl rowHolder;
    String[] indexNames;
    private ConglomerateController baseCC;
    private RowLocation baseRowLocation;
    private IndexSetChanger isc;
    private DataValueDescriptor[] sparseRowArray;
    private int[] partialChangedColumnIds;

    public RowChangerImpl(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, DynamicCompiledOpenConglomInfo[] dynamicCompiledOpenConglomInfoArray, int n, int[] nArray, TransactionController transactionController, FormatableBitSet formatableBitSet, int[] nArray2, Activation activation) throws StandardException {
        this.heapConglom = l;
        this.heapSCOCI = staticCompiledOpenConglomInfo;
        this.heapDCOCI = dynamicCompiledOpenConglomInfo;
        this.irgs = indexRowGeneratorArray;
        this.indexCIDS = lArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.indexDCOCIs = dynamicCompiledOpenConglomInfoArray;
        this.tc = transactionController;
        this.baseRowReadList = formatableBitSet;
        this.baseRowReadMap = nArray2;
        this.activation = activation;
        if (nArray != null) {
            int n2;
            this.changedColumnIds = RowUtil.inAscendingOrder(nArray) ? nArray : this.sortArray(nArray);
            this.sparseRowArray = new DataValueDescriptor[this.changedColumnIds[this.changedColumnIds.length - 1] + 1];
            this.changedColumnBitSet = new FormatableBitSet(n);
            for (n2 = 0; n2 < this.changedColumnIds.length; ++n2) {
                this.changedColumnBitSet.grow(this.changedColumnIds[n2]);
                this.changedColumnBitSet.set(this.changedColumnIds[n2] - 1);
            }
            if (formatableBitSet != null) {
                this.partialChangedColumnIds = new int[this.changedColumnIds.length];
                n2 = 1;
                int n3 = 0;
                for (int i = 0; i < this.changedColumnIds.length; ++i) {
                    while (n3 < this.changedColumnIds[i]) {
                        if (formatableBitSet.get(n3)) {
                            ++n2;
                        }
                        ++n3;
                    }
                    this.partialChangedColumnIds[i] = n2;
                }
            }
        }
    }

    @Override
    public void setRowHolder(TemporaryRowHolder temporaryRowHolder) {
        this.rowHolder = (TemporaryRowHolderImpl)temporaryRowHolder;
    }

    @Override
    public void setIndexNames(String[] stringArray) {
        this.indexNames = stringArray;
    }

    @Override
    public void open(int n) throws StandardException {
        this.open(n, true);
    }

    @Override
    public void open(int n, boolean bl) throws StandardException {
        if (this.fixOnUpdate == null) {
            this.fixOnUpdate = new boolean[this.irgs.length];
            for (int i = 0; i < this.irgs.length; ++i) {
                this.fixOnUpdate[i] = true;
            }
        }
        this.openForUpdate(this.fixOnUpdate, n, bl);
    }

    @Override
    public void openForUpdate(boolean[] blArray, int n, boolean bl) throws StandardException {
        LanguageConnectionContext languageConnectionContext = null;
        if (this.activation != null) {
            languageConnectionContext = this.activation.getLanguageConnectionContext();
        }
        int n2 = languageConnectionContext == null ? 2 : languageConnectionContext.getCurrentIsolationLevel();
        switch (n2) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
        }
        try {
            this.baseCC = this.heapSCOCI != null ? this.tc.openCompiledConglomerate(false, 4 | (bl ? 0 : 128), n, n2, this.heapSCOCI, this.heapDCOCI) : this.tc.openConglomerate(this.heapConglom, false, 4 | (bl ? 0 : 128), n, n2);
        }
        catch (StandardException standardException) {
            if (this.activation != null) {
                this.activation.checkStatementValidity();
            }
            throw standardException;
        }
        if (this.activation != null) {
            this.activation.checkStatementValidity();
            this.activation.setHeapConglomerateController(this.baseCC);
        }
        if (this.indexCIDS.length != 0) {
            if (this.isc == null) {
                this.isc = new IndexSetChanger(this.irgs, this.indexCIDS, this.indexSCOCIs, this.indexDCOCIs, this.indexNames, this.baseCC, this.tc, n, this.baseRowReadList, n2, this.activation);
                this.isc.setRowHolder(this.rowHolder);
            } else {
                this.isc.setBaseCC(this.baseCC);
            }
            this.isc.open(blArray);
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.baseCC.newRowLocationTemplate();
            }
        }
        this.isOpen = true;
    }

    @Override
    public RowLocation insertRow(ExecRow execRow, boolean bl) throws StandardException {
        if (!this.baseCC.isKeyed()) {
            if (this.isc != null || bl) {
                if (this.baseRowLocation == null) {
                    this.baseRowLocation = this.baseCC.newRowLocationTemplate();
                }
                this.baseCC.insertAndFetchLocation(execRow.getRowArray(), this.baseRowLocation);
                if (this.isc != null) {
                    this.isc.insert(execRow, this.baseRowLocation);
                }
            } else {
                this.baseCC.insert(execRow.getRowArray());
            }
        }
        return bl ? this.baseRowLocation : null;
    }

    @Override
    public void deleteRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.isc != null) {
            this.isc.delete(execRow, rowLocation);
        }
        this.baseCC.delete(rowLocation);
    }

    @Override
    public void updateRow(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        if (this.isc != null) {
            this.isc.update(execRow, execRow2, rowLocation);
        }
        if (this.changedColumnBitSet != null) {
            DataValueDescriptor[] dataValueDescriptorArray = execRow2.getRowArray();
            int[] nArray = this.partialChangedColumnIds == null ? this.changedColumnIds : this.partialChangedColumnIds;
            int n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i] - 1;
                n = this.changedColumnBitSet.anySetBit(n);
                this.sparseRowArray[n] = dataValueDescriptorArray[n2];
            }
        } else {
            this.sparseRowArray = execRow2.getRowArray();
        }
        this.baseCC.replace(rowLocation, this.sparseRowArray, this.changedColumnBitSet);
    }

    @Override
    public void finish() throws StandardException {
        if (this.isc != null) {
            this.isc.finish();
        }
    }

    @Override
    public void close() throws StandardException {
        if (this.isc != null) {
            this.isc.close();
        }
        if (this.baseCC != null) {
            if (this.activation == null || this.activation.getForUpdateIndexScan() == null) {
                this.baseCC.close();
            }
            this.baseCC = null;
        }
        this.isOpen = false;
        if (this.activation != null) {
            this.activation.clearHeapConglomerateController();
        }
    }

    @Override
    public ConglomerateController getHeapConglomerateController() {
        return this.baseCC;
    }

    private int[] sortArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        Arrays.sort(nArray2);
        return nArray2;
    }

    @Override
    public int findSelectedCol(int n) {
        if (n == -1) {
            return -1;
        }
        int[] nArray = this.partialChangedColumnIds == null ? this.changedColumnIds : this.partialChangedColumnIds;
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != (n2 = this.changedColumnBitSet.anySetBit(n2)) + 1) continue;
            return nArray[i];
        }
        return -1;
    }

    public String toString() {
        return super.toString();
    }
}

