/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class AutoDateHistogramAggregate
extends MultiBucketAggregateBase<DateHistogramBucket>
implements AggregateVariant {
    private final String interval;
    public static final JsonpDeserializer<AutoDateHistogramAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoDateHistogramAggregate::setupAutoDateHistogramAggregateDeserializer);

    private AutoDateHistogramAggregate(Builder builder) {
        super(builder);
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
    }

    public static AutoDateHistogramAggregate of(Function<Builder, ObjectBuilder<AutoDateHistogramAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.AutoDateHistogram;
    }

    public final String interval() {
        return this.interval;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("interval");
        generator.write(this.interval);
    }

    protected static void setupAutoDateHistogramAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AutoDateHistogramAggregate.setupMultiBucketAggregateBaseDeserializer(op, DateHistogramBucket._DESERIALIZER);
        op.add(Builder::interval, JsonpDeserializer.stringDeserializer(), "interval");
    }

    public static class Builder
    extends MultiBucketAggregateBase.AbstractBuilder<DateHistogramBucket, Builder>
    implements ObjectBuilder<AutoDateHistogramAggregate> {
        private String interval;

        public final Builder interval(String value) {
            this.interval = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AutoDateHistogramAggregate build() {
            this._checkSingleUse();
            super.tBucketSerializer(null);
            return new AutoDateHistogramAggregate(this);
        }
    }
}

