/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.es.v7;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.linagora.elasticsearch.metrics.ElasticsearchReporter;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.metrics.es.v7.ESReporterConfiguration;

public class ESMetricReporter
implements Startable {
    private final Optional<ElasticsearchReporter> reporter;
    private final ESReporterConfiguration esReporterConfiguration;

    @Inject
    public ESMetricReporter(ESReporterConfiguration esReporterConfiguration, MetricRegistry registry) {
        this.reporter = this.getReporter(esReporterConfiguration, registry);
        this.esReporterConfiguration = esReporterConfiguration;
    }

    private Optional<ElasticsearchReporter> getReporter(ESReporterConfiguration esReporterConfiguration, MetricRegistry registry) {
        if (esReporterConfiguration.isEnabled()) {
            try {
                return Optional.of(ElasticsearchReporter.forRegistry((MetricRegistry)registry).hosts(new String[]{esReporterConfiguration.getHostWithPort()}).index(esReporterConfiguration.getIndex()).build());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    public void start() {
        this.reporter.ifPresent(elasticsearchReporter -> elasticsearchReporter.start(this.esReporterConfiguration.getPeriodInSecond(), TimeUnit.SECONDS));
    }

    @PreDestroy
    public void stop() {
        this.reporter.ifPresent(ScheduledReporter::stop);
    }
}

