/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    protected Resolver resolver;

    public DNSPublicKeyRecordRetriever() {
        this(Lookup.getDefaultResolver());
    }

    public DNSPublicKeyRecordRetriever(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        if (!"dns/txt".equals(methodAndOptions)) {
            throw new PermFailException("Only dns/txt is supported: " + methodAndOptions + " options unsupported.");
        }
        try {
            Lookup query = new Lookup(selector + "._domainkey." + token, 16);
            query.setResolver(this.resolver);
            Record[] rr = query.run();
            int queryResult = query.getResult();
            if (queryResult == 2) {
                throw new TempFailException(query.getErrorString());
            }
            List<String> records = DNSPublicKeyRecordRetriever.convertRecordsToList(rr);
            return records;
        }
        catch (TextParseException e) {
            return null;
        }
    }

    public static List<String> convertRecordsToList(Record[] rr) {
        ArrayList<String> records;
        if (rr != null && rr.length > 0) {
            records = new ArrayList<String>();
            block3: for (int i = 0; i < rr.length; ++i) {
                switch (rr[i].getType()) {
                    case 16: {
                        TXTRecord txt = (TXTRecord)rr[i];
                        if (txt.getStrings().size() == 1) {
                            records.add((String)txt.getStrings().get(0));
                            continue block3;
                        }
                        StringBuilder sb = new StringBuilder();
                        for (String k : txt.getStrings()) {
                            sb.append(k);
                        }
                        records.add(sb.toString());
                        continue block3;
                    }
                    default: {
                        return null;
                    }
                }
            }
        } else {
            records = null;
        }
        return records;
    }
}

