/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.cassandra.CassandraRepositoryConfiguration;
import org.apache.james.user.lib.UsersDAO;
import org.apache.james.user.lib.model.Algorithm;
import org.apache.james.user.lib.model.DefaultUser;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraUsersDAO
implements UsersDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement getUserStatement;
    private final PreparedStatement updateUserStatement;
    private final PreparedStatement removeUserStatement;
    private final PreparedStatement countUserStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement insertStatement;
    private final Algorithm preferredAlgorithm;
    private final Algorithm.HashingMode fallbackHashingMode;

    @Inject
    public CassandraUsersDAO(Session session, CassandraRepositoryConfiguration configuration) {
        this.executor = new CassandraAsyncExecutor(session);
        this.getUserStatement = this.prepareGetUserStatement(session);
        this.updateUserStatement = this.prepareUpdateUserStatement(session);
        this.removeUserStatement = this.prepareRemoveUserStatement(session);
        this.countUserStatement = this.prepareCountStatement(session);
        this.listStatement = this.prepareListStatement(session);
        this.insertStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"user").value("name", (Object)QueryBuilder.bindMarker((String)"name")).value("realname", (Object)QueryBuilder.bindMarker((String)"realname")).value("passwd", (Object)QueryBuilder.bindMarker((String)"passwd")).value("algorithm", (Object)QueryBuilder.bindMarker((String)"algorithm")).ifNotExists());
        this.preferredAlgorithm = configuration.getPreferredAlgorithm();
        this.fallbackHashingMode = configuration.getFallbackHashingMode();
    }

    @VisibleForTesting
    public CassandraUsersDAO(Session session) {
        this(session, CassandraRepositoryConfiguration.DEFAULT);
    }

    private PreparedStatement prepareListStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"name"}).from("user"));
    }

    private PreparedStatement prepareCountStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().countAll().from("user"));
    }

    private PreparedStatement prepareRemoveUserStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("user").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).ifExists());
    }

    private PreparedStatement prepareUpdateUserStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"user").with(QueryBuilder.set((String)"realname", (Object)QueryBuilder.bindMarker((String)"realname"))).and(QueryBuilder.set((String)"passwd", (Object)QueryBuilder.bindMarker((String)"passwd"))).and(QueryBuilder.set((String)"algorithm", (Object)QueryBuilder.bindMarker((String)"algorithm"))).where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).ifExists());
    }

    private PreparedStatement prepareGetUserStatement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"name", "passwd", "algorithm"}).from("user").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
    }

    public Optional<DefaultUser> getUserByName(Username name) {
        return this.getUserByNameReactive(name).blockOptional();
    }

    private Mono<DefaultUser> getUserByNameReactive(Username name) {
        return this.executor.executeSingleRow((Statement)this.getUserStatement.bind().setString("name", name.asString())).map(row -> new DefaultUser(Username.of((String)row.getString("name")), row.getString("passwd"), Algorithm.of((String)row.getString("algorithm"), (Algorithm.HashingMode)this.fallbackHashingMode), this.preferredAlgorithm));
    }

    public void updateUser(User user) throws UsersRepositoryException {
        Preconditions.checkArgument((boolean)(user instanceof DefaultUser));
        DefaultUser defaultUser = (DefaultUser)user;
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.updateUserStatement.bind().setString("realname", defaultUser.getUserName().asString()).setString("passwd", defaultUser.getHashedPassword()).setString("algorithm", defaultUser.getHashAlgorithm().asString()).setString("name", defaultUser.getUserName().asString())).block();
        if (!executed) {
            throw new UsersRepositoryException("Unable to update user");
        }
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.removeUserStatement.bind().setString("name", name.asString())).block();
        if (!executed) {
            throw new UsersRepositoryException("unable to remove unknown user " + name.asString());
        }
    }

    public boolean contains(Username name) {
        return this.getUserByName(name).isPresent();
    }

    public Publisher<Boolean> containsReactive(Username name) {
        return this.getUserByNameReactive(name).hasElement();
    }

    public int countUsers() {
        return (Integer)this.executor.executeSingleRow((Statement)this.countUserStatement.bind()).map(row -> Ints.checkedCast((long)row.getLong(0))).block();
    }

    public Iterator<Username> list() {
        return this.executor.executeRows((Statement)this.listStatement.bind()).map(row -> row.getString("name")).map(Username::of).toIterable().iterator();
    }

    public void addUser(Username username, String password) throws UsersRepositoryException {
        DefaultUser user = new DefaultUser(username, this.preferredAlgorithm, this.preferredAlgorithm);
        user.setPassword(password);
        boolean executed = (Boolean)this.executor.executeReturnApplied((Statement)this.insertStatement.bind().setString("name", user.getUserName().asString()).setString("realname", user.getUserName().asString()).setString("passwd", user.getHashedPassword()).setString("algorithm", user.getHashAlgorithm().asString())).block();
        if (!executed) {
            throw new AlreadyExistInUsersRepositoryException("User with username " + username + " already exist!");
        }
    }

    public boolean getDefaultVirtualHostingValue() {
        return true;
    }
}

