/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.EndPoint;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.QueryExecutionException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class OverloadedException
extends QueryExecutionException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public OverloadedException(EndPoint endPoint, String message) {
        super(String.format("Queried host (%s) was overloaded: %s", endPoint, message));
        this.endPoint = endPoint;
    }

    private OverloadedException(EndPoint endPoint, String message, OverloadedException cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public OverloadedException copy() {
        return new OverloadedException(this.endPoint, this.getMessage(), this);
    }
}

