/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderHostIs
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SenderHostIs.class);
    private Collection<Domain> senderHosts;

    public void init() {
        String condition = this.getCondition();
        Preconditions.checkNotNull((Object)condition, (Object)"'condition' should not be null");
        this.senderHosts = this.parseDomainsList(condition);
    }

    @VisibleForTesting
    Collection<Domain> parseDomainsList(String condition) {
        return (Collection)Splitter.onPattern((String)"(, |,| )").omitEmptyStrings().splitToList((CharSequence)condition).stream().map(Domain::of).collect(ImmutableList.toImmutableList());
    }

    public Collection<MailAddress> match(Mail mail) {
        try {
            if (mail.getMaybeSender().asOptional().map(mailAddress -> this.senderHosts.contains(mailAddress.getDomain())).orElse(false).booleanValue()) {
                return mail.getRecipients();
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }
}

