/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DefaultExpressionTraversalVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.udf.TableUDFUtils;

public final class ExpressionTreeUtils {
    private ExpressionTreeUtils() {
    }

    static List<FunctionCall> extractAggregateFunctions(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils::isAggregation);
    }

    public static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz) {
        return ExpressionTreeUtils.extractExpressions(nodes, clazz, Predicates.alwaysTrue());
    }

    private static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz, Predicate<T> predicate) {
        Objects.requireNonNull(nodes, "nodes is null");
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)Streams.stream(nodes).flatMap(node -> ExpressionTreeUtils.linearizeNodes(node).stream()).filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(ImmutableList.toImmutableList());
    }

    public static List<FunctionCall> extractWindowFunctions(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils::isWindowFunction);
    }

    static List<Expression> extractWindowExpressions(Iterable<? extends Node> nodes) {
        return ImmutableList.builder().addAll(ExpressionTreeUtils.extractWindowFunctions(nodes)).build();
    }

    private static boolean isWindowFunction(FunctionCall functionCall) {
        return functionCall.getWindow().isPresent();
    }

    private static boolean isAggregation(FunctionCall functionCall) {
        return ExpressionTreeUtils.isAggregationFunction(functionCall.getName().toString()) && !functionCall.getWindow().isPresent();
    }

    private static List<Node> linearizeNodes(Node node) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<Void>(){

            @Override
            public Void process(Node node, Void context) {
                super.process(node, context);
                nodes.add((Object)node);
                return null;
            }
        }.process(node, (Void)null);
        return nodes.build();
    }

    public static QualifiedName asQualifiedName(Expression expression) {
        QualifiedName name = null;
        if (expression instanceof Identifier) {
            name = QualifiedName.of(((Identifier)expression).getValue());
        } else if (expression instanceof DereferenceExpression) {
            name = DereferenceExpression.getQualifiedName((DereferenceExpression)expression);
        }
        return name;
    }

    static boolean isAggregationFunction(String functionName) {
        return TableBuiltinAggregationFunction.getBuiltInAggregateFunctionName().contains(functionName.toLowerCase()) || TableUDFUtils.isAggregateFunction(functionName);
    }
}

