/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.LastSeriesSourceNode;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.eclipse.jetty.util.StringUtil;

public class LastQueryScanNode
extends LastSeriesSourceNode {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LastQueryScanNode.class);
    public static final List<String> LAST_QUERY_HEADER_COLUMNS = ImmutableList.of((Object)"Timeseries", (Object)"Value", (Object)"DataType");
    private final PartialPath devicePath;
    private final boolean aligned;
    private final List<Integer> indexOfMeasurementSchemas;
    private List<IMeasurementSchema> globalMeasurementSchemaList;
    private final String outputViewPath;
    private TRegionReplicaSet regionReplicaSet;
    private boolean deviceInMultiRegion = false;

    public LastQueryScanNode(PlanNodeId id, PartialPath devicePath, boolean aligned, List<Integer> indexOfMeasurementSchemas, String outputViewPath, List<IMeasurementSchema> globalMeasurementSchemaList) {
        super(id, new AtomicInteger(1));
        this.aligned = aligned;
        this.devicePath = devicePath;
        this.indexOfMeasurementSchemas = indexOfMeasurementSchemas;
        this.outputViewPath = outputViewPath;
        this.globalMeasurementSchemaList = globalMeasurementSchemaList;
    }

    public LastQueryScanNode(PlanNodeId id, PartialPath devicePath, boolean aligned, List<Integer> indexOfMeasurementSchemas, AtomicInteger dataNodeSeriesScanNum, String outputViewPath) {
        this(id, devicePath, aligned, indexOfMeasurementSchemas, dataNodeSeriesScanNum, outputViewPath, null);
    }

    public LastQueryScanNode(PlanNodeId id, PartialPath devicePath, boolean aligned, List<Integer> indexOfMeasurementSchemas, AtomicInteger dataNodeSeriesScanNum, String outputViewPath, List<IMeasurementSchema> globalMeasurementSchemaList) {
        super(id, dataNodeSeriesScanNum);
        this.aligned = aligned;
        this.devicePath = devicePath;
        this.indexOfMeasurementSchemas = indexOfMeasurementSchemas;
        this.outputViewPath = outputViewPath;
        this.globalMeasurementSchemaList = globalMeasurementSchemaList;
    }

    public LastQueryScanNode(PlanNodeId id, PartialPath devicePath, boolean aligned, List<Integer> indexOfMeasurementSchemas, AtomicInteger dataNodeSeriesScanNum, String outputViewPath, TRegionReplicaSet regionReplicaSet, boolean deviceInMultiRegion, List<IMeasurementSchema> globalMeasurementSchemaList) {
        super(id, dataNodeSeriesScanNum);
        this.devicePath = devicePath;
        this.aligned = aligned;
        this.indexOfMeasurementSchemas = indexOfMeasurementSchemas;
        this.outputViewPath = outputViewPath;
        this.regionReplicaSet = regionReplicaSet;
        this.deviceInMultiRegion = deviceInMultiRegion;
        this.globalMeasurementSchemaList = globalMeasurementSchemaList;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public PartialPath getSeriesPath() {
        return this.devicePath;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public String getOutputViewPath() {
        return this.outputViewPath;
    }

    public String getOutputSymbolForSort() {
        if (this.outputViewPath != null) {
            return this.outputViewPath;
        }
        return this.devicePath.toString();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for SeriesScanNode");
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.LAST_QUERY_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new LastQueryScanNode(this.getPlanNodeId(), this.devicePath, this.aligned, this.indexOfMeasurementSchemas, this.getDataNodeSeriesScanNum(), this.outputViewPath, this.regionReplicaSet, this.deviceInMultiRegion, this.globalMeasurementSchemaList);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LAST_QUERY_HEADER_COLUMNS;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQueryScan(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryScanNode that = (LastQueryScanNode)o;
        return Objects.equals(this.devicePath, that.devicePath) && Objects.equals(this.aligned, that.aligned) && Objects.equals(this.indexOfMeasurementSchemas, that.indexOfMeasurementSchemas) && Objects.equals(this.outputViewPath, that.outputViewPath) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.devicePath, this.aligned, this.indexOfMeasurementSchemas, this.outputViewPath, this.regionReplicaSet);
    }

    public String toString() {
        if (StringUtil.isNotBlank((String)this.outputViewPath)) {
            return String.format("LastQueryScanNode-%s:[Device: %s, Aligned: %s, Measurements: %s, ViewPath: %s, DataRegion: %s]", this.getPlanNodeId(), this.getDevicePath(), this.aligned, this.getMeasurementSchemas(), this.getOutputViewPath(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
        }
        return String.format("LastQueryScanNode-%s:[Device: %s, Aligned: %s, Measurements: %s, DataRegion: %s]", this.getPlanNodeId(), this.getDevicePath(), this.aligned, this.getMeasurementSchemas(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY_SCAN.serialize(byteBuffer);
        this.devicePath.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.aligned, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.indexOfMeasurementSchemas.size(), (ByteBuffer)byteBuffer);
        for (Integer measurementSchema : this.indexOfMeasurementSchemas) {
            ReadWriteIOUtils.write((int)measurementSchema, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.getDataNodeSeriesScanNum().get(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)(this.outputViewPath == null ? 1 : 0), (ByteBuffer)byteBuffer);
        if (this.outputViewPath != null) {
            ReadWriteIOUtils.write((String)this.outputViewPath, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.deviceInMultiRegion, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY_SCAN.serialize(stream);
        this.devicePath.serialize((OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.aligned, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.indexOfMeasurementSchemas.size(), (OutputStream)stream);
        for (Integer measurementSchema : this.indexOfMeasurementSchemas) {
            ReadWriteIOUtils.write((int)measurementSchema, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.getDataNodeSeriesScanNum().get(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)(this.outputViewPath == null ? 1 : 0), (OutputStream)stream);
        if (this.outputViewPath != null) {
            ReadWriteIOUtils.write((String)this.outputViewPath, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.deviceInMultiRegion, (OutputStream)stream);
    }

    public static LastQueryScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath devicePath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        boolean aligned = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int measurementSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Integer> measurementSchemas = new ArrayList<Integer>(measurementSize);
        for (int i = 0; i < measurementSize; ++i) {
            measurementSchemas.add(ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        }
        int dataNodeSeriesScanNum = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        boolean isNull = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        String outputPathSymbol = isNull ? null : ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        boolean deviceInMultiRegion = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryScanNode(planNodeId, devicePath, aligned, measurementSchemas, new AtomicInteger(dataNodeSeriesScanNum), outputPathSymbol, null, deviceInMultiRegion, null);
    }

    public void setGlobalMeasurementSchemaList(List<IMeasurementSchema> globalMeasurementSchemaList) {
        this.globalMeasurementSchemaList = globalMeasurementSchemaList;
    }

    public IMeasurementSchema getMeasurementSchema(int idx) {
        int globalIdx = this.indexOfMeasurementSchemas.get(idx);
        return this.globalMeasurementSchemaList.get(globalIdx);
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public boolean isDeviceInMultiRegion() {
        return this.deviceInMultiRegion;
    }

    public void setDeviceInMultiRegion(boolean deviceInMultiRegion) {
        this.deviceInMultiRegion = deviceInMultiRegion;
    }

    public List<Integer> getIdxOfMeasurementSchemas() {
        return this.indexOfMeasurementSchemas;
    }

    public List<IMeasurementSchema> getMeasurementSchemas() {
        return this.indexOfMeasurementSchemas.stream().map(this.globalMeasurementSchemaList::get).collect(Collectors.toList());
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.devicePath;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.id) + MemoryEstimationHelper.getEstimatedSizeOfCopiedPartialPath(this.devicePath) + MemoryEstimationHelper.getEstimatedSizeOfIntegerArrayList(this.indexOfMeasurementSchemas) + RamUsageEstimator.sizeOf((String)this.outputViewPath);
    }
}

