/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.PartitionViolationException;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils.InsertionCompactionCandidateStatus;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileLock;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileRepairStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceBlockType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.FilePathUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResource
implements Cloneable {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TsFileResource.class) + RamUsageEstimator.shallowSizeOfInstance(TsFileRepairStatus.class) + RamUsageEstimator.shallowSizeOfInstance(TsFileID.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResource.class);
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    public static final String TEMP_SUFFIX = ".temp";
    public static final String BROKEN_SUFFIX = ".broken";
    public static final byte VERSION_NUMBER = 1;
    protected TsFileResource prev;
    protected TsFileResource next;
    private volatile ITimeIndex timeIndex;
    private final AtomicReference<Boolean> isEmpty = new AtomicReference();
    private volatile ModificationFile modFile;
    private volatile ModificationFile compactionModFile;
    protected AtomicReference<TsFileResourceStatus> atomicStatus = new AtomicReference<TsFileResourceStatus>(TsFileResourceStatus.UNCLOSED);
    private TsFileRepairStatus tsFileRepairStatus = TsFileRepairStatus.NORMAL;
    private final TsFileLock tsFileLock = new TsFileLock();
    private boolean isSeq;
    private final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private DataRegion.SettleTsFileCallBack settleTsFileCallBack;
    public long maxPlanIndex = Long.MIN_VALUE;
    public long minPlanIndex = Long.MAX_VALUE;
    private TsFileID tsFileID;
    private long deviceTimeIndexRamSize;
    private AtomicInteger tierLevel;
    private volatile long tsFileSize = -1L;
    private TsFileProcessor processor;
    private Map<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap = new HashMap<PartialPath, List<IChunkMetadata>>();
    private Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap = new HashMap<PartialPath, List<ReadOnlyMemChunk>>();
    private Map<PartialPath, ITimeSeriesMetadata> pathToTimeSeriesMetadataMap = new ConcurrentHashMap<PartialPath, ITimeSeriesMetadata>();
    private TsFileResource originTsFileResource;
    private final AtomicReference<ProgressIndex> maxProgressIndex = new AtomicReference();
    private volatile boolean isGeneratedByPipeConsensus = false;
    private volatile boolean isGeneratedByPipe = false;
    private InsertionCompactionCandidateStatus insertionCompactionCandidateStatus = InsertionCompactionCandidateStatus.NOT_CHECKED;
    private Map<IDeviceID, List<Pair<String, TimeValuePair>>> lastValues;

    public TsFileResource() {
        this.tsFileID = new TsFileID();
    }

    public TsFileResource(File file) {
        this.file = file;
        this.tsFileID = new TsFileID(file.getAbsolutePath());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.isSeq = FilePathUtils.isSequence((String)this.file.getAbsolutePath());
        this.tierLevel = new AtomicInteger(TierManager.getInstance().getFileTierLevel(file));
    }

    public TsFileResource(File file, TsFileResourceStatus status) {
        this(file);
        this.setAtomicStatus(status);
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.tsFileID = new TsFileID(file.getAbsolutePath());
        this.timeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        this.processor = processor;
        this.isSeq = processor.isSequence();
        this.tierLevel = new AtomicInteger(0);
    }

    public TsFileResource(Map<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap, Map<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap, TsFileResource originTsFileResource) throws IOException {
        this.file = originTsFileResource.file;
        this.timeIndex = originTsFileResource.timeIndex;
        this.pathToReadOnlyMemChunkMap = pathToReadOnlyMemChunkMap;
        this.pathToChunkMetadataListMap = pathToChunkMetadataListMap;
        this.originTsFileResource = originTsFileResource;
        this.tsFileID = originTsFileResource.tsFileID;
        this.isSeq = originTsFileResource.isSeq;
        this.tierLevel = originTsFileResource.tierLevel;
    }

    public synchronized void serialize() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
        try {
            this.serializeTo(outputStream);
        }
        finally {
            outputStream.flush();
            fileOutputStream.getFD().sync();
            outputStream.close();
        }
        File src = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX + TEMP_SUFFIX);
        File dest = this.fsFactory.getFile(this.file + RESOURCE_SUFFIX);
        this.fsFactory.deleteIfExists(dest);
        this.fsFactory.moveFile(src, dest);
    }

    private void serializeTo(BufferedOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        this.timeIndex.serialize(outputStream);
        ReadWriteIOUtils.write((long)this.maxPlanIndex, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.minPlanIndex, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)null, (OutputStream)outputStream);
        if (this.maxProgressIndex.get() != null) {
            TsFileResourceBlockType.PROGRESS_INDEX.serialize(outputStream);
            this.maxProgressIndex.get().serialize((OutputStream)outputStream);
        } else {
            TsFileResourceBlockType.EMPTY_BLOCK.serialize(outputStream);
        }
        TsFileResourceBlockType.PIPE_MARK.serialize(outputStream);
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipeConsensus, (OutputStream)outputStream);
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipe, (OutputStream)outputStream);
    }

    public void deserialize() throws IOException {
        try (BufferedInputStream inputStream = this.fsFactory.getBufferedInputStream(this.file + RESOURCE_SUFFIX);){
            ReadWriteIOUtils.readByte((InputStream)inputStream);
            this.timeIndex = ITimeIndex.createTimeIndex(inputStream);
            this.maxPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minPlanIndex = ReadWriteIOUtils.readLong((InputStream)inputStream);
            if (((InputStream)inputStream).available() > 0) {
                String string = ReadWriteIOUtils.readString((InputStream)inputStream);
            }
            while (((InputStream)inputStream).available() > 0) {
                TsFileResourceBlockType blockType = TsFileResourceBlockType.deserialize(ReadWriteIOUtils.readByte((InputStream)inputStream));
                switch (blockType) {
                    case PROGRESS_INDEX: {
                        this.maxProgressIndex.set(ProgressIndexType.deserializeFrom((InputStream)inputStream));
                        break;
                    }
                    case PIPE_MARK: {
                        this.isGeneratedByPipeConsensus = ReadWriteIOUtils.readBoolean((InputStream)inputStream);
                        this.isGeneratedByPipe = ReadWriteIOUtils.readBoolean((InputStream)inputStream);
                        break;
                    }
                }
            }
        }
    }

    public static int getFileTimeIndexSerializedSize() {
        return 48;
    }

    public void serializeFileTimeIndexToByteBuffer(ByteBuffer buffer) {
        buffer.putLong(this.tsFileID.timePartitionId);
        buffer.putLong(this.tsFileID.timestamp);
        buffer.putLong(this.tsFileID.fileVersion);
        buffer.putLong(this.tsFileID.compactionVersion);
        buffer.putLong(this.timeIndex.getMinStartTime());
        buffer.putLong(this.timeIndex.getMaxEndTime());
    }

    public void updateStartTime(IDeviceID device, long time) {
        this.timeIndex.updateStartTime(device, time);
    }

    public void updateEndTime(IDeviceID device, long time) {
        this.timeIndex.updateEndTime(device, time);
    }

    public boolean resourceFileExists() {
        return this.file != null && this.fsFactory.getFile(this.file + RESOURCE_SUFFIX).exists();
    }

    public boolean tsFileExists() {
        return this.file != null && this.file.exists();
    }

    public boolean modFileExists() {
        return this.getModFile().exists();
    }

    public boolean compactionModFileExists() {
        return this.getCompactionModFile().exists();
    }

    public List<IChunkMetadata> getChunkMetadataList(PartialPath seriesPath) {
        return new ArrayList<IChunkMetadata>((Collection)this.pathToChunkMetadataListMap.get(seriesPath));
    }

    public List<ReadOnlyMemChunk> getReadOnlyMemChunk(PartialPath seriesPath) {
        return this.pathToReadOnlyMemChunkMap.get(seriesPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getModFile() {
        if (this.modFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.modFile == null) {
                    this.modFile = ModificationFile.getNormalMods(this);
                }
            }
        }
        return this.modFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModificationFile getCompactionModFile() {
        if (this.compactionModFile == null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                if (this.compactionModFile == null) {
                    this.compactionModFile = ModificationFile.getCompactionMods(this);
                }
            }
        }
        return this.compactionModFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetModFile() throws IOException {
        if (this.modFile != null) {
            TsFileResource tsFileResource = this;
            synchronized (tsFileResource) {
                this.modFile.close();
                this.modFile = null;
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
        this.tsFileID = new TsFileID(file.getAbsolutePath());
    }

    public File getTsFile() {
        return this.file;
    }

    public String getTsFilePath() {
        return this.file.getPath();
    }

    public void increaseTierLevel() {
        this.tierLevel.addAndGet(1);
    }

    public int getTierLevel() {
        return this.tierLevel.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTsFileSize() {
        if (this.isClosed()) {
            if (this.tsFileSize == -1L) {
                TsFileResource tsFileResource = this;
                synchronized (tsFileResource) {
                    if (this.tsFileSize == -1L) {
                        this.tsFileSize = this.file.length();
                    }
                }
            }
            return this.tsFileSize;
        }
        return this.file.length();
    }

    public Optional<Long> getStartTime(IDeviceID deviceId) {
        try {
            return deviceId == null ? Optional.of(this.getFileStartTime()) : this.timeIndex.getStartTime(deviceId);
        }
        catch (Exception e) {
            LOGGER.error("meet error when getStartTime of {} in file {}", new Object[]{deviceId, this.file.getAbsolutePath(), e});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TimeIndex = {}", (Object)this.timeIndex);
            }
            throw e;
        }
    }

    public Optional<Long> getEndTime(IDeviceID deviceId) {
        try {
            return deviceId == null ? Optional.of(this.getFileEndTime()) : this.timeIndex.getEndTime(deviceId);
        }
        catch (Exception e) {
            LOGGER.error("meet error when getEndTime of {} in file {}", new Object[]{deviceId, this.file.getAbsolutePath(), e});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("TimeIndex = {}", (Object)this.timeIndex);
            }
            throw e;
        }
    }

    public long getOrderTimeForSeq(IDeviceID deviceId, boolean ascending) {
        if (this.timeIndex instanceof DeviceTimeIndex) {
            return ascending ? this.timeIndex.getStartTime(deviceId).orElse(Long.MIN_VALUE) : this.timeIndex.getEndTime(deviceId).orElse(Long.MAX_VALUE);
        }
        return ascending ? Long.MIN_VALUE : Long.MAX_VALUE;
    }

    public long getOrderTimeForUnseq(IDeviceID deviceId, boolean ascending) {
        if (this.timeIndex instanceof DeviceTimeIndex) {
            if (ascending) {
                return this.timeIndex.getStartTime(deviceId).orElse(Long.MIN_VALUE);
            }
            return this.timeIndex.getEndTime(deviceId).orElse(Long.MAX_VALUE);
        }
        return ascending ? this.getFileStartTime() : this.getFileEndTime();
    }

    public long getFileStartTime() {
        return this.timeIndex.getMinStartTime();
    }

    public long getFileEndTime() {
        return this.timeIndex.getMaxEndTime();
    }

    public Set<IDeviceID> getDevices() {
        return this.timeIndex.getDevices(this.file.getPath(), this);
    }

    public DeviceTimeIndex buildDeviceTimeIndex() throws IOException {
        this.readLock();
        try {
            DeviceTimeIndex deviceTimeIndex;
            block14: {
                if (!this.resourceFileExists()) {
                    throw new IOException("resource file not found");
                }
                BufferedInputStream inputStream = FSFactoryProducer.getFSFactory().getBufferedInputStream(this.file.getPath() + RESOURCE_SUFFIX);
                try {
                    ReadWriteIOUtils.readByte((InputStream)inputStream);
                    ITimeIndex timeIndexFromResourceFile = ITimeIndex.createTimeIndex(inputStream);
                    if (!(timeIndexFromResourceFile instanceof DeviceTimeIndex)) {
                        throw new IOException("cannot build DeviceTimeIndex from resource " + this.file.getPath());
                    }
                    deviceTimeIndex = (DeviceTimeIndex)timeIndexFromResourceFile;
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IOException("Can't read file " + this.file.getPath() + RESOURCE_SUFFIX + " from disk", e);
                    }
                }
                ((InputStream)inputStream).close();
            }
            return deviceTimeIndex;
        }
        finally {
            this.readUnlock();
        }
    }

    public ITimeIndex getTimeIndex() {
        return this.timeIndex;
    }

    public boolean definitelyNotContains(IDeviceID device) {
        return this.timeIndex.definitelyNotContains(device);
    }

    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath devicePattern, Set<IDeviceID> deviceMatchInfo) {
        return this.timeIndex.getPossibleStartTimeAndEndTime(devicePattern, deviceMatchInfo);
    }

    public boolean isClosed() {
        return this.getStatus() != TsFileResourceStatus.UNCLOSED;
    }

    public void close() throws IOException {
        this.setStatus(TsFileResourceStatus.NORMAL);
        this.closeWithoutSettingStatus();
    }

    public void closeWithoutSettingStatus() throws IOException {
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        if (this.compactionModFile != null) {
            this.compactionModFile.close();
            this.compactionModFile = null;
        }
        this.processor = null;
        this.pathToChunkMetadataListMap = null;
        this.pathToReadOnlyMemChunkMap = null;
        this.pathToTimeSeriesMetadataMap = null;
        this.timeIndex.close();
    }

    public TsFileProcessor getProcessor() {
        return this.processor;
    }

    public boolean isGeneratedByPipeConsensus() {
        return this.isGeneratedByPipeConsensus;
    }

    public void setGeneratedByPipeConsensus(boolean generatedByPipeConsensus) {
        this.isGeneratedByPipeConsensus = generatedByPipeConsensus;
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public void setGeneratedByPipe(boolean generatedByPipe) {
        this.isGeneratedByPipe = generatedByPipe;
    }

    public void writeLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeLock();
        } else {
            this.originTsFileResource.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.writeUnlock();
        } else {
            this.originTsFileResource.writeUnlock();
        }
    }

    public void readLock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readLock();
        } else {
            this.originTsFileResource.readLock();
        }
    }

    public void readUnlock() {
        if (this.originTsFileResource == null) {
            this.tsFileLock.readUnlock();
        } else {
            this.originTsFileResource.readUnlock();
        }
    }

    public boolean tryWriteLock() {
        return this.tsFileLock.tryWriteLock();
    }

    public boolean tryReadLock() {
        return this.tsFileLock.tryReadLock();
    }

    public void removeModFile() throws IOException {
        this.getModFile().remove();
        this.modFile = null;
    }

    public boolean remove() {
        this.forceMarkDeleted();
        this.isEmpty();
        this.degradeTimeIndex();
        try {
            this.fsFactory.deleteIfExists(this.file);
            this.fsFactory.deleteIfExists(new File(this.file.getAbsolutePath() + ".meta"));
        }
        catch (IOException e) {
            LOGGER.error("TsFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        if (!this.removeResourceFile()) {
            return false;
        }
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + ".mods"));
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + ".compaction.mods"));
        }
        catch (IOException e) {
            LOGGER.error("ModificationFile {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean removeResourceFile() {
        try {
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX));
            this.fsFactory.deleteIfExists(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX + TEMP_SUFFIX));
        }
        catch (IOException e) {
            LOGGER.error("TsFileResource {} cannot be deleted: {}", (Object)this.file, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public void moveTo(File targetDir) throws IOException {
        this.fsFactory.moveFile(this.file, this.fsFactory.getFile(targetDir, this.file.getName()));
        this.fsFactory.moveFile(this.fsFactory.getFile(this.file.getPath() + RESOURCE_SUFFIX), this.fsFactory.getFile(targetDir, this.file.getName() + RESOURCE_SUFFIX));
        File originModFile = this.fsFactory.getFile(this.file.getPath() + ".mods");
        if (originModFile.exists()) {
            this.fsFactory.moveFile(originModFile, this.fsFactory.getFile(targetDir, this.file.getName() + ".mods"));
        }
    }

    public String toString() {
        return String.format("{file: %s, status: %s}", new Object[]{this.file.toString(), this.getStatus()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileResource that = (TsFileResource)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    public boolean isDeleted() {
        return this.getStatus() == TsFileResourceStatus.DELETED;
    }

    public boolean isCompacting() {
        return this.getStatus() == TsFileResourceStatus.COMPACTING;
    }

    public boolean isCompactionCandidate() {
        return this.getStatus() == TsFileResourceStatus.COMPACTION_CANDIDATE;
    }

    public boolean onRemote() {
        return !this.isDeleted() && !this.file.exists();
    }

    private boolean compareAndSetStatus(TsFileResourceStatus expectedValue, TsFileResourceStatus newValue) {
        return this.atomicStatus.compareAndSet(expectedValue, newValue);
    }

    private void setAtomicStatus(TsFileResourceStatus status) {
        this.atomicStatus.set(status);
    }

    public void setStatusForTest(TsFileResourceStatus status) {
        this.setAtomicStatus(status);
    }

    public boolean setStatus(TsFileResourceStatus status) {
        if (status == this.getStatus()) {
            return true;
        }
        return this.transformStatus(status);
    }

    public boolean transformStatus(TsFileResourceStatus status) {
        switch (status) {
            case NORMAL: {
                return this.compareAndSetStatus(TsFileResourceStatus.UNCLOSED, TsFileResourceStatus.NORMAL) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTING, TsFileResourceStatus.NORMAL) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.NORMAL);
            }
            case UNCLOSED: {
                return false;
            }
            case DELETED: {
                return this.compareAndSetStatus(TsFileResourceStatus.NORMAL, TsFileResourceStatus.DELETED) || this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.DELETED);
            }
            case COMPACTING: {
                return this.compareAndSetStatus(TsFileResourceStatus.COMPACTION_CANDIDATE, TsFileResourceStatus.COMPACTING);
            }
            case COMPACTION_CANDIDATE: {
                return this.compareAndSetStatus(TsFileResourceStatus.NORMAL, TsFileResourceStatus.COMPACTION_CANDIDATE);
            }
        }
        return false;
    }

    public TsFileRepairStatus getTsFileRepairStatus() {
        return this.tsFileRepairStatus;
    }

    public void setTsFileRepairStatus(TsFileRepairStatus fileRepairStatus) {
        this.tsFileRepairStatus = fileRepairStatus;
    }

    public void forceMarkDeleted() {
        this.atomicStatus.set(TsFileResourceStatus.DELETED);
    }

    public TsFileResourceStatus getStatus() {
        return this.atomicStatus.get();
    }

    public boolean stillLives(long timeLowerBound) {
        return !this.isClosed() || this.timeIndex.stillLives(timeLowerBound);
    }

    public boolean isDeviceIdExist(IDeviceID deviceId) {
        return this.timeIndex.checkDeviceIdExist(deviceId);
    }

    public boolean isSatisfied(IDeviceID deviceId, Filter timeFilter, boolean isSeq, boolean debug) {
        if (deviceId != null && this.definitelyNotContains(deviceId)) {
            if (debug) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of no device!", (Object)deviceId, (Object)this.file);
            }
            return false;
        }
        if (timeFilter != null) {
            long endTime;
            long startTime = this.getStartTime(deviceId).get();
            long l = endTime = this.isClosed() || !isSeq ? this.getEndTime(deviceId).get() : Long.MAX_VALUE;
            if (startTime > endTime) {
                LOGGER.warn("startTime[{}] of TsFileResource[{}] is greater than its endTime[{}]", new Object[]{startTime, this, endTime});
                return false;
            }
            boolean res = timeFilter.satisfyStartEndTime(startTime, endTime);
            if (debug && !res) {
                DEBUG_LOGGER.info("Path: {} file {} is not satisfied because of time filter!", deviceId != null ? deviceId : "", (Object)this.fsFactory);
            }
            return res;
        }
        return true;
    }

    private boolean isAlive(long time, long dataTTL) {
        return dataTTL == Long.MAX_VALUE || CommonDateTimeUtils.currentTime() - time <= dataTTL;
    }

    public boolean isDeviceAlive(IDeviceID device, long ttl) {
        if (this.definitelyNotContains(device)) {
            return false;
        }
        return !this.isClosed() || this.timeIndex.isDeviceAlive(device, ttl);
    }

    public void setProcessor(TsFileProcessor processor) {
        this.processor = processor;
    }

    public ITimeSeriesMetadata getTimeSeriesMetadata(PartialPath seriesPath, Filter globalTimeFilter) throws IOException {
        try {
            return this.pathToTimeSeriesMetadataMap.computeIfAbsent(seriesPath, k -> {
                if (this.pathToChunkMetadataListMap.containsKey(k)) {
                    try {
                        return ResourceByPathUtils.getResourceInstance(seriesPath).generateTimeSeriesMetadata(this.pathToReadOnlyMemChunkMap.get(seriesPath), this.pathToChunkMetadataListMap.get(seriesPath), globalTimeFilter);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return null;
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public DataRegion.SettleTsFileCallBack getSettleTsFileCallBack() {
        return this.settleTsFileCallBack;
    }

    public void setSettleTsFileCallBack(DataRegion.SettleTsFileCallBack settleTsFileCallBack) {
        this.settleTsFileCallBack = settleTsFileCallBack;
    }

    public long getTimePartition() {
        return this.tsFileID.timePartitionId;
    }

    public long getTimePartitionWithCheck() throws PartitionViolationException {
        return this.timeIndex.getTimePartitionWithCheck(this.file.toString());
    }

    public boolean isSpanMultiTimePartitions() {
        return this.timeIndex.isSpanMultiTimePartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModFile(ModificationFile modFile) {
        TsFileResource tsFileResource = this;
        synchronized (tsFileResource) {
            this.modFile = modFile;
        }
    }

    public long calculateRamSize() {
        ProgressIndex progressIndex = this.maxProgressIndex.get();
        if (this.timeIndex.getTimeIndexType() == 2) {
            return INSTANCE_SIZE + this.timeIndex.calculateRamSize() + (Objects.nonNull(progressIndex) ? progressIndex.ramBytesUsed() : 0L);
        }
        if (this.deviceTimeIndexRamSize == 0L) {
            this.deviceTimeIndexRamSize = this.timeIndex.calculateRamSize();
        }
        return INSTANCE_SIZE + this.deviceTimeIndexRamSize + (Objects.nonNull(progressIndex) ? progressIndex.ramBytesUsed() : 0L);
    }

    public Optional<Long> getDeviceTimeIndexRamSize() {
        if (!this.isClosed()) {
            return Optional.empty();
        }
        return Optional.of(this.deviceTimeIndexRamSize);
    }

    public long getMaxPlanIndex() {
        return this.maxPlanIndex;
    }

    public long getMinPlanIndex() {
        return this.minPlanIndex;
    }

    public void updatePlanIndexes(long planIndex) {
        if (planIndex == Long.MIN_VALUE || planIndex == Long.MAX_VALUE) {
            return;
        }
        if (planIndex < this.minPlanIndex || planIndex > this.maxPlanIndex) {
            this.maxPlanIndex = Math.max(this.maxPlanIndex, planIndex);
            this.minPlanIndex = Math.min(this.minPlanIndex, planIndex);
            if (this.isClosed()) {
                try {
                    this.serialize();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot serialize TsFileResource {} when updating plan index {}-{}", new Object[]{this, this.maxPlanIndex, planIndex});
                }
            }
        }
    }

    public static int getInnerCompactionCount(String fileName) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(fileName);
        return tsFileName.getInnerCompactionCnt();
    }

    public void updatePlanIndexes(TsFileResource another) {
        this.maxPlanIndex = Math.max(this.maxPlanIndex, another.maxPlanIndex);
        this.minPlanIndex = Math.min(this.minPlanIndex, another.minPlanIndex);
    }

    public boolean isPlanIndexOverlap(TsFileResource another) {
        return another.maxPlanIndex > this.minPlanIndex && another.minPlanIndex < this.maxPlanIndex;
    }

    public boolean isPlanRangeCovers(TsFileResource another) {
        return this.minPlanIndex < another.minPlanIndex && another.maxPlanIndex < this.maxPlanIndex;
    }

    public void setMaxPlanIndex(long maxPlanIndex) {
        this.maxPlanIndex = maxPlanIndex;
    }

    public void setMinPlanIndex(long minPlanIndex) {
        this.minPlanIndex = minPlanIndex;
    }

    public void setVersion(long version) {
        this.tsFileID = new TsFileID(this.tsFileID.regionId, this.tsFileID.timePartitionId, this.tsFileID.timestamp, version, this.tsFileID.compactionVersion);
    }

    public long getVersion() {
        return this.tsFileID.fileVersion;
    }

    public TsFileID getTsFileID() {
        return this.tsFileID;
    }

    public void setTimeIndex(ITimeIndex timeIndex) {
        this.timeIndex = timeIndex;
    }

    public static int compareFileName(TsFileResource o1, TsFileResource o2) {
        long ver2;
        String[] items1 = o1.getTsFile().getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getTsFile().getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            int cmpVersion = Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
            if (cmpVersion == 0) {
                int cmpInnerCompact = Long.compare(Long.parseLong(items1[2]), Long.parseLong(items2[2]));
                if (cmpInnerCompact == 0) {
                    return Long.compare(Long.parseLong(items1[3]), Long.parseLong(items2[3]));
                }
                return cmpInnerCompact;
            }
            return cmpVersion;
        }
        return cmp;
    }

    public static int checkAndCompareFileName(String fileName1, String fileName2) throws IOException {
        TsFileNameGenerator.TsFileName tsFileName1 = TsFileNameGenerator.getTsFileName(fileName1);
        TsFileNameGenerator.TsFileName tsFileName2 = TsFileNameGenerator.getTsFileName(fileName2);
        long timeDiff = tsFileName1.getTime() - tsFileName2.getTime();
        if (timeDiff != 0L) {
            return timeDiff < 0L ? -1 : 1;
        }
        long versionDiff = tsFileName1.getVersion() - tsFileName2.getVersion();
        if (versionDiff != 0L) {
            return versionDiff < 0L ? -1 : 1;
        }
        return 0;
    }

    public static int compareFileCreationOrderByDesc(TsFileResource o1, TsFileResource o2) {
        try {
            TsFileNameGenerator.TsFileName n1 = TsFileNameGenerator.getTsFileName(o1.getTsFile().getName());
            TsFileNameGenerator.TsFileName n2 = TsFileNameGenerator.getTsFileName(o2.getTsFile().getName());
            long versionDiff = n2.getVersion() - n1.getVersion();
            if (versionDiff != 0L) {
                return versionDiff < 0L ? -1 : 1;
            }
            return 0;
        }
        catch (IOException e) {
            LOGGER.error("File name may not meet the standard naming specifications.", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSeq(boolean seq) {
        this.isSeq = seq;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public int compareIndexDegradePriority(TsFileResource tsFileResource) {
        int cmp = this.timeIndex.compareDegradePriority(tsFileResource.timeIndex);
        return cmp == 0 ? this.file.getAbsolutePath().compareTo(tsFileResource.file.getAbsolutePath()) : cmp;
    }

    public byte getTimeIndexType() {
        return this.timeIndex.getTimeIndexType();
    }

    public void setTimeIndexType(byte type) {
        switch (type) {
            case 1: {
                this.timeIndex = new DeviceTimeIndex();
                break;
            }
            case 2: {
                this.timeIndex = new FileTimeIndex();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public long degradeTimeIndex() {
        TimeIndexLevel timeIndexLevel = TimeIndexLevel.valueOf(this.getTimeIndexType());
        if (timeIndexLevel == TimeIndexLevel.FILE_TIME_INDEX) {
            return 0L;
        }
        long startTime = this.timeIndex.getMinStartTime();
        long endTime = this.timeIndex.getMaxEndTime();
        this.timeIndex = new FileTimeIndex(startTime, endTime);
        return this.deviceTimeIndexRamSize - this.timeIndex.calculateRamSize();
    }

    public void deleteRemovedDeviceAndUpdateEndTime(Map<IDeviceID, Long> lastTimeForEachDevice) {
        ITimeIndex newTimeIndex = CONFIG.getTimeIndexLevel().getTimeIndex();
        for (Map.Entry<IDeviceID, Long> entry : lastTimeForEachDevice.entrySet()) {
            this.timeIndex.getStartTime(entry.getKey()).ifPresent(startTime -> {
                newTimeIndex.updateStartTime((IDeviceID)entry.getKey(), (long)startTime);
                newTimeIndex.updateEndTime((IDeviceID)entry.getKey(), (Long)entry.getValue());
            });
        }
        this.timeIndex = newTimeIndex;
    }

    public void updateEndTime(Map<IDeviceID, Long> lastTimeForEachDevice) {
        for (Map.Entry<IDeviceID, Long> entry : lastTimeForEachDevice.entrySet()) {
            this.timeIndex.updateEndTime(entry.getKey(), entry.getValue());
        }
    }

    public boolean isFileInList() {
        return this.prev != null || this.next != null;
    }

    public void updateProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        if (!this.maxProgressIndex.compareAndSet(null, progressIndex)) {
            this.maxProgressIndex.updateAndGet(index -> index.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex));
        }
    }

    public void setProgressIndex(ProgressIndex progressIndex) {
        if (progressIndex == null) {
            return;
        }
        this.maxProgressIndex.set(progressIndex);
    }

    public ProgressIndex getMaxProgressIndex() {
        ProgressIndex index = this.maxProgressIndex.get();
        return index == null ? MinimumProgressIndex.INSTANCE : index;
    }

    public boolean isEmpty() {
        this.isEmpty.compareAndSet(null, this.getFileStartTime() == Long.MAX_VALUE && this.getFileEndTime() == Long.MIN_VALUE);
        return this.isEmpty.get();
    }

    public String getDatabaseName() {
        return this.file.getParentFile().getParentFile().getParentFile().getName();
    }

    public String getDataRegionId() {
        return this.file.getParentFile().getParentFile().getName();
    }

    public boolean isInsertionCompactionTaskCandidate() {
        return !this.isSeq && this.insertionCompactionCandidateStatus != InsertionCompactionCandidateStatus.NOT_VALID;
    }

    public InsertionCompactionCandidateStatus getInsertionCompactionCandidateStatus() {
        return this.insertionCompactionCandidateStatus;
    }

    public void setInsertionCompactionTaskCandidate(InsertionCompactionCandidateStatus status) {
        this.insertionCompactionCandidateStatus = status;
    }

    public Map<IDeviceID, List<Pair<String, TimeValuePair>>> getLastValues() {
        return this.lastValues;
    }

    public void setLastValues(Map<IDeviceID, List<Pair<String, TimeValuePair>>> lastValues) {
        this.lastValues = lastValues;
    }

    public TsFileResource shallowClone() {
        TsFileResource cloned = new TsFileResource();
        cloned.file = this.file;
        cloned.timeIndex = this.timeIndex;
        cloned.maxPlanIndex = this.maxPlanIndex;
        cloned.minPlanIndex = this.minPlanIndex;
        cloned.compactionModFile = this.compactionModFile;
        cloned.isSeq = this.isSeq;
        cloned.tsFileRepairStatus = this.tsFileRepairStatus;
        cloned.settleTsFileCallBack = this.settleTsFileCallBack;
        cloned.deviceTimeIndexRamSize = this.deviceTimeIndexRamSize;
        cloned.tsFileSize = this.tsFileSize;
        cloned.processor = this.processor;
        cloned.originTsFileResource = this.originTsFileResource;
        cloned.isGeneratedByPipeConsensus = this.isGeneratedByPipeConsensus;
        cloned.isGeneratedByPipe = this.isGeneratedByPipe;
        cloned.insertionCompactionCandidateStatus = this.insertionCompactionCandidateStatus;
        cloned.tierLevel = this.tierLevel;
        cloned.pathToChunkMetadataListMap = this.pathToChunkMetadataListMap;
        cloned.pathToReadOnlyMemChunkMap = this.pathToReadOnlyMemChunkMap;
        cloned.pathToTimeSeriesMetadataMap = this.pathToTimeSeriesMetadataMap;
        cloned.lastValues = this.lastValues;
        cloned.maxProgressIndex.set(this.maxProgressIndex.get());
        cloned.atomicStatus.set(this.atomicStatus.get());
        cloned.isEmpty.set(this.isEmpty.get());
        cloned.tsFileID = this.tsFileID;
        cloned.prev = null;
        cloned.next = null;
        return cloned;
    }

    public TsFileResource shallowCloneForNative() throws CloneNotSupportedException {
        return (TsFileResource)this.clone();
    }
}

