/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.BatchDataFactory;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.TsBlockUtil;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.page.LazyLoadAlignedPagePointReader;
import org.apache.tsfile.read.reader.page.LazyLoadPageData;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.utils.TsPrimitiveType;

public class AlignedPageReader
implements IPageReader {
    private final TimePageReader timePageReader;
    private final List<ValuePageReader> valuePageReaderList;
    private final int valueCount;
    private final Filter globalTimeFilter;
    private Filter pushDownFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private boolean isModified;
    private TsBlockBuilder builder;
    private static final int MASK = 128;

    public AlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, List<ByteBuffer> valuePageDataList, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        this.timePageReader = new TimePageReader(timePageHeader, timePageData, timeDecoder);
        this.isModified = this.timePageReader.isModified();
        this.valuePageReaderList = new ArrayList<ValuePageReader>(valuePageHeaderList.size());
        for (int i = 0; i < valuePageHeaderList.size(); ++i) {
            if (valuePageHeaderList.get(i) != null) {
                ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaderList.get(i), valuePageDataList.get(i), valueDataTypeList.get(i), valueDecoderList.get(i));
                this.valuePageReaderList.add(valuePageReader);
                this.isModified = this.isModified || valuePageReader.isModified();
                continue;
            }
            this.valuePageReaderList.add(null);
        }
        this.globalTimeFilter = globalTimeFilter;
        this.valueCount = this.valuePageReaderList.size();
    }

    public AlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, LazyLoadPageData[] lazyLoadPageDataArray, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        this.timePageReader = new TimePageReader(timePageHeader, timePageData, timeDecoder);
        this.isModified = this.timePageReader.isModified();
        this.valuePageReaderList = new ArrayList<ValuePageReader>(valuePageHeaderList.size());
        for (int i = 0; i < valuePageHeaderList.size(); ++i) {
            if (valuePageHeaderList.get(i) != null) {
                ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaderList.get(i), lazyLoadPageDataArray[i], valueDataTypeList.get(i), valueDecoderList.get(i));
                this.valuePageReaderList.add(valuePageReader);
                this.isModified = this.isModified || valuePageReader.isModified();
                continue;
            }
            this.valuePageReaderList.add(null);
        }
        this.globalTimeFilter = globalTimeFilter;
        this.valueCount = this.valuePageReaderList.size();
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData pageData = BatchDataFactory.createBatchData(TSDataType.VECTOR, ascending, false);
        int timeIndex = -1;
        Object[] rowValues = new Object[this.valueCount];
        while (this.timePageReader.hasNextTime()) {
            long timestamp = this.timePageReader.nextTime();
            ++timeIndex;
            TsPrimitiveType[] v = new TsPrimitiveType[this.valueCount];
            boolean hasNotNullValues = false;
            for (int i = 0; i < this.valueCount; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                if (pageReader != null) {
                    v[i] = pageReader.nextValue(timestamp, timeIndex);
                    rowValues[i] = v[i] == null ? null : v[i].getValue();
                } else {
                    v[i] = null;
                    rowValues[i] = null;
                }
                if (rowValues[i] == null) continue;
                hasNotNullValues = true;
            }
            if (!hasNotNullValues || !this.satisfyRecordFilter(timestamp, rowValues)) continue;
            pageData.putVector(timestamp, v);
        }
        return pageData.flip();
    }

    private boolean satisfyRecordFilter(long timestamp, Object[] rowValues) {
        return !(this.globalTimeFilter != null && !this.globalTimeFilter.satisfyRow(timestamp, rowValues) || this.pushDownFilter != null && !this.pushDownFilter.satisfyRow(timestamp, rowValues));
    }

    @Override
    public boolean timeAllSelected() {
        for (int index = 0; index < this.getMeasurementCount(); ++index) {
            if (this.hasNullValue(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMeasurementCount() {
        return this.valueCount;
    }

    public IPointReader getLazyPointReader() throws IOException {
        return new LazyLoadAlignedPagePointReader(this.timePageReader, this.valuePageReaderList);
    }

    private boolean allPageDataSatisfy() {
        return !this.isModified && this.timeAllSelected() && this.globalTimeFilterAllSatisfy() && this.pushDownFilterAllSatisfy();
    }

    private boolean globalTimeFilterAllSatisfy() {
        return this.globalTimeFilter == null || this.globalTimeFilter.allSatisfy(this);
    }

    private boolean pushDownFilterAllSatisfy() {
        return this.pushDownFilter == null || this.pushDownFilter.allSatisfy(this);
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        long[] timeBatch = this.timePageReader.getNextTimeBatch();
        if (this.allPageDataSatisfy()) {
            this.buildResultWithoutAnyFilterAndDelete(timeBatch);
            return this.builder.build();
        }
        boolean[] keepCurrentRow = new boolean[timeBatch.length];
        boolean globalTimeFilterAllSatisfy = this.globalTimeFilterAllSatisfy();
        if (globalTimeFilterAllSatisfy) {
            Arrays.fill(keepCurrentRow, true);
        } else {
            this.updateKeepCurrentRowThroughGlobalTimeFilter(keepCurrentRow, timeBatch);
        }
        boolean[][] isDeleted = null;
        if ((this.isModified || !this.timeAllSelected()) && this.valueCount != 0) {
            byte[] bitmask = new byte[(timeBatch.length - 1) / 8 + 1];
            Arrays.fill(bitmask, (byte)0);
            isDeleted = new boolean[this.valueCount][timeBatch.length];
            this.fillIsDeletedAndBitMask(timeBatch, isDeleted, bitmask);
            this.updateKeepCurrentRowThroughBitmask(keepCurrentRow, bitmask);
        }
        boolean pushDownFilterAllSatisfy = this.pushDownFilterAllSatisfy();
        int readEndIndex = this.buildTimeColumn(timeBatch, keepCurrentRow, pushDownFilterAllSatisfy);
        this.buildValueColumns(readEndIndex, keepCurrentRow, isDeleted);
        TsBlock unFilteredBlock = this.builder.build();
        if (pushDownFilterAllSatisfy) {
            return unFilteredBlock;
        }
        this.builder.reset();
        return TsBlockUtil.applyFilterAndLimitOffsetToTsBlock(unFilteredBlock, this.builder, this.pushDownFilter, this.paginationController);
    }

    private void buildResultWithoutAnyFilterAndDelete(long[] timeBatch) throws IOException {
        if (this.paginationController.hasCurOffset(timeBatch.length)) {
            this.paginationController.consumeOffset(timeBatch.length);
        } else {
            int i;
            int readStartIndex = 0;
            if (this.paginationController.hasCurOffset()) {
                readStartIndex = (int)this.paginationController.getCurOffset();
                this.paginationController.consumeOffset(readStartIndex);
            }
            int readEndIndex = timeBatch.length;
            if (this.paginationController.hasCurLimit() && this.paginationController.getCurLimit() > 0L) {
                readEndIndex = Math.min(readEndIndex, readStartIndex + (int)this.paginationController.getCurLimit());
                this.paginationController.consumeLimit((long)readEndIndex - (long)readStartIndex);
            }
            for (i = readStartIndex; i < readEndIndex; ++i) {
                this.builder.getTimeColumnBuilder().writeLong(timeBatch[i]);
                this.builder.declarePosition();
            }
            for (i = 0; i < this.valueCount; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                if (pageReader != null) {
                    pageReader.writeColumnBuilderWithNextBatch(readStartIndex, readEndIndex, this.builder.getColumnBuilder(i));
                    continue;
                }
                this.builder.getColumnBuilder(i).appendNull(readEndIndex - readStartIndex);
            }
        }
    }

    private int buildTimeColumn(long[] timeBatch, boolean[] keepCurrentRow, boolean pushDownFilterAllSatisfy) {
        if (pushDownFilterAllSatisfy) {
            return this.buildTimeColumnWithPagination(timeBatch, keepCurrentRow);
        }
        return this.buildTimeColumnWithoutPagination(timeBatch, keepCurrentRow);
    }

    private int buildTimeColumnWithPagination(long[] timeBatch, boolean[] keepCurrentRow) {
        int readEndIndex = timeBatch.length;
        for (int rowIndex = 0; rowIndex < timeBatch.length; ++rowIndex) {
            if (!keepCurrentRow[rowIndex]) continue;
            if (this.paginationController.hasCurOffset()) {
                this.paginationController.consumeOffset();
                keepCurrentRow[rowIndex] = false;
                continue;
            }
            if (this.paginationController.hasCurLimit()) {
                this.builder.getTimeColumnBuilder().writeLong(timeBatch[rowIndex]);
                this.builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = rowIndex;
            break;
        }
        return readEndIndex;
    }

    private int buildTimeColumnWithoutPagination(long[] timeBatch, boolean[] keepCurrentRow) {
        int readEndIndex = 0;
        for (int i = 0; i < timeBatch.length; ++i) {
            if (!keepCurrentRow[i]) continue;
            this.builder.getTimeColumnBuilder().writeLong(timeBatch[i]);
            this.builder.declarePosition();
            readEndIndex = i;
        }
        return readEndIndex + 1;
    }

    private void buildValueColumns(int readEndIndex, boolean[] keepCurrentRow, boolean[][] isDeleted) throws IOException {
        for (int i = 0; i < this.valueCount; ++i) {
            ValuePageReader pageReader = this.valuePageReaderList.get(i);
            if (pageReader != null) {
                if (pageReader.isModified()) {
                    pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow, Objects.requireNonNull(isDeleted)[i]);
                    continue;
                }
                pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow);
                continue;
            }
            for (int j = 0; j < readEndIndex; ++j) {
                if (!keepCurrentRow[j]) continue;
                this.builder.getColumnBuilder(i).appendNull();
            }
        }
    }

    private void fillIsDeletedAndBitMask(long[] timeBatch, boolean[][] isDeleted, byte[] bitmask) throws IOException {
        for (int columnIndex = 0; columnIndex < this.valueCount; ++columnIndex) {
            ValuePageReader pageReader = this.valuePageReaderList.get(columnIndex);
            if (pageReader == null) continue;
            byte[] bitmap = pageReader.getBitmap();
            if (pageReader.isModified()) {
                pageReader.fillIsDeleted(timeBatch, isDeleted[columnIndex]);
                this.updateBitmapThroughIsDeleted(bitmap, isDeleted[columnIndex]);
            }
            int n = bitmask.length;
            for (int i = 0; i < n; ++i) {
                bitmask[i] = (byte)(bitmap[i] | bitmask[i]);
            }
        }
    }

    private void updateBitmapThroughIsDeleted(byte[] bitmap, boolean[] isDeleted) {
        int n = isDeleted.length;
        for (int i = 0; i < n; ++i) {
            if (!isDeleted[i]) continue;
            int shift = i % 8;
            bitmap[i / 8] = (byte)(bitmap[i / 8] & ~(128 >>> shift));
        }
    }

    private void updateKeepCurrentRowThroughGlobalTimeFilter(boolean[] keepCurrentRow, long[] timeBatch) {
        int n = timeBatch.length;
        for (int i = 0; i < n; ++i) {
            keepCurrentRow[i] = this.globalTimeFilter.satisfy(timeBatch[i], null);
        }
    }

    private void updateKeepCurrentRowThroughBitmask(boolean[] keepCurrentRow, byte[] bitmask) {
        int n = bitmask.length;
        for (int i = 0; i < n; ++i) {
            if (bitmask[i] == -1) continue;
            if (bitmask[i] == 0) {
                Arrays.fill(keepCurrentRow, i * 8, Math.min(i * 8 + 8, keepCurrentRow.length), false);
                continue;
            }
            for (int j = 0; j < 8 && i * 8 + j < keepCurrentRow.length; ++j) {
                if ((bitmask[i] & 0xFF & 128 >>> j) != 0) continue;
                keepCurrentRow[i * 8 + j] = false;
            }
        }
    }

    public void setDeleteIntervalList(List<List<TimeRange>> list) {
        for (int i = 0; i < this.valueCount; ++i) {
            if (this.valuePageReaderList.get(i) == null) continue;
            this.valuePageReaderList.get(i).setDeleteIntervalList(list.get(i));
        }
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.valuePageReaderList.size() == 1 && this.valuePageReaderList.get(0) != null ? this.valuePageReaderList.get(0).getStatistics() : this.timePageReader.getStatistics();
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.timePageReader.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        ValuePageReader valuePageReader = this.valuePageReaderList.get(measurementIndex);
        return Optional.ofNullable(valuePageReader == null ? null : valuePageReader.getStatistics());
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        long rowCount = this.getTimeStatistics().getCount();
        Optional<Statistics<? extends Serializable>> statistics = this.getMeasurementStatistics(measurementIndex);
        return statistics.map(stat -> stat.hasNullValue(rowCount)).orElse(true);
    }

    @Override
    public void addRecordFilter(Filter filter) {
        this.pushDownFilter = filter;
    }

    @Override
    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = this.paginationController.hasSetLimit() ? new TsBlockBuilder((int)Math.min(this.paginationController.getCurLimit(), this.timePageReader.getStatistics().getCount()), dataTypes) : new TsBlockBuilder((int)this.timePageReader.getStatistics().getCount(), dataTypes);
    }

    public TimePageReader getTimePageReader() {
        return this.timePageReader;
    }

    public List<ValuePageReader> getValuePageReaderList() {
        return this.valuePageReaderList;
    }
}

