/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.util.function.Consumer;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.grpc.client.GrpcClientRpc;
import org.apache.ratis.grpc.server.GrpcLogAppender;
import org.apache.ratis.grpc.server.GrpcService;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.ServerFactory;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcFactory
implements ServerFactory,
ClientFactory {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcFactory.class);
    static final String USE_CACHE_FOR_ALL_THREADS_NAME = "useCacheForAllThreads";
    static final String USE_CACHE_FOR_ALL_THREADS_KEY = "org.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads";
    private final GrpcTlsConfig tlsConfig;
    private final GrpcTlsConfig adminTlsConfig;
    private final GrpcTlsConfig clientTlsConfig;
    private final GrpcTlsConfig serverTlsConfig;

    static boolean checkPooledByteBufAllocatorUseCacheForAllThreads(Consumer<String> log) {
        boolean value = PooledByteBufAllocator.defaultUseCacheForAllThreads();
        if (value) {
            log.accept("PERFORMANCE WARNING: useCacheForAllThreads is true that may cause Netty to create a lot garbage objects and, as a result, trigger GC.\n\tIt is recommended to disable useCacheForAllThreads by setting -Dorg.apache.ratis.thirdparty.io.netty.allocator.useCacheForAllThreads=false in command line.");
        }
        return value;
    }

    public static Parameters newRaftParameters(GrpcTlsConfig conf) {
        Parameters p = new Parameters();
        GrpcConfigKeys.TLS.setConf(p, conf);
        return p;
    }

    public GrpcFactory(Parameters parameters) {
        this(GrpcConfigKeys.TLS.conf(parameters), GrpcConfigKeys.Admin.tlsConf(parameters), GrpcConfigKeys.Client.tlsConf(parameters), GrpcConfigKeys.Server.tlsConf(parameters));
    }

    public GrpcFactory(GrpcTlsConfig tlsConfig) {
        this(tlsConfig, null, null, null);
    }

    private GrpcFactory(GrpcTlsConfig tlsConfig, GrpcTlsConfig adminTlsConfig, GrpcTlsConfig clientTlsConfig, GrpcTlsConfig serverTlsConfig) {
        this.tlsConfig = tlsConfig;
        this.adminTlsConfig = adminTlsConfig;
        this.clientTlsConfig = clientTlsConfig;
        this.serverTlsConfig = serverTlsConfig;
    }

    public GrpcTlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public GrpcTlsConfig getAdminTlsConfig() {
        return this.adminTlsConfig != null ? this.adminTlsConfig : this.tlsConfig;
    }

    public GrpcTlsConfig getClientTlsConfig() {
        return this.clientTlsConfig != null ? this.clientTlsConfig : this.tlsConfig;
    }

    public GrpcTlsConfig getServerTlsConfig() {
        return this.serverTlsConfig != null ? this.serverTlsConfig : this.tlsConfig;
    }

    public SupportedRpcType getRpcType() {
        return SupportedRpcType.GRPC;
    }

    public LogAppender newLogAppender(RaftServer.Division server, LeaderState state, FollowerInfo f) {
        return new GrpcLogAppender(server, state, f);
    }

    public GrpcService newRaftServerRpc(RaftServer server) {
        GrpcFactory.checkPooledByteBufAllocatorUseCacheForAllThreads(arg_0 -> ((Logger)LOG).info(arg_0));
        return GrpcService.newBuilder().setServer(server).setAdminTlsConfig(this.getAdminTlsConfig()).setServerTlsConfig(this.getServerTlsConfig()).setClientTlsConfig(this.getClientTlsConfig()).build();
    }

    public GrpcClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
        GrpcFactory.checkPooledByteBufAllocatorUseCacheForAllThreads(arg_0 -> ((Logger)LOG).debug(arg_0));
        return new GrpcClientRpc(clientId, properties, this.getAdminTlsConfig(), this.getClientTlsConfig());
    }

    static {
        String value = JavaUtils.getSystemProperty((String)USE_CACHE_FOR_ALL_THREADS_KEY);
        if (value == null) {
            JavaUtils.setSystemProperty((String)USE_CACHE_FOR_ALL_THREADS_KEY, (String)Boolean.FALSE.toString());
        }
    }
}

