/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.sql.help;

import java.util.Arrays;
import java.util.Optional;

public enum IgniteSqlCommand {
    SELECT("SELECT", "SELECT [ hintComment ] [ STREAM ] [ ALL | DISTINCT ]\n    { * | projectItem [, projectItem ]* }\nFROM tableExpression\n[ WHERE booleanExpression ]\n[ GROUP BY { groupItem [, groupItem ]* } ]\n[ HAVING booleanExpression ]"),
    select("select", IgniteSqlCommand.SELECT.syntax),
    INSERT("INSERT", "INSERT INTO tableName\n[ '(' column [, column ]* ')' ]"),
    insert("insert", IgniteSqlCommand.INSERT.syntax),
    UPDATE("UPDATE", "UPDATE tableName\nSET assign [, assign ]*\n[ WHERE booleanExpression ]"),
    update("update", IgniteSqlCommand.UPDATE.syntax),
    DELETE("DELETE", "DELETE FROM tableName [ [ AS ] alias ]\n[ WHERE booleanExpression ]"),
    delete("delete", IgniteSqlCommand.DELETE.syntax),
    CREATE_TABLE("CREATE TABLE", "CREATE TABLE [IF NOT EXISTS] tableName (tableColumn [, tableColumn]...)\n[COLOCATE [BY] (columnName [, columnName]...)]\n[ZONE zoneName]\n[STORAGE PROFILE storageProfile]\ntableColumn = columnName columnType [[NOT] NULL] [DEFAULT defaultValue] [PRIMARY KEY]"),
    create_table("create table", IgniteSqlCommand.CREATE_TABLE.syntax),
    DROP_TABLE("DROP TABLE", "DROP TABLE IF EXISTS tableName"),
    drop_table("drop table", IgniteSqlCommand.DROP_TABLE.syntax),
    ALTER_TABLE("ALTER TABLE", "ALTER TABLE tableName ADD COLUMN (tableColumn [, tableColumn]...) \n\nALTER TABLE tableName DROP COLUMN (tableColumn [, tableColumn]...)"),
    alter_table("alter table", IgniteSqlCommand.ALTER_TABLE.syntax),
    CREATE_INDEX("CREATE INDEX", "CREATE INDEX [IF NOT EXISTS] name ON tableName\n[USING { HASH | SORTED }]\n(column_definition [, column_definition]...)"),
    create_index("create index", IgniteSqlCommand.CREATE_INDEX.syntax),
    DROP_INDEX("DROP INDEX", "DROP INDEX [IF EXISTS] indexName"),
    drop_index("drop index", IgniteSqlCommand.DROP_INDEX.syntax);

    private final String topic;
    private final String syntax;

    private IgniteSqlCommand(String topic, String syntax) {
        this.topic = topic;
        this.syntax = syntax;
    }

    static Optional<IgniteSqlCommand> find(String topic) {
        return Arrays.stream(IgniteSqlCommand.values()).filter(it -> it.getTopic().equalsIgnoreCase(topic)).findFirst();
    }

    String getTopic() {
        return this.topic;
    }

    String getSyntax() {
        return this.syntax;
    }
}

