/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewColumnsEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class NewColumnsEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class NewColumnsEntrySerializerV2
    implements CatalogObjectSerializer<NewColumnsEntry> {
        NewColumnsEntrySerializerV2() {
        }

        @Override
        public NewColumnsEntry readFrom(CatalogObjectDataInput in) throws IOException {
            List<CatalogTableColumnDescriptor> columns = in.readEntryList(CatalogTableColumnDescriptor.class);
            int tableId = in.readVarIntAsInt();
            return new NewColumnsEntry(tableId, columns);
        }

        @Override
        public void writeTo(NewColumnsEntry entry, CatalogObjectDataOutput out) throws IOException {
            out.writeEntryList(entry.descriptors());
            out.writeVarInt(entry.tableId());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class NewColumnsEntrySerializerV1
    implements CatalogObjectSerializer<NewColumnsEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public NewColumnsEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public NewColumnsEntry readFrom(CatalogObjectDataInput in) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(serializer, in);
            int tableId = in.readVarIntAsInt();
            return new NewColumnsEntry(tableId, columns);
        }

        @Override
        public void writeTo(NewColumnsEntry entry, CatalogObjectDataOutput out) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            CatalogSerializationUtils.writeList(entry.descriptors(), serializer, out);
            out.writeVarInt(entry.tableId());
        }
    }
}

