/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.cluster.management.raft.CmgStorageException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.rocksdb.snapshot.ColumnFamilyRange;
import org.apache.ignite.internal.rocksdb.snapshot.RocksSnapshotManager;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbClusterStateStorage
implements ClusterStateStorage {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbClusterStateStorage.class);
    private final ExecutorService snapshotExecutor;
    private final Path dbPath;
    private final Options options = new Options().setCreateIfMissing(true);
    private final WriteOptions defaultWriteOptions = new WriteOptions().setDisableWAL(true);
    @Nullable
    private volatile RocksDB db;
    private volatile RocksSnapshotManager snapshotManager;
    private final Object snapshotRestoreLock = new Object();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();

    public RocksDbClusterStateStorage(Path dbPath, String nodeName) {
        this.dbPath = dbPath;
        this.snapshotExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"cluster-state-snapshot-executor", (IgniteLogger)LOG));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            try {
                Files.createDirectories(this.dbPath, new FileAttribute[0]);
                RocksDB.destroyDB((String)this.dbPath.toString(), (Options)this.options);
                this.init();
                return CompletableFutures.nullCompletedFuture();
            }
            catch (IOException | RocksDBException e) {
                return CompletableFuture.failedFuture((Throwable)((Object)new CmgStorageException("Failed to start the storage", e)));
            }
        });
    }

    private void init() {
        try {
            RocksDB db = RocksDB.open((Options)this.options, (String)this.dbPath.toString());
            ColumnFamily defaultCf = ColumnFamily.wrap((RocksDB)db, (ColumnFamilyHandle)db.getDefaultColumnFamily());
            this.snapshotManager = new RocksSnapshotManager(db, List.of(ColumnFamilyRange.fullRange((ColumnFamily)defaultCf)), (Executor)this.snapshotExecutor);
            this.db = db;
        }
        catch (RocksDBException e) {
            throw new CmgStorageException("Failed to start the storage", e);
        }
    }

    @Override
    public byte @Nullable [] get(byte[] key) {
        return (byte[])IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try {
                return this.db.get(key);
            }
            catch (RocksDBException e) {
                throw new CmgStorageException("Unable to get data from Rocks DB", e);
            }
        });
    }

    @Override
    public void put(byte[] key, byte[] value) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try {
                this.db.put(this.defaultWriteOptions, key, value);
            }
            catch (RocksDBException e) {
                throw new CmgStorageException("Unable to put data into Rocks DB", e);
            }
        });
    }

    @Override
    public void putAll(List<byte[]> keys, List<byte[]> values) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try (WriteBatch batch = new WriteBatch();){
                for (int i = 0; i < keys.size(); ++i) {
                    batch.put((byte[])keys.get(i), (byte[])values.get(i));
                }
                this.db.write(this.defaultWriteOptions, batch);
            }
            catch (RocksDBException e) {
                throw new CmgStorageException("Unable to put data into Rocks DB", e);
            }
        });
    }

    @Override
    public void replaceAll(byte[] prefix, byte[] key, byte[] value) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try (WriteBatch batch = new WriteBatch();){
                byte[] endKey = RocksUtils.incrementPrefix((byte[])prefix);
                assert (endKey != null) : Arrays.toString(prefix);
                batch.deleteRange(prefix, endKey);
                batch.put(key, value);
                this.db.write(this.defaultWriteOptions, batch);
            }
            catch (RocksDBException e) {
                throw new CmgStorageException("Unable to replace data in Rocks DB", e);
            }
        });
    }

    @Override
    public void remove(byte[] key) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try {
                this.db.delete(this.defaultWriteOptions, key);
            }
            catch (RocksDBException e) {
                throw new CmgStorageException("Unable to remove data from Rocks DB", e);
            }
        });
    }

    @Override
    public void removeAll(Collection<byte[]> keys) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try (WriteBatch batch = new WriteBatch();){
                for (byte[] key : keys) {
                    batch.delete(key);
                }
                this.db.write(this.defaultWriteOptions, batch);
            }
            catch (RocksDBException e) {
                throw new CmgStorageException("Unable to remove data from Rocks DB", e);
            }
        });
    }

    @Override
    public <T> List<T> getWithPrefix(byte[] prefix, BiFunction<byte[], byte[], T> entryTransformer) {
        return (List)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public CompletableFuture<Void> snapshot(Path snapshotPath) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> this.snapshotManager.createSnapshot(snapshotPath));
    }

    @Override
    public void restoreSnapshot(Path snapshotPath) {
        IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            Object object = this.snapshotRestoreLock;
            synchronized (object) {
                this.db.close();
                this.db = null;
                try {
                    RocksDB.destroyDB((String)this.dbPath.toString(), (Options)this.options);
                }
                catch (RocksDBException e) {
                    throw new CmgStorageException("Unable to stop the RocksDB instance", e);
                }
                this.init();
                this.snapshotManager.restoreSnapshot(snapshotPath);
            }
        });
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.snapshotExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        RocksUtils.closeAll((AbstractNativeReference[])new AbstractNativeReference[]{this.db, this.options, this.defaultWriteOptions});
        return CompletableFutures.nullCompletedFuture();
    }

    private static /* synthetic */ void lambda$getWithPrefix$7(ArrayList result, BiFunction entryTransformer, byte[] key, byte[] value) throws RocksDBException {
        result.add(entryTransformer.apply(key, value));
    }
}

