/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class CatalogZoneDescriptor
extends CatalogObjectDescriptor {
    public static final CatalogObjectSerializer<CatalogZoneDescriptor> SERIALIZER = new ZoneDescriptorSerializer();
    private final int partitions;
    private final int replicas;
    private final int dataNodesAutoAdjust;
    private final int dataNodesAutoAdjustScaleUp;
    private final int dataNodesAutoAdjustScaleDown;
    private final String filter;
    private final CatalogStorageProfilesDescriptor storageProfiles;
    private final ConsistencyMode consistencyMode;

    public static boolean updateRequiresAssignmentsRecalculation(CatalogZoneDescriptor oldDescriptor, CatalogZoneDescriptor newDescriptor) {
        if (oldDescriptor.updateToken() == newDescriptor.updateToken()) {
            return false;
        }
        return oldDescriptor.partitions != newDescriptor.partitions || oldDescriptor.replicas != newDescriptor.replicas || !oldDescriptor.filter.equals(newDescriptor.filter) || !oldDescriptor.storageProfiles.profiles().equals(newDescriptor.storageProfiles.profiles()) || oldDescriptor.consistencyMode != newDescriptor.consistencyMode;
    }

    public CatalogZoneDescriptor(int id, String name, int partitions, int replicas, int dataNodesAutoAdjust, int dataNodesAutoAdjustScaleUp, int dataNodesAutoAdjustScaleDown, String filter, CatalogStorageProfilesDescriptor storageProfiles, ConsistencyMode consistencyMode) {
        this(id, name, partitions, replicas, dataNodesAutoAdjust, dataNodesAutoAdjustScaleUp, dataNodesAutoAdjustScaleDown, filter, storageProfiles, 0L, consistencyMode);
    }

    private CatalogZoneDescriptor(int id, String name, int partitions, int replicas, int dataNodesAutoAdjust, int dataNodesAutoAdjustScaleUp, int dataNodesAutoAdjustScaleDown, String filter, CatalogStorageProfilesDescriptor storageProfiles, long causalityToken, ConsistencyMode consistencyMode) {
        super(id, CatalogObjectDescriptor.Type.ZONE, name, causalityToken);
        this.partitions = partitions;
        this.replicas = replicas;
        this.dataNodesAutoAdjust = dataNodesAutoAdjust;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfiles = storageProfiles;
        this.consistencyMode = consistencyMode;
    }

    public int partitions() {
        return this.partitions;
    }

    public int replicas() {
        return this.replicas;
    }

    public int dataNodesAutoAdjust() {
        return this.dataNodesAutoAdjust;
    }

    public int dataNodesAutoAdjustScaleUp() {
        return this.dataNodesAutoAdjustScaleUp;
    }

    public int dataNodesAutoAdjustScaleDown() {
        return this.dataNodesAutoAdjustScaleDown;
    }

    public String filter() {
        return this.filter;
    }

    public ConsistencyMode consistencyMode() {
        return this.consistencyMode;
    }

    public CatalogStorageProfilesDescriptor storageProfiles() {
        return this.storageProfiles;
    }

    @Override
    public String toString() {
        return S.toString(CatalogZoneDescriptor.class, (Object)this, (String)super.toString());
    }

    private static class ZoneDescriptorSerializer
    implements CatalogObjectSerializer<CatalogZoneDescriptor> {
        private ZoneDescriptorSerializer() {
        }

        @Override
        public CatalogZoneDescriptor readFrom(IgniteDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateToken = input.readVarInt();
            CatalogStorageProfilesDescriptor catalogStorageProfilesDescriptor = CatalogStorageProfilesDescriptor.SERIALIZER.readFrom(input);
            int partitions = input.readVarIntAsInt();
            int replicas = input.readVarIntAsInt();
            int dataNodesAutoAdjust = input.readVarIntAsInt();
            int dataNodesAutoAdjustScaleUp = input.readVarIntAsInt();
            int dataNodesAutoAdjustScaleDown = input.readVarIntAsInt();
            String filter = input.readUTF();
            ConsistencyMode consistencyMode = ConsistencyMode.forId(input.readByte());
            return new CatalogZoneDescriptor(id, name, partitions, replicas, dataNodesAutoAdjust, dataNodesAutoAdjustScaleUp, dataNodesAutoAdjustScaleDown, filter, catalogStorageProfilesDescriptor, updateToken, consistencyMode);
        }

        @Override
        public void writeTo(CatalogZoneDescriptor descriptor, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateToken());
            CatalogStorageProfilesDescriptor.SERIALIZER.writeTo(descriptor.storageProfiles(), output);
            output.writeVarInt((long)descriptor.partitions());
            output.writeVarInt((long)descriptor.replicas());
            output.writeVarInt((long)descriptor.dataNodesAutoAdjust());
            output.writeVarInt((long)descriptor.dataNodesAutoAdjustScaleUp());
            output.writeVarInt((long)descriptor.dataNodesAutoAdjustScaleDown());
            output.writeUTF(descriptor.filter());
            output.writeByte(descriptor.consistencyMode().id());
        }
    }
}

