/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.sql.ColumnType;

public final class ParameterType {
    private final ColumnType columnType;
    private final int precision;
    private final int scale;
    private final boolean nullable;

    public ParameterType(ColumnType columnType, int precision, int scale, boolean nullable) {
        this.columnType = columnType;
        this.precision = precision;
        this.scale = scale;
        this.nullable = nullable;
    }

    public ColumnType columnType() {
        return this.columnType;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    static ParameterType fromRelDataType(RelDataType type) {
        ColumnType columnType = TypeUtils.columnType(type);
        assert (columnType != null) : "No column type for " + String.valueOf(type);
        int precision = columnType.lengthAllowed() || columnType.precisionAllowed() ? type.getPrecision() : -1;
        int scale = columnType.scaleAllowed() ? type.getScale() : Integer.MIN_VALUE;
        return new ParameterType(columnType, precision, scale, type.isNullable());
    }
}

