/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite.internal.sql.engine.exec.RehashingPartitionExtractor;
import org.apache.ignite.internal.sql.engine.exec.ResolvedDependencies;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.TablePartitionExtractor;
import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.AllNodes;
import org.apache.ignite.internal.sql.engine.trait.Destination;
import org.apache.ignite.internal.sql.engine.trait.DistributionFunction;
import org.apache.ignite.internal.sql.engine.trait.Identity;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.Partitioned;
import org.apache.ignite.internal.sql.engine.trait.RandomNode;
import org.apache.ignite.internal.util.CollectionUtils;

class DestinationFactory<RowT> {
    private final RowHandler<RowT> rowHandler;
    private final ResolvedDependencies dependencies;

    DestinationFactory(RowHandler<RowT> rowHandler, ResolvedDependencies dependencies) {
        this.rowHandler = rowHandler;
        this.dependencies = dependencies;
    }

    Destination<RowT> createDestination(IgniteDistribution distribution, ColocationGroup group) {
        DistributionFunction function = distribution.function();
        switch (function.type()) {
            case SINGLETON: {
                assert (group.nodeNames() != null && group.nodeNames().size() == 1);
                return new AllNodes(Collections.singletonList(Objects.requireNonNull((String)CollectionUtils.first(group.nodeNames()))));
            }
            case BROADCAST_DISTRIBUTED: {
                assert (!CollectionUtils.nullOrEmpty(group.nodeNames()));
                return new AllNodes(group.nodeNames());
            }
            case RANDOM_DISTRIBUTED: {
                assert (!CollectionUtils.nullOrEmpty(group.nodeNames()));
                return new RandomNode(group.nodeNames());
            }
            case HASH_DISTRIBUTED: {
                ImmutableIntList keys = distribution.getKeys();
                assert (!CollectionUtils.nullOrEmpty((Collection)keys));
                if ("identity".equals(function.name())) {
                    assert (!CollectionUtils.nullOrEmpty(group.nodeNames()) && keys.size() == 1);
                    return new Identity<RowT>(this.rowHandler, keys.get(0), group.nodeNames());
                }
                if (function.affinity()) {
                    assert (!CollectionUtils.nullOrEmpty(group.assignments()));
                    int tableId = ((DistributionFunction.AffinityDistribution)function).tableId();
                    Supplier<PartitionCalculator> calculator = this.dependencies.partitionCalculator(tableId);
                    TableDescriptor tableDescriptor = this.dependencies.tableDescriptor(tableId);
                    TablePartitionExtractor<RowT> resolver = new TablePartitionExtractor<RowT>(calculator.get(), keys.toIntArray(), tableDescriptor, this.rowHandler);
                    Map<Integer, String> partToNode = group.assignments().int2ObjectEntrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NodeWithConsistencyToken)e.getValue()).name()));
                    return new Partitioned<RowT>(partToNode, resolver);
                }
                RehashingPartitionExtractor<RowT> resolver = new RehashingPartitionExtractor<RowT>(group.nodeNames().size(), keys.toIntArray(), this.rowHandler);
                Int2ObjectOpenHashMap partToNode = new Int2ObjectOpenHashMap();
                int pos = 0;
                for (String name : group.nodeNames()) {
                    partToNode.put(pos++, (Object)name);
                }
                return new Partitioned<RowT>((Map<Integer, String>)partToNode, resolver);
            }
        }
        throw new IllegalStateException("Unsupported distribution function.");
    }
}

