/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRightMaterializedJoinNode<RowT>
extends AbstractNode<RowT> {
    static final int NOT_WAITING = -1;
    protected boolean inLoop;
    protected int requested;
    int waitingLeft;
    int waitingRight;
    final Deque<RowT> leftInBuf = new ArrayDeque<RowT>(512);
    @Nullable
    protected RowT left;

    AbstractRightMaterializedJoinNode(ExecutionContext<RowT> ctx) {
        super(ctx);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 2);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::doJoin, this::onError);
        }
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waitingLeft = 0;
        this.waitingRight = 0;
        this.left = null;
        this.leftInBuf.clear();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx == 0) {
            return new Downstream<RowT>(){

                @Override
                public void push(RowT row) throws Exception {
                    AbstractRightMaterializedJoinNode.this.pushLeft(row);
                }

                @Override
                public void end() throws Exception {
                    AbstractRightMaterializedJoinNode.this.endLeft();
                }

                @Override
                public void onError(Throwable e) {
                    AbstractRightMaterializedJoinNode.this.onError(e);
                }
            };
        }
        if (idx == 1) {
            return new Downstream<RowT>(){

                @Override
                public void push(RowT row) throws Exception {
                    AbstractRightMaterializedJoinNode.this.pushRight(row);
                }

                @Override
                public void end() throws Exception {
                    AbstractRightMaterializedJoinNode.this.endRight();
                }

                @Override
                public void onError(Throwable e) {
                    AbstractRightMaterializedJoinNode.this.onError(e);
                }
            };
        }
        throw new IndexOutOfBoundsException();
    }

    private void pushLeft(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        --this.waitingLeft;
        this.leftInBuf.add(row);
        this.join();
    }

    private void endLeft() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        this.waitingLeft = -1;
        this.join();
    }

    private void endRight() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        this.waitingRight = -1;
        this.join();
    }

    Node<RowT> leftSource() {
        return this.sources().get(0);
    }

    Node<RowT> rightSource() {
        return this.sources().get(1);
    }

    private void doJoin() throws Exception {
        this.checkState();
        this.join();
    }

    protected abstract void join() throws Exception;

    protected abstract void pushRight(RowT var1) throws Exception;
}

