/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.ignite.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite.internal.sql.engine.exec.ScannableDataSource;
import org.apache.ignite.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;

public class ResolvedDependencies {
    private final Map<Integer, ExecutableTable> tableMap;
    private final Map<Integer, ScannableDataSource> dataSourceMap;

    public ResolvedDependencies(Map<Integer, ExecutableTable> tableMap, Map<Integer, ScannableDataSource> dataSourceMap) {
        this.tableMap = tableMap;
        this.dataSourceMap = dataSourceMap;
    }

    public ScannableTable scannableTable(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.scannableTable();
    }

    public UpdatableTable updatableTable(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.updatableTable();
    }

    public TableDescriptor tableDescriptor(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.tableDescriptor();
    }

    public Supplier<PartitionCalculator> partitionCalculator(int tableId) {
        ExecutableTable executableTable = this.getTable(tableId);
        return executableTable.partitionCalculator();
    }

    public ScannableDataSource dataSource(int dataSourceId) {
        ScannableDataSource dataSource = this.dataSourceMap.get(dataSourceId);
        assert (dataSource != null) : "DataSource does not exist: " + dataSourceId;
        return dataSource;
    }

    private ExecutableTable getTable(int tableId) {
        ExecutableTable executableTable = this.tableMap.get(tableId);
        assert (executableTable != null) : "ExecutableTable does not exist: " + tableId;
        return executableTable;
    }
}

