/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index;

import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.util.GradualTask;
import org.apache.ignite.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.PeekCursor;
import org.apache.ignite.internal.storage.pagememory.index.common.IndexRowKey;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaKey;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.index.meta.UpdateLastRowIdUuidToBuildInvokeClosure;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryIndexStorage<K extends IndexRowKey, V extends K, TreeT extends BplusTree<K, V>>
implements IndexStorage {
    protected final int partitionId;
    protected final RowId lowestRowId;
    protected final RowId highestRowId;
    protected final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    private volatile IndexMetaTree indexMetaTree;
    protected volatile FreeListImpl freeList;
    protected volatile TreeT indexTree;
    @Nullable
    private volatile RowId nextRowIdToBuild;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final int indexId;
    private final boolean isVolatile;
    private static final IndexRowKey NO_INDEX_ROW = () -> null;

    protected AbstractPageMemoryIndexStorage(IndexMeta indexMeta, int partitionId, TreeT indexTree, FreeListImpl freeList, IndexMetaTree indexMetaTree, boolean isVolatile) {
        this.indexId = indexMeta.indexId();
        this.partitionId = partitionId;
        this.indexTree = indexTree;
        this.freeList = freeList;
        this.indexMetaTree = indexMetaTree;
        this.isVolatile = isVolatile;
        this.lowestRowId = RowId.lowestRowId((int)partitionId);
        this.highestRowId = RowId.highestRowId((int)partitionId);
        this.nextRowIdToBuild = this.getNextRowIdToBuild(indexMeta);
    }

    @Nullable
    private RowId getNextRowIdToBuild(IndexMeta indexMeta) {
        UUID uuid = indexMeta.nextRowIdUuidToBuild();
        return uuid == null ? null : new RowId(this.partitionId, uuid);
    }

    @Nullable
    public RowId getNextRowIdToBuild() {
        return this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            return this.nextRowIdToBuild;
        });
    }

    public void setNextRowIdToBuild(@Nullable RowId rowId) {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.state.get(), this::createStorageInfo);
            UUID rowIdUuid = rowId == null ? null : rowId.uuid();
            try {
                this.indexMetaTree.invoke(new IndexMetaKey(this.indexId), null, new UpdateLastRowIdUuidToBuildInvokeClosure(rowIdUuid));
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error updating last row ID uuid to build: [{}, rowId={}]", (Throwable)e, new Object[]{this.createStorageInfo(), rowId});
            }
            this.nextRowIdToBuild = rowId;
            return null;
        });
    }

    public void close() {
        if (!this.transitionToTerminalState(StorageState.CLOSED)) {
            return;
        }
        this.busyLock.block();
        this.closeStructures();
    }

    private boolean transitionToTerminalState(StorageState targetState) {
        return StorageUtils.transitionToTerminalState((StorageState)targetState, this.state);
    }

    public void startRebalance() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            this.closeStructures();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void completeRebalance() {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
    }

    public void startCleanup() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            StorageUtils.throwExceptionDependingOnStorageState((StorageState)this.state.get(), (String)this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            this.closeStructures();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void finishCleanup() {
        this.state.compareAndSet(StorageState.CLEANUP, StorageState.RUNNABLE);
    }

    public final CompletableFuture<Void> startDestructionOn(GradualTaskExecutor executor) throws StorageException {
        try {
            int maxWorkUnits = this.isVolatile ? 1000 : 1000;
            return executor.execute(this.createDestructionTask(maxWorkUnits));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Unable to destroy index " + this.indexId, (Throwable)e);
        }
    }

    public boolean transitionToDestroyedState() {
        if (!this.transitionToTerminalState(StorageState.DESTROYED)) {
            return false;
        }
        this.busyLock.block();
        return true;
    }

    protected abstract GradualTask createDestructionTask(int var1) throws IgniteInternalCheckedException;

    protected String createStorageInfo() {
        return IgniteStringFormatter.format((String)"indexId={}, partitionId={}", (Object[])new Object[]{this.indexId, this.partitionId});
    }

    public void closeStructures() {
        this.indexTree.close();
        this.nextRowIdToBuild = null;
    }

    public void updateDataStructures(IndexMetaTree indexMetaTree, FreeListImpl freeList, TreeT indexTree) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState((StorageState)this.state.get(), this::createStorageInfo);
        this.indexMetaTree = indexMetaTree;
        this.freeList = freeList;
        this.indexTree = indexTree;
        try {
            IndexMeta indexMeta = (IndexMeta)indexMetaTree.findOne(new IndexMetaKey(this.indexId), null);
            assert (indexMeta != null) : this.indexId;
            this.nextRowIdToBuild = this.getNextRowIdToBuild(indexMeta);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error reading next row ID uuid to build: [{}]", (Throwable)e, new Object[]{this.createStorageInfo()});
        }
    }

    protected <T> T busyNonDataRead(Supplier<T> supplier) {
        return this.busy(supplier, false);
    }

    protected <T> T busyDataRead(Supplier<T> supplier) {
        return this.busy(supplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T busy(Supplier<T> supplier, boolean read) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnIndexStorageState((StorageState)this.state.get(), (boolean)read, (String)this.createStorageInfo());
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    protected void throwExceptionIfIndexIsNotBuilt() {
        StorageUtils.throwExceptionIfIndexIsNotBuilt((RowId)this.nextRowIdToBuild, this::createStorageInfo);
    }

    protected static abstract class ScanCursor<R>
    implements PeekCursor<R> {
        protected final TreeT localTree;
        @Nullable
        private final K lower;
        @Nullable
        private Boolean hasNext;
        @Nullable
        private V treeRow;
        @Nullable
        private V peekedRow;
        final /* synthetic */ AbstractPageMemoryIndexStorage this$0;

        protected ScanCursor(K lower) {
            this.this$0 = this$0;
            this.localTree = this.this$0.indexTree;
            this.peekedRow = NO_INDEX_ROW;
            this.lower = lower;
        }

        protected abstract R map(V var1);

        protected abstract boolean exceedsUpperBound(V var1);

        public void close() {
        }

        public boolean hasNext() {
            return this.this$0.busyDataRead(() -> {
                try {
                    return this.advanceIfNeededBusy();
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Error while advancing the cursor", (Throwable)e);
                }
            });
        }

        public R next() {
            return (R)this.this$0.busyDataRead(() -> {
                try {
                    if (!this.advanceIfNeededBusy()) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = null;
                    return this.map(this.treeRow);
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Error while advancing the cursor", (Throwable)e);
                }
            });
        }

        @Nullable
        public R peek() {
            return (R)this.this$0.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.this$0.state.get(), this.this$0::createStorageInfo);
                try {
                    return this.map(this.peekBusy());
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Error when peeking next element", (Throwable)e);
                }
            });
        }

        @Nullable
        private V peekBusy() throws IgniteInternalCheckedException {
            if (this.hasNext != null) {
                return this.treeRow;
            }
            this.peekedRow = this.treeRow == null ? (this.lower == null ? (IndexRowKey)this.localTree.findFirst() : (IndexRowKey)this.localTree.findNext(this.lower, true)) : (IndexRowKey)this.localTree.findNext(this.treeRow, false);
            if (this.peekedRow != null && this.exceedsUpperBound(this.peekedRow)) {
                this.peekedRow = null;
            }
            return this.peekedRow;
        }

        private boolean advanceIfNeededBusy() throws IgniteInternalCheckedException {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)this.this$0.state.get(), this.this$0::createStorageInfo);
            if (this.hasNext != null) {
                return this.hasNext;
            }
            this.treeRow = this.peekedRow == NO_INDEX_ROW ? this.peekBusy() : this.peekedRow;
            this.peekedRow = NO_INDEX_ROW;
            this.hasNext = this.treeRow != null;
            return this.hasNext;
        }
    }
}

