/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.logger;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteThrottledLogger;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

class IgniteThrottledLoggerImpl
implements IgniteThrottledLogger {
    private final long throttleIntervalMs = IgniteSystemProperties.getLong("IGNITE_LOG_THROTTLE_INTERVAL_MS", DEFAULT_LOG_THROTTLE_INTERVAL_MS);
    private final System.Logger delegate;
    private final Map<LogThrottleKey, Long> messagesMap;

    IgniteThrottledLoggerImpl(System.Logger delegate, ExecutorService executor) {
        this.delegate = delegate;
        this.messagesMap = Caffeine.newBuilder().executor(executor).expireAfterWrite(this.throttleIntervalMs, TimeUnit.MILLISECONDS).build().asMap();
    }

    @Override
    public void info(String msg, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.INFO);
    }

    @Override
    public void info(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.INFO);
    }

    @Override
    public void info(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(null, msgSupplier, th, System.Logger.Level.INFO);
    }

    @Override
    public void info(String msg, @Nullable Throwable th) {
        this.logInternal(null, () -> msg, th, System.Logger.Level.INFO);
    }

    @Override
    public void info(String throttleKey, String msg, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.INFO);
    }

    @Override
    public void info(String throttleKey, String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.INFO);
    }

    @Override
    public void info(String throttleKey, Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(throttleKey, msgSupplier, th, System.Logger.Level.INFO);
    }

    @Override
    public void info(String throttleKey, String msg, @Nullable Throwable th) {
        this.logInternal(throttleKey, () -> msg, th, System.Logger.Level.INFO);
    }

    @Override
    public void debug(String msg, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(null, msgSupplier, th, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String msg, @Nullable Throwable th) {
        this.logInternal(null, () -> msg, th, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String throttleKey, String msg, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String throttleKey, String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String throttleKey, Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(throttleKey, msgSupplier, th, System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String throttleKey, String msg, @Nullable Throwable th) {
        this.logInternal(throttleKey, () -> msg, th, System.Logger.Level.DEBUG);
    }

    @Override
    public void warn(String msg, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(null, msgSupplier, th, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(String msg, @Nullable Throwable th) {
        this.logInternal(null, () -> msg, th, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(String throttleKey, String msg, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(String throttleKey, String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(String throttleKey, Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(throttleKey, msgSupplier, th, System.Logger.Level.WARNING);
    }

    @Override
    public void warn(String throttleKey, String msg, @Nullable Throwable th) {
        this.logInternal(throttleKey, () -> msg, th, System.Logger.Level.WARNING);
    }

    @Override
    public void error(String msg, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.ERROR);
    }

    @Override
    public void error(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.ERROR);
    }

    @Override
    public void error(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(null, msgSupplier, th, System.Logger.Level.ERROR);
    }

    @Override
    public void error(String msg, @Nullable Throwable th) {
        this.logInternal(null, () -> msg, th, System.Logger.Level.ERROR);
    }

    @Override
    public void error(String throttleKey, String msg, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.ERROR);
    }

    @Override
    public void error(String throttleKey, String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.ERROR);
    }

    @Override
    public void error(String throttleKey, Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(throttleKey, msgSupplier, th, System.Logger.Level.ERROR);
    }

    @Override
    public void error(String throttleKey, String msg, @Nullable Throwable th) {
        this.logInternal(throttleKey, () -> msg, th, System.Logger.Level.ERROR);
    }

    @Override
    public void trace(String msg, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(null, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(null, msgSupplier, th, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String msg, @Nullable Throwable th) {
        this.logInternal(null, () -> msg, th, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String throttleKey, String msg, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), null, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String throttleKey, String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(throttleKey, () -> IgniteStringFormatter.format(msg, params), th, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String throttleKey, Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternal(throttleKey, msgSupplier, th, System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String throttleKey, String msg, @Nullable Throwable th) {
        this.logInternal(throttleKey, () -> msg, th, System.Logger.Level.TRACE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.TRACE);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.WARNING);
    }

    private void logInternal(@Nullable String throttleKey, Supplier<String> messageSupplier, @Nullable Throwable throwable, System.Logger.Level level) {
        block4: {
            long curTs;
            Long loggedTs;
            if (!this.delegate.isLoggable(level)) {
                return;
            }
            String message = messageSupplier.get();
            LogThrottleKey msgKey = new LogThrottleKey(throwable, throttleKey == null ? message : throttleKey);
            do {
                loggedTs = this.messagesMap.get(msgKey);
                curTs = FastTimestamps.coarseCurrentTimeMillis();
                if (loggedTs != null && curTs - loggedTs < this.throttleIntervalMs) break block4;
            } while (!this.replace(msgKey, loggedTs, curTs));
            if (throwable == null) {
                this.delegate.log(level, message);
            } else {
                this.delegate.log(level, message, throwable);
            }
        }
    }

    private boolean replace(LogThrottleKey key, @Nullable Long oldTs, Long newTs) {
        if (oldTs == null) {
            Long old = this.messagesMap.putIfAbsent(key, newTs);
            return old == null;
        }
        return this.messagesMap.replace(key, oldTs, newTs);
    }

    private static class LogThrottleKey {
        @Nullable
        final Class<? extends Throwable> errorClass;
        final String errorMessage;

        LogThrottleKey(@Nullable Throwable error, String errorMessage) {
            this.errorClass = error == null ? null : error.getClass();
            this.errorMessage = errorMessage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogThrottleKey that = (LogThrottleKey)o;
            return Objects.equals(this.errorClass, that.errorClass) && this.errorMessage.equals(that.errorMessage);
        }

        public int hashCode() {
            int result = this.errorClass != null ? this.errorClass.hashCode() : 0;
            result = 31 * result + this.errorMessage.hashCode();
            return result;
        }
    }
}

