/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.resolution.logic;

import com.github.javaparser.resolution.MethodAmbiguityException;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodLikeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedParameterDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.logic.MethodResolutionCapability;
import com.github.javaparser.resolution.model.LambdaArgumentTypePlaceholder;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedTypeVariable;
import com.github.javaparser.resolution.types.ResolvedWildcard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MethodResolutionLogic {
    private static String JAVA_LANG_OBJECT = Object.class.getCanonicalName();

    private static List<ResolvedType> groupVariadicParamValues(List<ResolvedType> argumentsTypes, int startVariadic, ResolvedType variadicType) {
        ArrayList<ResolvedType> res = new ArrayList<ResolvedType>(argumentsTypes.subList(0, startVariadic));
        List<ResolvedType> variadicValues = argumentsTypes.subList(startVariadic, argumentsTypes.size());
        if (variadicValues.isEmpty()) {
            res.add(variadicType);
        } else {
            ResolvedType componentType = MethodResolutionLogic.findCommonType(variadicValues);
            res.add(MethodResolutionLogic.convertToVariadicParameter(componentType));
        }
        return res;
    }

    private static ResolvedType findCommonType(List<ResolvedType> variadicValues) {
        if (variadicValues.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return variadicValues.get(0);
    }

    public static boolean isApplicable(ResolvedMethodDeclaration method, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        return MethodResolutionLogic.isApplicable(method, name, argumentsTypes, typeSolver, false);
    }

    private static boolean isConflictingLambdaType(LambdaArgumentTypePlaceholder lambdaPlaceholder, ResolvedType expectedType) {
        if (!expectedType.isReferenceType()) {
            return false;
        }
        Optional<MethodUsage> maybeFunctionalInterface = FunctionalInterfaceLogic.getFunctionalMethod(expectedType);
        if (maybeFunctionalInterface.isPresent()) {
            MethodUsage functionalInterface = maybeFunctionalInterface.get();
            if (lambdaPlaceholder.getParameterCount().isPresent() && functionalInterface.getNoParams() != lambdaPlaceholder.getParameterCount().get().intValue()) {
                return true;
            }
            if (lambdaPlaceholder.bodyBlockHasExplicitNonVoidReturn().isPresent()) {
                boolean lambdaReturnIsVoid;
                boolean bl = lambdaReturnIsVoid = lambdaPlaceholder.bodyBlockHasExplicitNonVoidReturn().get() == false;
                if (lambdaReturnIsVoid && !functionalInterface.returnType().isVoid()) {
                    return true;
                }
                if (!lambdaReturnIsVoid && functionalInterface.returnType().isVoid()) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isApplicable(ResolvedMethodDeclaration methodDeclaration, String needleName, List<ResolvedType> needleArgumentTypes, TypeSolver typeSolver, boolean withWildcardTolerance) {
        int countOfNeedleArgumentsPassedAfterGrouping;
        if (!methodDeclaration.getName().equals(needleName)) {
            return false;
        }
        MethodUsage methodUsageForSubstitution = new MethodUsage(methodDeclaration);
        methodUsageForSubstitution = MethodResolutionLogic.substituteDeclaringTypeParameters(methodUsageForSubstitution, typeSolver);
        int countOfMethodParametersDeclared = methodDeclaration.getNumberOfParams();
        int countOfNeedleArgumentsPassed = needleArgumentTypes.size();
        boolean methodIsDeclaredWithVariadicParameter = methodDeclaration.hasVariadicParameter();
        if (!methodIsDeclaredWithVariadicParameter && countOfNeedleArgumentsPassed != countOfMethodParametersDeclared) {
            return false;
        }
        if (methodIsDeclaredWithVariadicParameter) {
            if (countOfNeedleArgumentsPassed <= countOfMethodParametersDeclared - 2) {
                return false;
            }
            ResolvedType expectedVariadicParameterType = methodDeclaration.getLastParam().getType();
            for (ResolvedTypeParameterDeclaration tp : methodDeclaration.getTypeParameters()) {
                expectedVariadicParameterType = MethodResolutionLogic.replaceTypeParam(expectedVariadicParameterType, tp, typeSolver);
            }
            if (countOfNeedleArgumentsPassed > countOfMethodParametersDeclared) {
                for (int variadicArgumentIndex = countOfMethodParametersDeclared; variadicArgumentIndex < countOfNeedleArgumentsPassed; ++variadicArgumentIndex) {
                    ResolvedType currentArgumentType = needleArgumentTypes.get(variadicArgumentIndex);
                    ResolvedType variadicComponentType = expectedVariadicParameterType.asArrayType().getComponentType();
                    boolean argumentIsAssignableToVariadicComponentType = variadicComponentType.isAssignableBy(currentArgumentType);
                    if (!argumentIsAssignableToVariadicComponentType) {
                        argumentIsAssignableToVariadicComponentType = MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(variadicComponentType, currentArgumentType, typeSolver);
                    }
                    if (argumentIsAssignableToVariadicComponentType) continue;
                    return false;
                }
            }
            needleArgumentTypes = MethodResolutionLogic.groupTrailingArgumentsIntoArray(methodDeclaration, needleArgumentTypes, expectedVariadicParameterType);
        }
        if ((countOfNeedleArgumentsPassedAfterGrouping = needleArgumentTypes.size()) != countOfMethodParametersDeclared) {
            return false;
        }
        HashMap<String, ResolvedType> matchedParameters = new HashMap<String, ResolvedType>();
        boolean needForWildCardTolerance = false;
        for (int i = 0; i < countOfMethodParametersDeclared; ++i) {
            boolean isAssignableWithoutSubstitution;
            ResolvedType expectedDeclaredType = methodDeclaration.getParam(i).getType();
            ResolvedType actualArgumentType = needleArgumentTypes.get(i);
            if (actualArgumentType instanceof LambdaArgumentTypePlaceholder && MethodResolutionLogic.isConflictingLambdaType((LambdaArgumentTypePlaceholder)actualArgumentType, expectedDeclaredType)) {
                return false;
            }
            if (expectedDeclaredType.isTypeVariable() && !expectedDeclaredType.isWildcard() && expectedDeclaredType.asTypeParameter().declaredOnMethod()) {
                matchedParameters.put(expectedDeclaredType.asTypeParameter().getName(), actualArgumentType);
                continue;
            }
            if (methodDeclaration.getParam(i).isVariadic() && i == countOfMethodParametersDeclared - 1 && MethodResolutionLogic.isArrayOfObject(expectedDeclaredType) && actualArgumentType.isArray()) continue;
            boolean bl = isAssignableWithoutSubstitution = expectedDeclaredType.isAssignableBy(actualArgumentType) || methodDeclaration.getParam(i).isVariadic() && MethodResolutionLogic.convertToVariadicParameter(expectedDeclaredType).isAssignableBy(actualArgumentType);
            if (!isAssignableWithoutSubstitution && expectedDeclaredType.isReferenceType() && actualArgumentType.isReferenceType()) {
                isAssignableWithoutSubstitution = MethodResolutionLogic.isAssignableMatchTypeParameters(expectedDeclaredType.asReferenceType(), actualArgumentType.asReferenceType(), matchedParameters);
            }
            if (isAssignableWithoutSubstitution) continue;
            List<ResolvedTypeParameterDeclaration> typeParameters = methodDeclaration.getTypeParameters();
            typeParameters.addAll(methodDeclaration.declaringType().getTypeParameters());
            for (ResolvedTypeParameterDeclaration tp : typeParameters) {
                expectedDeclaredType = MethodResolutionLogic.replaceTypeParam(expectedDeclaredType, tp, typeSolver);
            }
            if (expectedDeclaredType.isAssignableBy(actualArgumentType) || MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedDeclaredType, actualArgumentType, typeSolver)) continue;
            if (actualArgumentType.isWildcard() && withWildcardTolerance && !expectedDeclaredType.isPrimitive()) {
                needForWildCardTolerance = true;
                continue;
            }
            if (actualArgumentType.isConstraint() && withWildcardTolerance && (actualArgumentType.asConstraintType().getBound().isTypeVariable() || !actualArgumentType.asConstraintType().getBound().isTypeVariable() && expectedDeclaredType.isAssignableBy(actualArgumentType.asConstraintType().getBound()))) {
                needForWildCardTolerance = true;
                continue;
            }
            if (methodIsDeclaredWithVariadicParameter && i == countOfMethodParametersDeclared - 1 && MethodResolutionLogic.convertToVariadicParameter(expectedDeclaredType).isAssignableBy(actualArgumentType)) continue;
            return false;
        }
        return !withWildcardTolerance || needForWildCardTolerance;
    }

    private static boolean isArrayOfObject(ResolvedType type) {
        return type.isArray() && type.asArrayType().getComponentType().isReferenceType() && type.asArrayType().getComponentType().asReferenceType().isJavaLangObject();
    }

    private static ResolvedArrayType convertToVariadicParameter(ResolvedType type) {
        return type.isArray() ? type.asArrayType() : new ResolvedArrayType(type);
    }

    private static int getLastParameterIndex(int countOfMethodParametersDeclared) {
        return Math.max(0, countOfMethodParametersDeclared - 1);
    }

    private static List<ResolvedType> groupTrailingArgumentsIntoArray(ResolvedMethodDeclaration methodDeclaration, List<ResolvedType> needleArgumentTypes, ResolvedType expectedVariadicParameterType) {
        int countOfMethodParametersDeclared = methodDeclaration.getNumberOfParams();
        int lastMethodParameterIndex = MethodResolutionLogic.getLastParameterIndex(countOfMethodParametersDeclared);
        int countOfNeedleArgumentsPassed = needleArgumentTypes.size();
        int lastNeedleArgumentIndex = MethodResolutionLogic.getLastParameterIndex(countOfNeedleArgumentsPassed);
        if (countOfNeedleArgumentsPassed > countOfMethodParametersDeclared) {
            needleArgumentTypes = MethodResolutionLogic.groupVariadicParamValues(needleArgumentTypes, lastMethodParameterIndex, methodDeclaration.getLastParam().getType());
        }
        if (countOfNeedleArgumentsPassed == countOfMethodParametersDeclared - 1) {
            needleArgumentTypes = MethodResolutionLogic.groupVariadicParamValues(needleArgumentTypes, lastMethodParameterIndex, methodDeclaration.getLastParam().getType());
        } else if (countOfNeedleArgumentsPassed == countOfMethodParametersDeclared) {
            boolean finalArgumentIsArray;
            ResolvedType actualArgumentType = needleArgumentTypes.get(lastNeedleArgumentIndex);
            boolean bl = finalArgumentIsArray = actualArgumentType.isArray() && expectedVariadicParameterType.isAssignableBy(actualArgumentType.asArrayType().getComponentType());
            if (!finalArgumentIsArray) {
                needleArgumentTypes = MethodResolutionLogic.groupVariadicParamValues(needleArgumentTypes, lastMethodParameterIndex, methodDeclaration.getLastParam().getType());
            }
        }
        return needleArgumentTypes;
    }

    public static boolean isAssignableMatchTypeParameters(ResolvedType expected, ResolvedType actual, Map<String, ResolvedType> matchedParameters) {
        if (expected.isReferenceType() && actual.isReferenceType()) {
            return MethodResolutionLogic.isAssignableMatchTypeParameters(expected.asReferenceType(), actual.asReferenceType(), matchedParameters);
        }
        if (expected.isReferenceType() && ResolvedPrimitiveType.isBoxType(expected) && actual.isPrimitive()) {
            ResolvedPrimitiveType expectedType = ResolvedPrimitiveType.byBoxTypeQName(expected.asReferenceType().getQualifiedName()).get().asPrimitive();
            return expected.isAssignableBy(actual);
        }
        if (expected.isTypeVariable()) {
            matchedParameters.put(expected.asTypeParameter().getName(), actual);
            return true;
        }
        if (expected.isArray()) {
            matchedParameters.put(expected.asArrayType().getComponentType().toString(), actual);
            return true;
        }
        throw new UnsupportedOperationException(expected.getClass().getCanonicalName() + " " + actual.getClass().getCanonicalName());
    }

    public static boolean isAssignableMatchTypeParameters(ResolvedReferenceType expected, ResolvedReferenceType actual, Map<String, ResolvedType> matchedParameters) {
        if (actual.getQualifiedName().equals(expected.getQualifiedName())) {
            return MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(expected, actual, matchedParameters);
        }
        List<ResolvedReferenceType> ancestors = actual.getAllAncestors();
        for (ResolvedReferenceType ancestor : ancestors) {
            if (!MethodResolutionLogic.isAssignableMatchTypeParametersMatchingQName(expected, ancestor, matchedParameters)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableMatchTypeParametersMatchingQName(ResolvedReferenceType expected, ResolvedReferenceType actual, Map<String, ResolvedType> matchedParameters) {
        if (!expected.getQualifiedName().equals(actual.getQualifiedName())) {
            return false;
        }
        if (expected.typeParametersValues().size() != actual.typeParametersValues().size()) {
            throw new UnsupportedOperationException();
        }
        int i = 0;
        if (i < expected.typeParametersValues().size()) {
            ResolvedType expectedParam = expected.typeParametersValues().get(i);
            ResolvedType actualParam = actual.typeParametersValues().get(i);
            if (expectedParam.isReferenceType() && actualParam.isReferenceType()) {
                ResolvedReferenceType r1 = expectedParam.asReferenceType();
                ResolvedReferenceType r2 = actualParam.asReferenceType();
                return MethodResolutionLogic.isAssignableMatchTypeParameters(r1, r2, matchedParameters);
            }
            if (expectedParam.isArray() && actualParam.isArray()) {
                ResolvedType r1 = expectedParam.asArrayType().getComponentType();
                ResolvedType r2 = actualParam.asArrayType().getComponentType();
                return MethodResolutionLogic.isAssignableMatchTypeParameters(r1, r2, matchedParameters);
            }
            if (expectedParam.isTypeVariable()) {
                String expectedParamName = expectedParam.asTypeParameter().getName();
                if (!actualParam.isTypeVariable() || !actualParam.asTypeParameter().getName().equals(expectedParamName)) {
                    return MethodResolutionLogic.matchTypeVariable(expectedParam.asTypeVariable(), actualParam, matchedParameters);
                }
                return true;
            }
            if (expectedParam.isReferenceType()) {
                if (actualParam.isTypeVariable()) {
                    return MethodResolutionLogic.matchTypeVariable(actualParam.asTypeVariable(), expectedParam, matchedParameters);
                }
                if (!expectedParam.equals(actualParam)) {
                    return false;
                }
            }
            if (expectedParam.isWildcard()) {
                if (expectedParam.asWildcard().isExtends()) {
                    if (actualParam.isWildcard() && !actualParam.asWildcard().isBounded()) {
                        return true;
                    }
                    if (actualParam.isTypeVariable()) {
                        return MethodResolutionLogic.matchTypeVariable(actualParam.asTypeVariable(), expectedParam.asWildcard().getBoundedType(), matchedParameters);
                    }
                    return MethodResolutionLogic.isAssignableMatchTypeParameters(expectedParam.asWildcard().getBoundedType(), actualParam, matchedParameters);
                }
                return true;
            }
            throw new UnsupportedOperationException(expectedParam.describe());
        }
        return true;
    }

    private static boolean matchTypeVariable(ResolvedTypeVariable typeVariable, ResolvedType type, Map<String, ResolvedType> matchedParameters) {
        String typeParameterName = typeVariable.asTypeParameter().getName();
        if (matchedParameters.containsKey(typeParameterName)) {
            ResolvedType matchedParameter = matchedParameters.get(typeParameterName);
            if (matchedParameter.isAssignableBy(type)) {
                return true;
            }
            if (type.isAssignableBy(matchedParameter)) {
                matchedParameters.put(typeParameterName, type);
                return true;
            }
            return false;
        }
        matchedParameters.put(typeParameterName, type);
        return true;
    }

    public static ResolvedType replaceTypeParam(ResolvedType type, ResolvedTypeParameterDeclaration tp, TypeSolver typeSolver) {
        if (type.isTypeVariable() || type.isWildcard()) {
            if (type.describe().equals(tp.getName())) {
                List<ResolvedTypeParameterDeclaration.Bound> bounds = tp.getBounds();
                if (bounds.size() > 1) {
                    throw new UnsupportedOperationException();
                }
                if (bounds.size() == 1) {
                    return bounds.get(0).getType();
                }
                return new ReferenceTypeImpl(typeSolver.solveType(JAVA_LANG_OBJECT));
            }
            return type;
        }
        if (type.isPrimitive()) {
            return type;
        }
        if (type.isArray()) {
            return new ResolvedArrayType(MethodResolutionLogic.replaceTypeParam(type.asArrayType().getComponentType(), tp, typeSolver));
        }
        if (type.isReferenceType()) {
            ResolvedReferenceType result = type.asReferenceType();
            result = result.transformTypeParameters(typeParam -> MethodResolutionLogic.replaceTypeParam(typeParam, tp, typeSolver)).asReferenceType();
            return result;
        }
        throw new UnsupportedOperationException("Replacing " + type + ", param " + tp + " with " + type.getClass().getCanonicalName());
    }

    public static boolean isApplicable(MethodUsage methodUsage, String needleName, List<ResolvedType> needleParameterTypes, TypeSolver typeSolver) {
        if (!methodUsage.getName().equals(needleName)) {
            return false;
        }
        methodUsage = MethodResolutionLogic.substituteDeclaringTypeParameters(methodUsage, typeSolver);
        int countOfMethodUsageArgumentsPassed = methodUsage.getNoParams();
        int lastMethodUsageArgumentIndex = MethodResolutionLogic.getLastParameterIndex(countOfMethodUsageArgumentsPassed);
        int needleParameterCount = needleParameterTypes.size();
        boolean methodIsDeclaredWithVariadicParameter = methodUsage.getDeclaration().hasVariadicParameter();
        if (!methodIsDeclaredWithVariadicParameter && needleParameterCount != countOfMethodUsageArgumentsPassed) {
            return false;
        }
        if (needleParameterCount != countOfMethodUsageArgumentsPassed && needleParameterCount < lastMethodUsageArgumentIndex) {
            return false;
        }
        for (int i = 0; i < needleParameterCount; ++i) {
            boolean bl;
            boolean bl2;
            ResolvedType expectedArgumentType;
            boolean reachedVariadicParam;
            ResolvedType actualArgumentType = needleParameterTypes.get(i);
            boolean bl3 = reachedVariadicParam = methodIsDeclaredWithVariadicParameter && i >= lastMethodUsageArgumentIndex;
            if (!reachedVariadicParam) {
                expectedArgumentType = methodUsage.getParamType(i);
            } else {
                boolean argumentIsArray;
                expectedArgumentType = methodUsage.getParamType(lastMethodUsageArgumentIndex);
                boolean bl4 = argumentIsArray = needleParameterCount == countOfMethodUsageArgumentsPassed && expectedArgumentType.isAssignableBy(actualArgumentType);
                if (!argumentIsArray) {
                    expectedArgumentType = expectedArgumentType.asArrayType().getComponentType();
                }
            }
            List<ResolvedTypeParameterDeclaration> typeParameters = methodUsage.getDeclaration().getTypeParameters();
            typeParameters.addAll(methodUsage.declaringType().getTypeParameters());
            ResolvedType expectedTypeWithoutSubstitutions = expectedArgumentType;
            ResolvedType expectedTypeWithInference = expectedArgumentType;
            HashMap<ResolvedTypeParameterDeclaration, ResolvedType> derivedValues = new HashMap<ResolvedTypeParameterDeclaration, ResolvedType>();
            for (int j = 0; j < countOfMethodUsageArgumentsPassed; ++j) {
                ResolvedParameterDeclaration resolvedParameterDeclaration = methodUsage.getDeclaration().getParam(j);
                ResolvedType parameterType = resolvedParameterDeclaration.getType();
                if (resolvedParameterDeclaration.isVariadic()) {
                    if (needleParameterCount == j) break;
                    parameterType = parameterType.asArrayType().getComponentType();
                }
                MethodResolutionLogic.inferTypes(needleParameterTypes.get(j), parameterType, derivedValues);
            }
            for (Map.Entry entry : derivedValues.entrySet()) {
                ResolvedTypeParameterDeclaration tp2 = (ResolvedTypeParameterDeclaration)entry.getKey();
                expectedTypeWithInference = expectedTypeWithInference.replaceTypeVariables(tp2, (ResolvedType)entry.getValue());
            }
            for (ResolvedTypeParameterDeclaration resolvedTypeParameterDeclaration : typeParameters) {
                if (resolvedTypeParameterDeclaration.getBounds().isEmpty()) {
                    expectedArgumentType = expectedArgumentType.replaceTypeVariables(resolvedTypeParameterDeclaration, ResolvedWildcard.extendsBound(new ReferenceTypeImpl(typeSolver.solveType(JAVA_LANG_OBJECT))));
                    continue;
                }
                if (resolvedTypeParameterDeclaration.getBounds().size() == 1) {
                    ResolvedTypeParameterDeclaration.Bound bound = resolvedTypeParameterDeclaration.getBounds().get(0);
                    if (bound.isExtends()) {
                        expectedArgumentType = expectedArgumentType.replaceTypeVariables(resolvedTypeParameterDeclaration, ResolvedWildcard.extendsBound(bound.getType()));
                        continue;
                    }
                    expectedArgumentType = expectedArgumentType.replaceTypeVariables(resolvedTypeParameterDeclaration, ResolvedWildcard.superBound(bound.getType()));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            ResolvedType expectedTypeWithSubstitutions = expectedTypeWithoutSubstitutions;
            for (ResolvedTypeParameterDeclaration tp : typeParameters) {
                if (tp.getBounds().isEmpty()) {
                    expectedTypeWithSubstitutions = expectedTypeWithSubstitutions.replaceTypeVariables(tp, new ReferenceTypeImpl(typeSolver.solveType(JAVA_LANG_OBJECT)));
                    continue;
                }
                if (tp.getBounds().size() == 1) {
                    ResolvedTypeParameterDeclaration.Bound bound = tp.getBounds().get(0);
                    if (bound.isExtends()) {
                        expectedTypeWithSubstitutions = expectedTypeWithSubstitutions.replaceTypeVariables(tp, bound.getType());
                        continue;
                    }
                    expectedTypeWithSubstitutions = expectedTypeWithSubstitutions.replaceTypeVariables(tp, new ReferenceTypeImpl(typeSolver.solveType(JAVA_LANG_OBJECT)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            boolean bl5 = bl2 = expectedArgumentType.isAssignableBy(actualArgumentType) || expectedTypeWithSubstitutions.isAssignableBy(actualArgumentType) || expectedTypeWithInference.isAssignableBy(actualArgumentType) || expectedTypeWithoutSubstitutions.isAssignableBy(actualArgumentType);
            if (!bl2) {
                boolean bl6 = bl = MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedArgumentType, actualArgumentType, typeSolver) || MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedTypeWithSubstitutions, actualArgumentType, typeSolver) || MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedTypeWithInference, actualArgumentType, typeSolver) || MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedTypeWithoutSubstitutions, actualArgumentType, typeSolver);
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean isBoxingCompatibleWithTypeSolver(ResolvedType expectedType, ResolvedType actualType, TypeSolver typeSolver) {
        ResolvedPrimitiveType expectedPrimitive;
        if (expectedType == null || actualType == null) {
            return false;
        }
        if (expectedType.isWildcard()) {
            ResolvedWildcard wildcard = expectedType.asWildcard();
            if (wildcard.isBounded()) {
                return MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(wildcard.getBoundedType(), actualType, typeSolver);
            }
            return actualType.isPrimitive();
        }
        if (expectedType.isArray() && actualType.isArray()) {
            ResolvedType expectedComponent = expectedType.asArrayType().getComponentType();
            ResolvedType actualComponent = actualType.asArrayType().getComponentType();
            return MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedComponent, actualComponent, typeSolver);
        }
        if (expectedType.isReferenceType() && actualType.isPrimitive()) {
            ResolvedReferenceType expectedRef = expectedType.asReferenceType();
            ResolvedPrimitiveType primitive = actualType.asPrimitive();
            String boxedTypeQName = primitive.getBoxTypeQName();
            try {
                ResolvedReferenceTypeDeclaration boxedTypeDecl = typeSolver.solveType(boxedTypeQName);
                ReferenceTypeImpl boxedType = new ReferenceTypeImpl(boxedTypeDecl);
                return expectedRef.isAssignableBy(boxedType);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (expectedType.isPrimitive() && actualType.isReferenceType()) {
            expectedPrimitive = expectedType.asPrimitive();
            ResolvedReferenceType actualRef = actualType.asReferenceType();
            if (ResolvedPrimitiveType.isBoxType(actualRef)) {
                Optional<ResolvedType> unboxed = ResolvedPrimitiveType.byBoxTypeQName(actualRef.getQualifiedName());
                return unboxed.isPresent() && unboxed.get().equals(expectedPrimitive);
            }
            String expectedBoxedTypeQName = expectedPrimitive.getBoxTypeQName();
            try {
                ResolvedReferenceTypeDeclaration expectedBoxedTypeDecl = typeSolver.solveType(expectedBoxedTypeQName);
                ReferenceTypeImpl expectedBoxedType = new ReferenceTypeImpl(expectedBoxedTypeDecl);
                if (((ResolvedReferenceType)expectedBoxedType).isAssignableBy(actualRef)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        if (expectedType.isPrimitive() && actualType.isPrimitive()) {
            expectedPrimitive = expectedType.asPrimitive();
            ResolvedPrimitiveType actualPrimitive = actualType.asPrimitive();
            return expectedPrimitive.isAssignableBy(actualPrimitive);
        }
        if (expectedType.isReferenceType() && actualType.isReferenceType()) {
            return false;
        }
        if (actualType.isConstraint()) {
            return MethodResolutionLogic.isBoxingCompatibleWithTypeSolver(expectedType, actualType.asConstraintType().getBound(), typeSolver);
        }
        return false;
    }

    private static MethodUsage substituteDeclaringTypeParameters(MethodUsage methodUsage, TypeSolver typeSolver) {
        ResolvedReferenceTypeDeclaration declaringTypeDeclaration = methodUsage.declaringType();
        ResolvedReferenceType declaringType = ReferenceTypeImpl.undeterminedParameters(declaringTypeDeclaration);
        List<ResolvedTypeParameterDeclaration> typeParams = declaringTypeDeclaration.getTypeParameters();
        if (!typeParams.isEmpty()) {
            List<ResolvedType> typeArgs = declaringType.typeParametersValues();
            if (typeParams.size() == typeArgs.size()) {
                for (int i = 0; i < methodUsage.getNoParams(); ++i) {
                    ResolvedType paramType = methodUsage.getParamType(i);
                    ResolvedType substitutedType = MethodResolutionLogic.substituteTypeVariables(paramType, typeParams, typeArgs);
                    if (substitutedType.equals(paramType)) continue;
                    methodUsage = methodUsage.replaceParamType(i, substitutedType);
                }
                ResolvedType returnType = methodUsage.returnType();
                ResolvedType substitutedReturnType = MethodResolutionLogic.substituteTypeVariables(returnType, typeParams, typeArgs);
                if (!substitutedReturnType.equals(returnType)) {
                    methodUsage = methodUsage.replaceReturnType(substitutedReturnType);
                }
            }
        }
        return methodUsage;
    }

    private static ResolvedType substituteTypeVariables(ResolvedType type, List<ResolvedTypeParameterDeclaration> typeParams, List<ResolvedType> typeArgs) {
        ResolvedType boundedType;
        ResolvedType substitutedBound;
        ResolvedWildcard wildcard;
        if (type.isTypeVariable()) {
            String varName = type.asTypeVariable().asTypeParameter().getName();
            for (int j = 0; j < typeParams.size(); ++j) {
                if (!typeParams.get(j).getName().equals(varName)) continue;
                return typeArgs.get(j);
            }
        }
        if (type.isWildcard() && (wildcard = type.asWildcard()).isBounded() && !(substitutedBound = MethodResolutionLogic.substituteTypeVariables(boundedType = wildcard.getBoundedType(), typeParams, typeArgs)).equals(boundedType)) {
            if (wildcard.isSuper()) {
                return ResolvedWildcard.superBound(substitutedBound);
            }
            return ResolvedWildcard.extendsBound(substitutedBound);
        }
        if (type.isReferenceType()) {
            ResolvedReferenceType refType = type.asReferenceType();
            List<ResolvedType> originalTypeParams = refType.typeParametersValues();
            ArrayList<ResolvedType> substitutedTypeParams = new ArrayList<ResolvedType>();
            boolean changed = false;
            for (ResolvedType typeParam : originalTypeParams) {
                ResolvedType substituted = MethodResolutionLogic.substituteTypeVariables(typeParam, typeParams, typeArgs);
                substitutedTypeParams.add(substituted);
                if (substituted.equals(typeParam)) continue;
                changed = true;
            }
            if (changed && refType.getTypeDeclaration().isPresent()) {
                return new ReferenceTypeImpl(refType.getTypeDeclaration().get(), substitutedTypeParams);
            }
        }
        return type;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static SymbolReference<ResolvedMethodDeclaration> findMostApplicable(List<ResolvedMethodDeclaration> methods, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        SymbolReference<ResolvedMethodDeclaration> res = MethodResolutionLogic.findMostApplicable(methods, name, argumentsTypes, typeSolver, false);
        if (res.isSolved()) {
            return res;
        }
        return MethodResolutionLogic.findMostApplicable(methods, name, argumentsTypes, typeSolver, true);
    }

    public static SymbolReference<ResolvedMethodDeclaration> findMostApplicable(List<ResolvedMethodDeclaration> methods, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver, boolean wildcardTolerance) {
        List applicableMethods = methods.stream().filter(m -> m.getName().equals(name)).filter(MethodResolutionLogic.distinctByKey(ResolvedMethodLikeDeclaration::getQualifiedSignature)).filter(m -> MethodResolutionLogic.isApplicable(m, name, argumentsTypes, typeSolver, wildcardTolerance)).collect(Collectors.toList());
        if (applicableMethods.isEmpty()) {
            return SymbolReference.unsolved();
        }
        if (applicableMethods.size() > 1) {
            ArrayList<Integer> nullParamIndexes = new ArrayList<Integer>();
            for (int i = 0; i < argumentsTypes.size(); ++i) {
                if (!argumentsTypes.get(i).isNull()) continue;
                nullParamIndexes.add(i);
            }
            if (!nullParamIndexes.isEmpty()) {
                HashSet<ResolvedMethodDeclaration> removeCandidates = new HashSet<ResolvedMethodDeclaration>();
                for (Integer nullParamIndex : nullParamIndexes) {
                    for (ResolvedMethodDeclaration methDecl : applicableMethods) {
                        if (!methDecl.getParam(nullParamIndex).getType().isArray()) continue;
                        removeCandidates.add(methDecl);
                    }
                }
                if (!removeCandidates.isEmpty() && removeCandidates.size() < applicableMethods.size()) {
                    applicableMethods.removeAll(removeCandidates);
                }
            }
        }
        if (applicableMethods.size() == 1) {
            return SymbolReference.solved((ResolvedMethodDeclaration)applicableMethods.get(0));
        }
        ResolvedMethodDeclaration winningCandidate = (ResolvedMethodDeclaration)applicableMethods.get(0);
        ResolvedMethodDeclaration other = null;
        boolean possibleAmbiguity = false;
        for (int i = 1; i < applicableMethods.size(); ++i) {
            other = (ResolvedMethodDeclaration)applicableMethods.get(i);
            if (MethodResolutionLogic.isMoreSpecific(winningCandidate, other, argumentsTypes)) {
                possibleAmbiguity = false;
                continue;
            }
            if (MethodResolutionLogic.isMoreSpecific(other, winningCandidate, argumentsTypes)) {
                possibleAmbiguity = false;
                winningCandidate = other;
                continue;
            }
            if (winningCandidate.isGeneric() && !other.isGeneric()) {
                winningCandidate = other;
                continue;
            }
            if (!winningCandidate.isGeneric() && other.isGeneric() || !winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName())) continue;
            possibleAmbiguity = true;
        }
        if (possibleAmbiguity && !MethodResolutionLogic.isExactMatch(winningCandidate, argumentsTypes)) {
            if (MethodResolutionLogic.isExactMatch(other, argumentsTypes)) {
                winningCandidate = other;
            } else {
                throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method: " + winningCandidate + ", " + other);
            }
        }
        return SymbolReference.solved(winningCandidate);
    }

    protected static boolean isExactMatch(ResolvedMethodLikeDeclaration method, List<ResolvedType> argumentsTypes) {
        for (int i = 0; i < method.getNumberOfParams(); ++i) {
            ResolvedType paramType = MethodResolutionLogic.getMethodsExplicitAndVariadicParameterType(method, i);
            if (paramType == null) {
                return false;
            }
            if (i >= argumentsTypes.size()) {
                return false;
            }
            if (paramType.equals(argumentsTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public static ResolvedType getMethodsExplicitAndVariadicParameterType(ResolvedMethodLikeDeclaration method, int i) {
        int numberOfParams = method.getNumberOfParams();
        if (i < numberOfParams) {
            return method.getParam(i).getType();
        }
        if (method.hasVariadicParameter()) {
            return method.getParam(numberOfParams - 1).getType();
        }
        return null;
    }

    public static ResolvedType getMethodUsageExplicitAndVariadicParameterType(MethodUsage method, int i) {
        int numberOfParams = method.getNoParams();
        if (i < numberOfParams) {
            return method.getParamType(i);
        }
        if (method.getDeclaration().hasVariadicParameter()) {
            return method.getParamType(numberOfParams - 1);
        }
        return null;
    }

    static boolean isMoreSpecific(ResolvedMethodLikeDeclaration methodA, ResolvedMethodLikeDeclaration methodB, List<ResolvedType> argumentTypes) {
        boolean aVariadic = methodA.hasVariadicParameter();
        boolean bVariadic = methodB.hasVariadicParameter();
        int aNumberOfParams = methodA.getNumberOfParams();
        int bNumberOfParams = methodB.getNumberOfParams();
        int numberOfArgs = argumentTypes.size();
        ResolvedType lastArgType = numberOfArgs > 0 ? argumentTypes.get(numberOfArgs - 1) : null;
        boolean isLastArgArray = lastArgType != null && lastArgType.isArray();
        int omittedArgs = 0;
        boolean isMethodAMoreSpecific = false;
        if (!(aVariadic || aNumberOfParams != numberOfArgs || !bVariadic || bNumberOfParams == numberOfArgs && isLastArgArray)) {
            return true;
        }
        if (!(bVariadic || bNumberOfParams != numberOfArgs || !aVariadic || aNumberOfParams == numberOfArgs && isLastArgArray)) {
            return false;
        }
        if (aVariadic && bVariadic && aNumberOfParams == bNumberOfParams && numberOfArgs == aNumberOfParams - 1) {
            ++omittedArgs;
        }
        for (int i = 0; i < numberOfArgs + omittedArgs; ++i) {
            ResolvedType paramTypeA = MethodResolutionLogic.getMethodsExplicitAndVariadicParameterType(methodA, i);
            ResolvedType paramTypeB = MethodResolutionLogic.getMethodsExplicitAndVariadicParameterType(methodB, i);
            ResolvedType argType = null;
            if (i < argumentTypes.size()) {
                argType = argumentTypes.get(i);
            }
            if (paramTypeA == null) {
                return false;
            }
            if (paramTypeB == null) {
                return true;
            }
            if (argType != null && paramTypeA.isPrimitive() == argType.isPrimitive() && paramTypeB.isPrimitive() != argType.isPrimitive() && paramTypeA.isAssignableBy(argType)) {
                return true;
            }
            if (argType != null && paramTypeB.isPrimitive() == argType.isPrimitive() && paramTypeA.isPrimitive() != argType.isPrimitive() && paramTypeB.isAssignableBy(argType)) {
                return false;
            }
            if (i < numberOfArgs - 1 && (MethodResolutionLogic.isJavaLangObject(paramTypeB) || MethodResolutionLogic.isJavaLangObject(paramTypeA))) {
                isMethodAMoreSpecific = isMethodAMoreSpecific || MethodResolutionLogic.isJavaLangObject(paramTypeB);
            } else {
                boolean aAssignableFromB = paramTypeA.isAssignableBy(paramTypeB);
                boolean bAssignableFromA = paramTypeB.isAssignableBy(paramTypeA);
                if (bAssignableFromA && !aAssignableFromB) {
                    return true;
                }
                if (aAssignableFromB && !bAssignableFromA) {
                    return false;
                }
            }
            if (methodA.getNumberOfParams() <= i || methodB.getNumberOfParams() <= i) continue;
            boolean paramAVariadic = methodA.getParam(i).isVariadic();
            boolean paramBVariadic = methodB.getParam(i).isVariadic();
            if (paramAVariadic || !paramBVariadic) continue;
            return true;
        }
        if (aVariadic && !bVariadic) {
            return isLastArgArray;
        }
        if (!aVariadic && bVariadic) {
            return !isLastArgArray;
        }
        return isMethodAMoreSpecific;
    }

    private static boolean isJavaLangObject(ResolvedType paramType) {
        return paramType.isReferenceType() && paramType.asReferenceType().getQualifiedName().equals("java.lang.Object");
    }

    private static boolean isMoreSpecific(MethodUsage methodA, MethodUsage methodB, List<ResolvedType> argumentTypes) {
        return MethodResolutionLogic.isMoreSpecific(methodA.getDeclaration(), methodB.getDeclaration(), argumentTypes);
    }

    public static Optional<MethodUsage> findMostApplicableUsage(List<MethodUsage> methods, String name, List<ResolvedType> argumentsTypes, TypeSolver typeSolver) {
        List applicableMethods = methods.stream().filter(m -> MethodResolutionLogic.isApplicable(m, name, argumentsTypes, typeSolver)).collect(Collectors.toList());
        if (applicableMethods.isEmpty()) {
            return Optional.empty();
        }
        if (applicableMethods.size() == 1) {
            return Optional.of((MethodUsage)applicableMethods.get(0));
        }
        MethodUsage winningCandidate = (MethodUsage)applicableMethods.get(0);
        for (int i = 1; i < applicableMethods.size(); ++i) {
            MethodUsage other = (MethodUsage)applicableMethods.get(i);
            if (MethodResolutionLogic.isMoreSpecific(winningCandidate, other, argumentsTypes)) continue;
            if (MethodResolutionLogic.isMoreSpecific(other, winningCandidate, argumentsTypes)) {
                winningCandidate = other;
                continue;
            }
            if (!winningCandidate.declaringType().getQualifiedName().equals(other.declaringType().getQualifiedName()) || MethodResolutionLogic.areOverride(winningCandidate, other)) continue;
            throw new MethodAmbiguityException("Ambiguous method call: cannot find a most applicable method: " + winningCandidate + ", " + other + ". First declared in " + winningCandidate.declaringType().getQualifiedName());
        }
        return Optional.of(winningCandidate);
    }

    private static boolean areOverride(MethodUsage winningCandidate, MethodUsage other) {
        if (!winningCandidate.getName().equals(other.getName())) {
            return false;
        }
        if (winningCandidate.getNoParams() != other.getNoParams()) {
            return false;
        }
        for (int i = 0; i < winningCandidate.getNoParams(); ++i) {
            if (winningCandidate.getParamTypes().get(i).equals(other.getParamTypes().get(i))) continue;
            return false;
        }
        return true;
    }

    public static SymbolReference<ResolvedMethodDeclaration> solveMethodInType(ResolvedTypeDeclaration typeDeclaration, String name, List<ResolvedType> argumentsTypes) {
        return MethodResolutionLogic.solveMethodInType(typeDeclaration, name, argumentsTypes, false);
    }

    public static SymbolReference<ResolvedMethodDeclaration> solveMethodInType(ResolvedTypeDeclaration typeDeclaration, String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        if (typeDeclaration instanceof MethodResolutionCapability) {
            return ((MethodResolutionCapability)((Object)typeDeclaration)).solveMethod(name, argumentsTypes, staticOnly);
        }
        throw new UnsupportedOperationException(typeDeclaration.getClass().getCanonicalName());
    }

    public static void inferTypes(ResolvedType source, ResolvedType target, Map<ResolvedTypeParameterDeclaration, ResolvedType> mappings) {
        ResolvedReferenceType formalTypeAsReference;
        if (source.equals(target)) {
            return;
        }
        if (source.isReferenceType() && target.isReferenceType()) {
            ResolvedReferenceType sourceRefType = source.asReferenceType();
            ResolvedReferenceType targetRefType = target.asReferenceType();
            if (sourceRefType.getQualifiedName().equals(targetRefType.getQualifiedName()) && !sourceRefType.isRawType() && !targetRefType.isRawType()) {
                for (int i = 0; i < sourceRefType.typeParametersValues().size(); ++i) {
                    MethodResolutionLogic.inferTypes(sourceRefType.typeParametersValues().get(i), targetRefType.typeParametersValues().get(i), mappings);
                }
            }
            return;
        }
        if (source.isReferenceType() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                MethodResolutionLogic.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isWildcard() && target.isWildcard()) {
            if (source.asWildcard().isBounded() && target.asWildcard().isBounded()) {
                MethodResolutionLogic.inferTypes(source.asWildcard().getBoundedType(), target.asWildcard().getBoundedType(), mappings);
            }
            return;
        }
        if (source.isReferenceType() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isArray() && target.isArray()) {
            ResolvedType sourceComponentType = source.asArrayType().getComponentType();
            ResolvedType targetComponentType = target.asArrayType().getComponentType();
            MethodResolutionLogic.inferTypes(sourceComponentType, targetComponentType, mappings);
            return;
        }
        if (source.isArray() && target.isWildcard()) {
            if (target.asWildcard().isBounded()) {
                MethodResolutionLogic.inferTypes(source, target.asWildcard().getBoundedType(), mappings);
                return;
            }
            return;
        }
        if (source.isArray() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isWildcard() && target.isReferenceType()) {
            if (source.asWildcard().isBounded()) {
                MethodResolutionLogic.inferTypes(source.asWildcard().getBoundedType(), target, mappings);
            }
            return;
        }
        if (source.isConstraint() && target.isReferenceType()) {
            MethodResolutionLogic.inferTypes(source.asConstraintType().getBound(), target, mappings);
            return;
        }
        if (source.isConstraint() && target.isTypeVariable()) {
            MethodResolutionLogic.inferTypes(source.asConstraintType().getBound(), target, mappings);
            return;
        }
        if (source.isTypeVariable() && target.isTypeVariable()) {
            mappings.put(target.asTypeParameter(), source);
            return;
        }
        if (source.isTypeVariable()) {
            MethodResolutionLogic.inferTypes(target, source, mappings);
            return;
        }
        if (source.isPrimitive() || target.isPrimitive()) {
            return;
        }
        if (source.isNull()) {
            return;
        }
        if (target.isReferenceType() && (formalTypeAsReference = target.asReferenceType()).isJavaLangObject()) {
            return;
        }
    }
}

