/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.adtime;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.apache.directory.studio.valueeditors.adtime.ActiveDirectoryTimeUtils;
import org.apache.directory.studio.valueeditors.adtime.ActiveDirectoryTimeValueDialog;
import org.apache.directory.studio.valueeditors.adtime.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ActiveDirectoryTimeValueEditor
extends AbstractDialogStringValueEditor {
    public String getDisplayValue(IValue value) {
        String displayValue = super.getDisplayValue(value);
        if (!this.showRawValues()) {
            if ("0".equals(displayValue)) {
                return displayValue;
            }
            DateFormat targetFormat = DateFormat.getDateTimeInstance(2, 1);
            try {
                long adTimeValue = Long.parseLong(displayValue);
                Date date = ActiveDirectoryTimeUtils.convertToCalendar(adTimeValue).getTime();
                displayValue = String.valueOf(targetFormat.format(date)) + " (" + displayValue + ")";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return displayValue;
    }

    protected boolean openDialog(Shell shell) {
        Object value = this.getValue();
        if (value instanceof String) {
            String s = (String)value;
            long adTimeValue = 0L;
            if (!"".equals(s)) {
                try {
                    adTimeValue = Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                    if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("ActiveDirectoryTimeValueEditor.BogusDateAndTimeValue"), (String)NLS.bind((String)Messages.getString("ActiveDirectoryTimeValueEditor.TheValueIsBogus"), (Object[])new String[]{s}))) {
                        adTimeValue = ActiveDirectoryTimeUtils.convertToActiveDirectoryTime(Calendar.getInstance());
                    }
                    return false;
                }
            } else {
                adTimeValue = ActiveDirectoryTimeUtils.convertToActiveDirectoryTime(Calendar.getInstance());
            }
            ActiveDirectoryTimeValueDialog dialog = new ActiveDirectoryTimeValueDialog(shell, adTimeValue);
            if (dialog.open() == 0) {
                this.setValue(Long.toString(dialog.getValue()));
                return true;
            }
        }
        return false;
    }
}

