/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.view.dialogs.Messages;
import org.apache.directory.studio.schemaeditor.view.search.SearchPage;
import org.apache.directory.studio.schemaeditor.view.views.SearchView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PreviousSearchesDialog
extends Dialog {
    private SearchView view;
    private TableViewer tableViewer;
    private Button openButton;
    private Button removeButton;

    public PreviousSearchesDialog(SearchView view) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.view = view;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("PreviousSearchesDialog.Previous"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("PreviousSearchesDialog.ShowResultsInView"));
        label.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.tableViewer = new TableViewer(composite, 2820);
        GridData gd = new GridData(4, 0, true, false);
        gd.widthHint = 300;
        gd.heightHint = 200;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Activator.getDefault().getImage("resources/icons/search_history_item.gif");
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreviousSearchesDialog.this.openButton.setEnabled(!event.getSelection().isEmpty());
                PreviousSearchesDialog.this.removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PreviousSearchesDialog.this.buttonPressed(0);
            }
        });
        this.removeButton = new Button(composite, 0);
        this.removeButton.setText(Messages.getString("PreviousSearchesDialog.Remove"));
        this.removeButton.setLayoutData((Object)new GridData(0, 1, false, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)PreviousSearchesDialog.this.tableViewer.getSelection();
                String selectedSearch = (String)selection.getFirstElement();
                SearchPage.removeSearchStringHistory(selectedSearch);
                PreviousSearchesDialog.this.initTableViewer();
            }
        });
        this.initTableViewer();
        return composite;
    }

    private void initTableViewer() {
        this.tableViewer.setInput((Object)SearchPage.loadSearchStringHistory());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.openButton = this.createButton(parent, 0, Messages.getString("PreviousSearchesDialog.Open"), true);
        this.openButton.setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.tableViewer.getSelection().isEmpty()) {
            StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
            String selectedSearch = (String)selection.getFirstElement();
            this.view.setSearchInput(selectedSearch, SearchPage.loadSearchIn().toArray(new SearchPage.SearchInEnum[0]), SearchPage.loadScope());
        }
        super.buttonPressed(buttonId);
    }
}

