/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.wizards;

import java.util.List;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.ui.wizards.BatchOperationWizard;
import org.apache.directory.studio.ldapbrowser.ui.wizards.Messages;
import org.apache.directory.studio.ldifeditor.widgets.LdifEditorWidget;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BatchOperationLdifWizardPage
extends WizardPage
implements WidgetModifyListener {
    private static final String LDIF_DN_PREFIX = "dn: cn=dummy" + BrowserCoreConstants.LINE_SEPARATOR;
    private static final String LDIF_INITIAL = "changetype: modify" + BrowserCoreConstants.LINE_SEPARATOR;
    private BatchOperationWizard wizard;
    private LdifEditorWidget ldifEditorWidget;

    public BatchOperationLdifWizardPage(String pageName, BatchOperationWizard wizard) {
        super(pageName);
        super.setTitle(Messages.getString("BatchOperationLdifWizardPage.LDIFFragment"));
        super.setDescription(Messages.getString("BatchOperationLdifWizardPage.PleaseEnterLDIFFragment"));
        super.setPageComplete(false);
        this.wizard = wizard;
    }

    public void dispose() {
        this.ldifEditorWidget.dispose();
        super.dispose();
    }

    private void validate() {
        LdifFile model = this.ldifEditorWidget.getLdifModel();
        List containers = model.getContainers();
        if (containers.size() == 0) {
            this.setPageComplete(false);
            return;
        }
        for (LdifContainer ldifContainer : containers) {
            if (ldifContainer.isValid()) continue;
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    public boolean isPageComplete() {
        if (this.wizard.getTypePage().getOperationType() != 2) {
            return true;
        }
        return super.isPageComplete();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.ldifEditorWidget = new LdifEditorWidget(null, String.valueOf(LDIF_DN_PREFIX) + LDIF_INITIAL, true);
        this.ldifEditorWidget.createWidget(composite);
        this.ldifEditorWidget.addWidgetModifyListener((WidgetModifyListener)this);
        this.ldifEditorWidget.getSourceViewer().getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.start < LDIF_DN_PREFIX.length() || e.end < LDIF_DN_PREFIX.length()) {
                    e.doit = false;
                }
            }
        });
        this.validate();
        this.setControl((Control)composite);
    }

    public String getLdifFragment() {
        return this.ldifEditorWidget.getLdifModel().toRawString().replaceAll(LDIF_DN_PREFIX, "");
    }

    public void widgetModified(WidgetModifyEvent event) {
        this.validate();
    }
}

