/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.ThetaUnion;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    @Test
    public void checkToString() {
        int k = 4096;
        int u = 8192;
        int bytes = 65536 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        byte[] byteArray = new byte[bytes];
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        UpdatableThetaSketch quick1 = UpdatableThetaSketch.builder().setNominalEntries(4096).build(seg);
        PreambleUtilTest.println(ThetaSketch.toString((byte[])byteArray));
        Assert.assertTrue((boolean)quick1.isEmpty());
        for (int i = 0; i < 8192; ++i) {
            quick1.update((long)i);
        }
        PreambleUtilTest.println("U: " + quick1.getEstimate());
        Assert.assertEquals((double)quick1.getEstimate(), (double)8192.0, (double)409.6);
        Assert.assertTrue((quick1.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
        PreambleUtilTest.println(quick1.toString());
        PreambleUtilTest.println(PreambleUtil.preambleToString((MemorySegment)seg));
        MemorySegment uSeg = MemorySegment.ofArray(new byte[ThetaSetOperation.getMaxUnionBytes((int)4096)]);
        ThetaUnion union = ThetaSetOperation.builder().setNominalEntries(4096).buildUnion(uSeg);
        union.union((ThetaSketch)quick1);
        PreambleUtilTest.println(PreambleUtil.preambleToString((MemorySegment)uSeg));
    }

    @Test
    public void checkToStringWithPrelongsOf2() {
        int k = 16;
        int u = 16;
        UpdatableThetaSketch quick1 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            quick1.update((long)i);
        }
        byte[] bytes = quick1.compact().toByteArray();
        PreambleUtilTest.println(ThetaSketch.toString((byte[])bytes));
    }

    @Test
    public void checkPreambleToStringExceptions() {
        byte[] byteArr = new byte[7];
        try {
            ThetaSketch.toString((byte[])byteArr);
            Assert.fail((String)"Did not throw SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        byteArr = new byte[8];
        byteArr[0] = 2;
        try {
            ThetaSketch.toString((MemorySegment)MemorySegment.ofArray(byteArr).asReadOnly());
            Assert.fail((String)"Did not throw SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSeedHashFromSeed() {
        Util.computeSeedHash((long)50541L);
    }

    @Test
    public void checkPreLongs() {
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        CompactThetaSketch comp = sketch.compact(false, null);
        byte[] byteArr = comp.toByteArray();
        PreambleUtilTest.println(ThetaSketch.toString((byte[])byteArr));
        sketch.update(1L);
        comp = sketch.compact(false, null);
        byteArr = comp.toByteArray();
        PreambleUtilTest.println(ThetaSketch.toString((byte[])byteArr));
        for (int i = 2; i <= 32; ++i) {
            sketch.update((long)i);
        }
        comp = sketch.compact(false, null);
        byteArr = comp.toByteArray();
        PreambleUtilTest.println(ThetaSketch.toString((MemorySegment)MemorySegment.ofArray(byteArr).asReadOnly()));
    }

    @Test
    public void checkInsertsAndExtracts() {
        byte[] arr = new byte[32];
        MemorySegment wseg = MemorySegment.ofArray(arr);
        int v = 0;
        PreambleUtil.insertPreLongs((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractPreLongs((MemorySegment)wseg), (int)v);
        PreambleUtil.insertPreLongs((MemorySegment)wseg, (int)0);
        PreambleUtil.insertLgResizeFactor((MemorySegment)wseg, (int)3);
        Assert.assertEquals((int)PreambleUtil.extractLgResizeFactor((MemorySegment)wseg), (int)3);
        PreambleUtil.insertLgResizeFactor((MemorySegment)wseg, (int)0);
        PreambleUtil.insertSerVer((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractSerVer((MemorySegment)wseg), (int)v);
        PreambleUtil.insertSerVer((MemorySegment)wseg, (int)0);
        PreambleUtil.insertFamilyID((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractFamilyID((MemorySegment)wseg), (int)v);
        PreambleUtil.insertFamilyID((MemorySegment)wseg, (int)0);
        PreambleUtil.insertLgNomLongs((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractLgNomLongs((MemorySegment)wseg), (int)v);
        PreambleUtil.insertLgNomLongs((MemorySegment)wseg, (int)0);
        PreambleUtil.insertLgArrLongs((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractLgArrLongs((MemorySegment)wseg), (int)v);
        PreambleUtil.insertLgArrLongs((MemorySegment)wseg, (int)0);
        PreambleUtil.insertFlags((MemorySegment)wseg, (int)3);
        Assert.assertEquals((int)PreambleUtil.extractFlags((MemorySegment)wseg), (int)3);
        PreambleUtil.insertFlags((MemorySegment)wseg, (int)0);
        PreambleUtil.insertSeedHash((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractSeedHash((MemorySegment)wseg), (int)v);
        PreambleUtil.insertSeedHash((MemorySegment)wseg, (int)0);
        PreambleUtil.insertCurCount((MemorySegment)wseg, (int)(++v));
        Assert.assertEquals((int)PreambleUtil.extractCurCount((MemorySegment)wseg), (int)v);
        PreambleUtil.insertCurCount((MemorySegment)wseg, (int)0);
        PreambleUtil.insertP((MemorySegment)wseg, (float)1.0f);
        Assert.assertEquals((float)PreambleUtil.extractP((MemorySegment)wseg), (float)1.0f);
        PreambleUtil.insertP((MemorySegment)wseg, (float)0.0f);
        PreambleUtil.insertThetaLong((MemorySegment)wseg, (long)(++v));
        Assert.assertEquals((long)PreambleUtil.extractThetaLong((MemorySegment)wseg), (long)v);
        PreambleUtil.insertThetaLong((MemorySegment)wseg, (long)0L);
        PreambleUtil.insertUnionThetaLong((MemorySegment)wseg, (long)(++v));
        Assert.assertEquals((long)PreambleUtil.extractUnionThetaLong((MemorySegment)wseg), (long)v);
        PreambleUtil.insertUnionThetaLong((MemorySegment)wseg, (long)0L);
        PreambleUtil.setEmpty((MemorySegment)wseg);
        Assert.assertTrue((boolean)PreambleUtil.isEmptyFlag((MemorySegment)wseg));
        PreambleUtil.clearEmpty((MemorySegment)wseg);
        Assert.assertFalse((boolean)PreambleUtil.isEmptyFlag((MemorySegment)wseg));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

