/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import com.typesafe.scalalogging.Logger;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeULong;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.runtime1.infoset.DIElement;
import passera.unsigned.ULong;
import passera.unsigned.ULong$;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class LengthState {
    private final DIElement ie;
    private Object maybeStartDataOutputStream;
    private long maybeStartPos0bInBits;
    private Object maybeEndDataOutputStream;
    private long maybeEndPos0bInBits;
    private long maybeComputedLengthInBits;

    public LengthState(DIElement ie) {
        this.ie = ie;
        this.maybeStartDataOutputStream = Maybe$.MODULE$.Nope();
        this.maybeStartPos0bInBits = MaybeULong$.MODULE$.Nope();
        this.maybeEndDataOutputStream = Maybe$.MODULE$.Nope();
        this.maybeEndPos0bInBits = MaybeULong$.MODULE$.Nope();
        this.maybeComputedLengthInBits = MaybeULong$.MODULE$.Nope();
    }

    public abstract String flavor();

    public String toString() {
        Object object;
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        try {
            Tuple3 tuple3 = MaybeULong$.MODULE$.isEmpty$extension(this.maybeStartPos0bInBits()) ? Tuple3$.MODULE$.apply((Object)"unk", (Object)"", (Object)"") : Tuple3$.MODULE$.apply((Object)"", (Object)new MaybeULong(this.maybeStartPos0bInBits()), (Object)this.stDOSid$1(lazyRef));
            String stStatus = (String)tuple3._1();
            Object stAbs = tuple3._2();
            String stDOS = (String)tuple3._3();
            Tuple3 tuple32 = MaybeULong$.MODULE$.isEmpty$extension(this.maybeEndPos0bInBits()) ? Tuple3$.MODULE$.apply((Object)"unk", (Object)"", (Object)"") : Tuple3$.MODULE$.apply((Object)"", (Object)new MaybeULong(this.maybeEndPos0bInBits()), (Object)this.eDOSid$1(lazyRef2));
            String eStatus = (String)tuple32._1();
            Object eAbs = tuple32._2();
            String eDOS = (String)tuple32._3();
            object = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s(%s%s%s, %s%s%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.flavor(), stStatus, stAbs, stDOS, eStatus, eAbs, eDOS}));
        }
        catch (Throwable th) {
            String res = this.flavor() + "(" + this.hashCode() + ")";
            object = res;
        }
        return object;
    }

    public Object maybeStartDataOutputStream() {
        return this.maybeStartDataOutputStream;
    }

    public void maybeStartDataOutputStream_$eq(Object x$1) {
        this.maybeStartDataOutputStream = x$1;
    }

    public long maybeStartPos0bInBits() {
        return this.maybeStartPos0bInBits;
    }

    public void maybeStartPos0bInBits_$eq(long x$1) {
        this.maybeStartPos0bInBits = x$1;
    }

    public Object maybeEndDataOutputStream() {
        return this.maybeEndDataOutputStream;
    }

    public void maybeEndDataOutputStream_$eq(Object x$1) {
        this.maybeEndDataOutputStream = x$1;
    }

    public long maybeEndPos0bInBits() {
        return this.maybeEndPos0bInBits;
    }

    public void maybeEndPos0bInBits_$eq(long x$1) {
        this.maybeEndPos0bInBits = x$1;
    }

    public long maybeComputedLengthInBits() {
        return this.maybeComputedLengthInBits;
    }

    public void maybeComputedLengthInBits_$eq(long x$1) {
        this.maybeComputedLengthInBits = x$1;
    }

    public void copyFrom(LengthState other) {
        this.maybeStartDataOutputStream_$eq(other.maybeStartDataOutputStream());
        this.maybeStartPos0bInBits_$eq(other.maybeStartPos0bInBits());
        this.maybeEndDataOutputStream_$eq(other.maybeEndDataOutputStream());
        this.maybeEndPos0bInBits_$eq(other.maybeEndPos0bInBits());
        this.maybeComputedLengthInBits_$eq(other.maybeComputedLengthInBits());
    }

    public void clear() {
        this.maybeStartDataOutputStream_$eq(Maybe$.MODULE$.Nope());
        this.maybeStartPos0bInBits_$eq(MaybeULong$.MODULE$.Nope());
        this.maybeEndDataOutputStream_$eq(Maybe$.MODULE$.Nope());
        this.maybeEndPos0bInBits_$eq(MaybeULong$.MODULE$.Nope());
        this.maybeComputedLengthInBits_$eq(MaybeULong$.MODULE$.Nope());
    }

    public abstract Nothing$ throwUnknown();

    private void recheckStreams() {
        Object object;
        Object object2 = this.maybeStartDataOutputStream();
        if (Maybe$.MODULE$.isDefined$extension(object2)) {
            if (!MaybeULong$.MODULE$.isDefined$extension(this.maybeStartPos0bInBits())) {
                throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeStartPos0bInBits.isDefined");
            }
            Object object3 = this.maybeStartDataOutputStream();
            DirectOrBufferedDataOutputStream dos = (DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object3));
            if (MaybeULong$.MODULE$.isDefined$extension(dos.maybeAbsBitPos0b())) {
                long thisRelStartPos0bInBits = MaybeULong$.MODULE$.getULong$extension(this.maybeStartPos0bInBits());
                long newStartBitPos0b = dos.toAbsolute(thisRelStartPos0bInBits);
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("{}gth for {} new absolute start pos: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), new ULong(newStartBitPos0b)}), Object.class));
                }
                this.maybeStartDataOutputStream_$eq(Maybe$.MODULE$.Nope());
                this.maybeStartPos0bInBits_$eq(MaybeULong$.MODULE$.apply(newStartBitPos0b));
            }
        }
        if (Maybe$.MODULE$.isDefined$extension(object = this.maybeEndDataOutputStream())) {
            if (!MaybeULong$.MODULE$.isDefined$extension(this.maybeEndPos0bInBits())) {
                throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeEndPos0bInBits.isDefined");
            }
            Object object4 = this.maybeEndDataOutputStream();
            DirectOrBufferedDataOutputStream dos = (DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object4));
            if (MaybeULong$.MODULE$.isDefined$extension(dos.maybeAbsBitPos0b())) {
                long thisRelEndPos0bInBits = MaybeULong$.MODULE$.getULong$extension(this.maybeEndPos0bInBits());
                long newEndBitPos0b = dos.toAbsolute(thisRelEndPos0bInBits);
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("{}gth for {} new absolute end pos: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), new ULong(newEndBitPos0b)}), Object.class));
                }
                this.maybeEndDataOutputStream_$eq(Maybe$.MODULE$.Nope());
                this.maybeEndPos0bInBits_$eq(MaybeULong$.MODULE$.apply(newEndBitPos0b));
                return;
            }
            return;
        }
    }

    public boolean isStartUndef() {
        Object object;
        boolean r = MaybeULong$.MODULE$.isEmpty$extension(this.maybeStartPos0bInBits());
        if (r && !Maybe$.MODULE$.isEmpty$extension(object = this.maybeStartDataOutputStream())) {
            throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeStartDataOutputStream.isEmpty");
        }
        return r;
    }

    public boolean isEndUndef() {
        Object object;
        boolean r = MaybeULong$.MODULE$.isEmpty$extension(this.maybeEndPos0bInBits());
        if (r && !Maybe$.MODULE$.isEmpty$extension(object = this.maybeEndDataOutputStream())) {
            throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeEndDataOutputStream.isEmpty");
        }
        return r;
    }

    public boolean isStartAbsolute() {
        Object object;
        return MaybeULong$.MODULE$.isDefined$extension(this.maybeStartPos0bInBits()) && Maybe$.MODULE$.isEmpty$extension(object = this.maybeStartDataOutputStream());
    }

    public boolean isEndAbsolute() {
        Object object;
        return MaybeULong$.MODULE$.isDefined$extension(this.maybeEndPos0bInBits()) && Maybe$.MODULE$.isEmpty$extension(object = this.maybeEndDataOutputStream());
    }

    public boolean isStartRelative() {
        Object object = this.maybeStartDataOutputStream();
        boolean res = Maybe$.MODULE$.isDefined$extension(object);
        if (res && !MaybeULong$.MODULE$.isDefined$extension(this.maybeStartPos0bInBits())) {
            throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeStartPos0bInBits.isDefined");
        }
        return res;
    }

    public boolean isEndRelative() {
        Object object = this.maybeEndDataOutputStream();
        boolean res = Maybe$.MODULE$.isDefined$extension(object);
        if (res && !MaybeULong$.MODULE$.isDefined$extension(this.maybeEndPos0bInBits())) {
            throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeEndPos0bInBits.isDefined");
        }
        return res;
    }

    public long maybeLengthInBits() {
        Object object;
        Object object2;
        Object object3;
        DataOutputStream dataOutputStream;
        long l;
        this.recheckStreams();
        if (MaybeULong$.MODULE$.isDefined$extension(this.maybeComputedLengthInBits())) {
            long len = MaybeULong$.MODULE$.get$extension(this.maybeComputedLengthInBits());
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{}gth of {} is {}, (was already computed)", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), BoxesRunTime.boxToLong((long)len)}), Object.class));
            }
            return this.maybeComputedLengthInBits();
        }
        if (this.isStartUndef() || this.isEndUndef()) {
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{}gth of {} cannot be computed yet. {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), this.toString()}), Object.class));
            }
            l = MaybeULong$.MODULE$.Nope();
        } else if (this.isStartAbsolute() && this.isEndAbsolute()) {
            long len = MaybeULong$.MODULE$.get$extension(this.maybeEndPos0bInBits()) - MaybeULong$.MODULE$.get$extension(this.maybeStartPos0bInBits());
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{}gth of {} is {}, by absolute positions. {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), BoxesRunTime.boxToLong((long)len), this.toString()}), Object.class));
            }
            l = MaybeULong$.MODULE$.apply(len);
        } else if (this.isStartRelative() && this.isEndRelative() && package$TypeEqual$.MODULE$._eq_$extension(dataOutputStream = (DataOutputStream)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual((DataOutputStream)Maybe$.MODULE$.get$extension(object3 = this.maybeStartDataOutputStream())), (DataOutputStream)Maybe$.MODULE$.get$extension(object2 = this.maybeEndDataOutputStream()), package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality())) {
            if (!MaybeULong$.MODULE$.isDefined$extension(this.maybeStartPos0bInBits())) {
                throw Assert$.MODULE$.abort("Invariant broken: LengthState.this.maybeStartPos0bInBits.isDefined");
            }
            long startPos = MaybeULong$.MODULE$.get$extension(this.maybeStartPos0bInBits());
            long endPos = MaybeULong$.MODULE$.get$extension(this.maybeEndPos0bInBits());
            long len = endPos - startPos;
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{}gth of {} is {}, by relative positions in same data stream. {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), BoxesRunTime.boxToLong((long)len), this.toString()}), Object.class));
            }
            l = MaybeULong$.MODULE$.apply(len);
        } else if (this.isStartRelative() && this.isEndRelative() && ((DataOutputStream)Maybe$.MODULE$.get$extension(object = this.maybeStartDataOutputStream())).isFinished()) {
            DirectOrBufferedDataOutputStream directOrBufferedDataOutputStream;
            Object object4 = this.maybeStartDataOutputStream();
            long len = ULong$.MODULE$.$plus$extension(ULong$.MODULE$.$minus$extension(((DataOutputStream)Maybe$.MODULE$.get$extension(object4)).relBitPos0b(), MaybeULong$.MODULE$.getULong$extension(this.maybeStartPos0bInBits())), MaybeULong$.MODULE$.getULong$extension(this.maybeEndPos0bInBits()));
            Object object5 = this.maybeEndDataOutputStream();
            DirectOrBufferedDataOutputStream dos = ((DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object5))).splitFrom();
            Object object6 = this.maybeStartDataOutputStream();
            DirectOrBufferedDataOutputStream stop = (DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object6));
            while (dos.isFinished() && package$TypeEqual$.MODULE$._ne_$extension(directOrBufferedDataOutputStream = (DirectOrBufferedDataOutputStream)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(dos), stop, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality())) {
                len = ULong$.MODULE$.$plus$extension(len, dos.relBitPos0b());
                dos = dos.splitFrom();
            }
            if (!dos.isFinished()) {
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("{}gth of {} is unknown due to unfinished output stream. {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), this.toString()}), Object.class));
                }
                l = MaybeULong$.MODULE$.Nope();
            } else {
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("{}gth of {} is {}, by relative positions in same data stream. {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), new ULong(len), this.toString()}), Object.class));
                }
                l = MaybeULong$.MODULE$.apply(ULong$.MODULE$.toLong$extension(len));
            }
        } else {
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{}gth of {} is unknown still. {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.flavor(), this.ie.name(), this.toString()}), Object.class));
            }
            l = MaybeULong$.MODULE$.Nope();
        }
        long computed = l;
        this.maybeComputedLengthInBits_$eq(computed);
        return computed;
    }

    public long lengthInBits() {
        long mlib = this.maybeLengthInBits();
        if (!MaybeULong$.MODULE$.isDefined$extension(mlib)) {
            throw this.throwUnknown();
        }
        return new ULong(MaybeULong$.MODULE$.getULong$extension(mlib)).longValue();
    }

    public long maybeLengthInBytes() {
        long mlib = this.maybeLengthInBits();
        if (MaybeULong$.MODULE$.isDefined$extension(mlib)) {
            long lbits = MaybeULong$.MODULE$.get$extension(mlib);
            long wholeBytes = (long)package$.MODULE$.ceil((double)lbits / 8.0);
            return MaybeULong$.MODULE$.apply(wholeBytes);
        }
        return MaybeULong$.MODULE$.Nope();
    }

    public long lengthInBytes() {
        long mlib = this.maybeLengthInBytes();
        if (!MaybeULong$.MODULE$.isDefined$extension(mlib)) {
            throw this.throwUnknown();
        }
        return new ULong(MaybeULong$.MODULE$.getULong$extension(mlib)).longValue();
    }

    public void setAbsStartPos0bInBits(long absPosInBits0b) {
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.maybeStartPos0bInBits())) {
            throw Assert$.MODULE$.abort("Invariant broken: " + ("maybeStartPos0bInBits already has a value: " + new MaybeULong(this.maybeStartPos0bInBits())) + "(LengthState.this.maybeStartPos0bInBits.isEmpty)");
        }
        this.maybeStartPos0bInBits_$eq(MaybeULong$.MODULE$.apply(absPosInBits0b));
        this.maybeStartDataOutputStream_$eq(Maybe$.MODULE$.Nope());
    }

    public void setRelStartPos0bInBits(long relPosInBits0b, DataOutputStream dos) {
        this.maybeStartPos0bInBits_$eq(MaybeULong$.MODULE$.apply(relPosInBits0b));
        this.maybeStartDataOutputStream_$eq(Maybe$One$.MODULE$.apply(dos));
    }

    public void setAbsEndPos0bInBits(long absPosInBits0b) {
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.maybeEndPos0bInBits())) {
            throw Assert$.MODULE$.abort("Invariant broken: " + ("maybeEndPos0bInBits already has a value: " + new MaybeULong(this.maybeEndPos0bInBits())) + "(LengthState.this.maybeEndPos0bInBits.isEmpty)");
        }
        this.maybeEndPos0bInBits_$eq(MaybeULong$.MODULE$.apply(absPosInBits0b));
        this.maybeEndDataOutputStream_$eq(Maybe$.MODULE$.Nope());
    }

    public void setRelEndPos0bInBits(long relPosInBits0b, DataOutputStream dos) {
        this.maybeEndPos0bInBits_$eq(MaybeULong$.MODULE$.apply(relPosInBits0b));
        this.maybeEndDataOutputStream_$eq(Maybe$One$.MODULE$.apply(dos));
    }

    public String diagnoseNoLength() {
        if (this.isStartRelative()) {
            Object object = this.maybeStartDataOutputStream();
            DirectOrBufferedDataOutputStream s = (DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object));
            return s.findFirstBlocking().toString();
        }
        if (this.isEndRelative()) {
            Object object = this.maybeEndDataOutputStream();
            DirectOrBufferedDataOutputStream s = (DirectOrBufferedDataOutputStream)((DataOutputStream)Maybe$.MODULE$.get$extension(object));
            return s.findFirstBlocking().toString();
        }
        if (this.isStartUndef()) {
            return this.toString();
        }
        if (this.isEndUndef()) {
            return this.toString();
        }
        throw Assert$.MODULE$.invariantFailed("absolute streams cannot block length calculations: " + this);
    }

    private final String stDOSid$lzyINIT1$1(LazyRef stDOSid$lzy1$1) {
        String string;
        LazyRef lazyRef = stDOSid$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (stDOSid$lzy1$1.initialized()) {
                object = stDOSid$lzy1$1.value();
            } else {
                String string2;
                Object object2 = this.maybeStartDataOutputStream();
                if (Maybe$.MODULE$.isDefined$extension(object2)) {
                    Object[] objectArray = new Object[1];
                    Object object3 = this.maybeStartDataOutputStream();
                    objectArray[0] = ((DataOutputStream)Maybe$.MODULE$.get$extension(object3)).id().toString();
                    string2 = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("DOS(id=%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
                } else {
                    string2 = "unk";
                }
                object = stDOSid$lzy1$1.initialize((Object)string2);
            }
            string = (String)object;
        }
        return string;
    }

    private final String stDOSid$1(LazyRef stDOSid$lzy1$2) {
        return (String)(stDOSid$lzy1$2.initialized() ? stDOSid$lzy1$2.value() : this.stDOSid$lzyINIT1$1(stDOSid$lzy1$2));
    }

    private final String eDOSid$lzyINIT1$1(LazyRef eDOSid$lzy1$1) {
        String string;
        LazyRef lazyRef = eDOSid$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (eDOSid$lzy1$1.initialized()) {
                object = eDOSid$lzy1$1.value();
            } else {
                String string2;
                Object object2 = this.maybeEndDataOutputStream();
                if (Maybe$.MODULE$.isDefined$extension(object2)) {
                    Object[] objectArray = new Object[1];
                    Object object3 = this.maybeEndDataOutputStream();
                    objectArray[0] = ((DataOutputStream)Maybe$.MODULE$.get$extension(object3)).id().toString();
                    string2 = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("DOS(id=%s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
                } else {
                    string2 = "unk";
                }
                object = eDOSid$lzy1$1.initialize((Object)string2);
            }
            string = (String)object;
        }
        return string;
    }

    private final String eDOSid$1(LazyRef eDOSid$lzy1$2) {
        return (String)(eDOSid$lzy1$2.initialized() ? eDOSid$lzy1$2.value() : this.eDOSid$lzyINIT1$1(eDOSid$lzy1$2));
    }
}

