/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.layers.runtime1;

import java.io.IOException;
import java.io.OutputStream;

class GZIPFixedOutputStream
extends OutputStream {
    private final OutputStream os;
    private int bytePosition = 0;

    public GZIPFixedOutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytePosition < 0) {
            this.os.write(byArray, n, n2);
        } else {
            super.write(byArray, n, n2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.bytePosition < 0) {
            this.os.write(n);
        } else if (this.bytePosition < 9) {
            this.os.write(n);
            ++this.bytePosition;
        } else if (this.bytePosition == 9) {
            this.os.write(255);
            this.bytePosition = -1;
        }
    }
}

