/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.processor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.spi.IDPCallback;
import org.apache.cxf.fediz.core.spi.RealmCallback;
import org.apache.cxf.fediz.core.spi.ReplyCallback;
import org.apache.cxf.fediz.core.spi.SignInQueryCallback;
import org.apache.cxf.fediz.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFedizProcessor
implements FedizProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFedizProcessor.class);

    protected String resolveIssuer(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object issuerObj = config.getProtocol().getIssuer();
        String issuerURL = null;
        if (issuerObj instanceof String) {
            issuerURL = (String)issuerObj;
        } else if (issuerObj instanceof CallbackHandler) {
            CallbackHandler issuerCB = (CallbackHandler)issuerObj;
            IDPCallback callback = new IDPCallback(request);
            issuerCB.handle(new Callback[]{callback});
            issuerURL = callback.getIssuerUrl().toString();
        }
        return issuerURL;
    }

    protected String resolveWTRealm(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object wtRealmObj = config.getProtocol().getRealm();
        String wtRealm = null;
        if (wtRealmObj != null) {
            if (wtRealmObj instanceof String) {
                wtRealm = (String)wtRealmObj;
            } else if (wtRealmObj instanceof CallbackHandler) {
                CallbackHandler hrCB = (CallbackHandler)wtRealmObj;
                RealmCallback callback = new RealmCallback(request);
                hrCB.handle(new Callback[]{callback});
                wtRealm = callback.getRealm();
            }
        } else {
            wtRealm = this.extractFullContextPath(request);
        }
        return wtRealm;
    }

    protected void testForReplayAttack(String tokenId, FedizContext config, Instant expires) throws ProcessingException {
        if (tokenId != null && config.isDetectReplayedTokens()) {
            if (!config.getTokenReplayCache().contains(tokenId)) {
                if (expires != null) {
                    config.getTokenReplayCache().add(tokenId, expires);
                } else {
                    config.getTokenReplayCache().add(tokenId);
                }
            } else {
                LOG.error("Replay attack with token id: " + tokenId);
                throw new ProcessingException("Replay attack with token id: " + tokenId, ProcessingException.TYPE.TOKEN_REPLAY);
            }
        }
    }

    protected String extractFullContextPath(HttpServletRequest request) throws MalformedURLException {
        return StringUtils.extractFullContextPath(request);
    }

    protected List<String> getRoles(List<Claim> claims, String roleURI) {
        if (roleURI == null || roleURI.isEmpty()) {
            return null;
        }
        return this.getRoles(claims, URI.create(roleURI));
    }

    protected List<String> getRoles(List<Claim> claims, URI roleURI) {
        if (claims == null || roleURI == null) {
            return null;
        }
        List<String> roles = null;
        for (Claim c : claims) {
            if (!roleURI.equals(c.getClaimType())) continue;
            Object oValue = c.getValue();
            if (oValue instanceof String && !"".equals(oValue)) {
                roles = Collections.singletonList((String)oValue);
                break;
            }
            if (oValue instanceof List && !((List)oValue).isEmpty()) {
                List values = (List)oValue;
                roles = Collections.unmodifiableList(values);
                break;
            }
            if (oValue instanceof String || oValue instanceof List) break;
            LOG.error("Unsupported value type of Claim value");
            throw new IllegalStateException("Unsupported value type of Claim value");
        }
        return roles;
    }

    protected String resolveReply(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object replyObj = config.getProtocol().getReply();
        String reply = null;
        if (replyObj != null) {
            if (replyObj instanceof String) {
                reply = (String)replyObj;
            } else if (replyObj instanceof CallbackHandler) {
                CallbackHandler replyCB = (CallbackHandler)replyObj;
                ReplyCallback callback = new ReplyCallback(request);
                replyCB.handle(new Callback[]{callback});
                reply = callback.getReply();
            }
        }
        return reply;
    }

    protected void testForMandatoryClaims(String roleURI, List<org.apache.cxf.fediz.core.config.Claim> requestedClaims, List<Claim> receivedClaims) throws ProcessingException {
        if (requestedClaims != null) {
            for (org.apache.cxf.fediz.core.config.Claim requestedClaim : requestedClaims) {
                if (requestedClaim.isOptional()) continue;
                boolean found = false;
                for (Claim receivedClaim : receivedClaims) {
                    if (!requestedClaim.getType().equals(receivedClaim.getClaimType().toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                LOG.warn("Mandatory claim {} not found in token", (Object)requestedClaim.getType());
                throw new ProcessingException("Mandatory claim not found in token", ProcessingException.TYPE.INVALID_REQUEST);
            }
        }
    }

    protected String resolveSignInQuery(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object signInQueryObj = config.getProtocol().getSignInQuery();
        String signInQuery = null;
        if (signInQueryObj != null) {
            if (signInQueryObj instanceof String) {
                signInQuery = (String)signInQueryObj;
            } else if (signInQueryObj instanceof CallbackHandler) {
                CallbackHandler frCB = (CallbackHandler)signInQueryObj;
                SignInQueryCallback callback = new SignInQueryCallback(request);
                frCB.handle(new Callback[]{callback});
                Map<String, String> signInQueryMap = callback.getSignInQueryParamMap();
                if (signInQueryMap != null) {
                    StringBuilder sbQuery = new StringBuilder();
                    for (Map.Entry<String, String> entry : signInQueryMap.entrySet()) {
                        if (sbQuery.length() > 0) {
                            sbQuery.append('&');
                        }
                        sbQuery.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                    }
                    signInQuery = sbQuery.toString();
                }
            }
        }
        return signInQuery;
    }
}

